/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.math.MathHelper;
import com.brandon3055.draconicevolution.blocks.DraconiumChest;
import com.brandon3055.draconicevolution.blocks.tileentity.chest.TileDraconiumChest;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DraconiumChestTileRenderer
implements BlockEntityRenderer<TileDraconiumChest> {
    private static final RenderType renderType = RenderType.entityCutout((ResourceLocation)new ResourceLocation("draconicevolution", "textures/block/draconium_chest.png"));
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;

    public DraconiumChestTileRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart chestRoot = DraconiumChestTileRenderer.createChestLayer().bakeRoot();
        this.bottom = chestRoot.getChild("bottom");
        this.lid = chestRoot.getChild("lid");
        this.lock = chestRoot.getChild("lock");
    }

    public static LayerDefinition createChestLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        root.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(0, 19).addBox(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f), PartPose.ZERO);
        root.addOrReplaceChild("lid", CubeListBuilder.create().texOffs(0, 0).addBox(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f), PartPose.offset((float)0.0f, (float)9.0f, (float)1.0f));
        root.addOrReplaceChild("lock", CubeListBuilder.create().texOffs(0, 0).addBox(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void render(TileDraconiumChest tile, float partialTicks, PoseStack mStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
        BlockState blockstate = tile.getBlockState();
        float rotation = ((Direction)blockstate.getValue((Property)DraconiumChest.FACING)).toYRot();
        float lidAngle = MathHelper.interpolate((float)tile.prevLidAngle, (float)tile.lidAngle, (float)partialTicks);
        lidAngle = 1.0f - lidAngle;
        lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
        this.renderChest(mStack, getter, rotation, lidAngle *= -1.5707965f, packedLight, packedOverlay, tile.colour.get());
    }

    public void renderChest(PoseStack mStack, MultiBufferSource getter, float rotation, float lidAngle, int packedLight, int packedOverlay, int colour) {
        mStack.pushPose();
        mStack.translate(0.5, 0.5, 0.5);
        mStack.mulPose(Axis.YP.rotationDegrees(-rotation));
        mStack.translate(-0.5, -0.5, -0.5);
        VertexConsumer buffer = getter.getBuffer(renderType);
        this.render(mStack, buffer, this.lid, this.lock, this.bottom, lidAngle, packedLight, packedOverlay, colour);
        mStack.popPose();
    }

    private void render(PoseStack mStack, VertexConsumer buffer, ModelPart lidRenderer, ModelPart lockRenderer, ModelPart bottomRenderer, float lidAngle, int packedLight, int packedOverlay, int colour) {
        float red = (float)(colour >> 16 & 0xFF) / 255.0f;
        float green = (float)(colour >> 8 & 0xFF) / 255.0f;
        float blue = (float)(colour & 0xFF) / 255.0f;
        lockRenderer.xRot = lidRenderer.xRot = lidAngle;
        lidRenderer.render(mStack, buffer, packedLight, packedOverlay, red, green, blue, 1.0f);
        lockRenderer.render(mStack, buffer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        bottomRenderer.render(mStack, buffer, packedLight, packedOverlay, red, green, blue, 1.0f);
    }
}

