/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.tile;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.lighting.LightModel;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import com.brandon3055.draconicevolution.blocks.machines.Generator;
import com.brandon3055.draconicevolution.blocks.tileentity.TileGenerator;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.state.properties.Property;

public class RenderTileGenerator
implements BlockEntityRenderer<TileGenerator> {
    private static final RenderType MODEL_TYPE = RenderType.SOLID;
    private static final ResourceLocation GEN_TEXTURE = new ResourceLocation("draconicevolution", "block/generator/generator_2");
    private final CCModel fanModel;

    public RenderTileGenerator(BlockEntityRendererProvider.Context context) {
        Map map = new OBJParser(new ResourceLocation("draconicevolution", "models/block/generator/generator_fan.obj")).quads().ignoreMtl().parse();
        this.fanModel = CCModel.combine(map.values()).backfacedCopy();
    }

    public void render(TileGenerator tile, float partialTicks, PoseStack mStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(GEN_TEXTURE);
        IconTransformation icon = new IconTransformation(sprite);
        if (icon.icon == null) {
            return;
        }
        Matrix4 mat = new Matrix4(mStack);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        ccrs.bind(MODEL_TYPE, getter);
        mat.translate(Vector3.CENTER);
        mat.apply((Transformation)new Rotation((double)((Direction)tile.getBlockState().getValue((Property)Generator.FACING)).getOpposite().toYRot() * -0.017453292519943, 0.0, 1.0, 0.0));
        mat.apply((Transformation)new Scale(0.0625));
        mat.apply(new Rotation((double)(tile.rotation + tile.rotationSpeed * partialTicks), 1.0, 0.0, 0.0).at(new Vector3(0.0, -1.5, -4.5)));
        this.fanModel.render(ccrs, new IVertexOperation[]{LightModel.standardLightModel, icon, mat});
    }
}

