/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.datagen;

import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleRegistry;
import com.brandon3055.draconicevolution.datagen.BlockLootProvider;
import com.brandon3055.draconicevolution.datagen.BlockStateGenerator;
import com.brandon3055.draconicevolution.datagen.BlockTagGenerator;
import com.brandon3055.draconicevolution.datagen.CuriosProvider;
import com.brandon3055.draconicevolution.datagen.DamageTypeGenerator;
import com.brandon3055.draconicevolution.datagen.DynamicTextures;
import com.brandon3055.draconicevolution.datagen.ItemModelGenerator;
import com.brandon3055.draconicevolution.datagen.ItemModelGenerator2DModels;
import com.brandon3055.draconicevolution.datagen.LangGenerator;
import com.brandon3055.draconicevolution.datagen.MultiBlockGenerator;
import com.brandon3055.draconicevolution.datagen.RecipeGenerator;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.DETags;
import com.brandon3055.draconicevolution.integration.equipment.CuriosIntegration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenEventHandler {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        gen.addProvider(event.includeClient(), (DataProvider)new LangGenerator(gen.getPackOutput()));
        gen.addProvider(event.includeClient(), (DataProvider)new BlockStateGenerator(gen, event.getExistingFileHelper()));
        gen.addProvider(event.includeClient(), (DataProvider)new ItemModelGenerator(gen, event.getExistingFileHelper()));
        gen.addProvider(event.includeClient(), (DataProvider)new ItemModelGenerator2DModels(gen, event.getExistingFileHelper()));
        gen.addProvider(event.includeClient(), (DataProvider)new MultiBlockGenerator(gen));
        gen.addProvider(event.includeClient(), (DataProvider)new DynamicTextures(gen, event.getExistingFileHelper()));
        gen.addProvider(event.includeServer(), (DataProvider)new RecipeGenerator(gen.getPackOutput()));
        gen.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(event.getGenerator().getPackOutput(), Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlockLootProvider::new, LootContextParamSets.BLOCK))));
        BlockTagGenerator blockGenerator = new BlockTagGenerator(gen.getPackOutput(), event.getLookupProvider(), "draconicevolution", event.getExistingFileHelper());
        gen.addProvider(event.includeServer(), (DataProvider)blockGenerator);
        gen.addProvider(event.includeServer(), (DataProvider)new ItemTagGenerator(gen.getPackOutput(), event.getLookupProvider(), blockGenerator.contentsGetter(), "draconicevolution", event.getExistingFileHelper()));
        gen.addProvider(event.includeServer(), (DataProvider)new DamageTypeGenerator(gen.getPackOutput(), event.getLookupProvider(), "draconicevolution", event.getExistingFileHelper()));
        gen.addProvider(event.includeServer(), (DataProvider)new CuriosProvider(event.getGenerator().getPackOutput(), event.getExistingFileHelper(), event.getLookupProvider()));
    }

    private static class ItemTagGenerator
    extends ItemTagsProvider {
        public ItemTagGenerator(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pLookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> pBlockTags, String modId, @Nullable ExistingFileHelper existingFileHelper) {
            super(pOutput, pLookupProvider, pBlockTags, modId, existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider pProvider) {
            this.tag(DETags.Items.DUSTS_DRACONIUM).add((Object)((Item)DEContent.DUST_DRACONIUM.get()));
            this.tag(DETags.Items.DUSTS_DRACONIUM_AWAKENED).add((Object)((Item)DEContent.DUST_DRACONIUM_AWAKENED.get()));
            this.tag(Tags.Items.DUSTS).addTags(new TagKey[]{DETags.Items.DUSTS_DRACONIUM_AWAKENED, DETags.Items.DUSTS_DRACONIUM});
            this.tag(DETags.Items.NUGGETS_DRACONIUM).add((Object)((Item)DEContent.NUGGET_DRACONIUM.get()));
            this.tag(DETags.Items.NUGGETS_DRACONIUM_AWAKENED).add((Object)((Item)DEContent.NUGGET_DRACONIUM_AWAKENED.get()));
            this.tag(Tags.Items.NUGGETS).addTags(new TagKey[]{DETags.Items.NUGGETS_DRACONIUM_AWAKENED, DETags.Items.NUGGETS_DRACONIUM});
            this.tag(DETags.Items.INGOTS_DRACONIUM).add((Object)((Item)DEContent.INGOT_DRACONIUM.get()));
            this.tag(DETags.Items.INGOTS_DRACONIUM_AWAKENED).add((Object)((Item)DEContent.INGOT_DRACONIUM_AWAKENED.get()));
            this.tag(Tags.Items.INGOTS).addTags(new TagKey[]{DETags.Items.INGOTS_DRACONIUM_AWAKENED, DETags.Items.INGOTS_DRACONIUM});
            this.tag(DETags.Items.STORAGE_BLOCKS_DRACONIUM).add((Object)((Item)DEContent.ITEM_DRACONIUM_BLOCK.get()));
            this.tag(DETags.Items.STORAGE_BLOCKS_DRACONIUM_AWAKENED).add((Object)((Item)DEContent.ITEM_AWAKENED_DRACONIUM_BLOCK.get()));
            this.tag(Tags.Items.STORAGE_BLOCKS).addTags(new TagKey[]{DETags.Items.STORAGE_BLOCKS_DRACONIUM, DETags.Items.STORAGE_BLOCKS_DRACONIUM_AWAKENED});
            this.tag(DETags.Items.ORES_DRACONIUM).add((Object[])new Item[]{(Item)DEContent.ITEM_END_DRACONIUM_ORE.get(), (Item)DEContent.ITEM_NETHER_DRACONIUM_ORE.get(), (Item)DEContent.ITEM_OVERWORLD_DRACONIUM_ORE.get()});
            this.tag(Tags.Items.ORES).addTag(DETags.Items.ORES_DRACONIUM);
            for (Module module : ModuleRegistry.getRegistry()) {
                this.tag(DETags.Items.MODULES).add((Object)module.getItem());
            }
            if (ModList.get().isLoaded("curios")) {
                CuriosIntegration.generateTags(x$0 -> this.tag((TagKey)x$0));
            }
        }
    }
}

