/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.datagen;

import codechicken.lib.datagen.recipe.AbstractItemStackRecipeBuilder;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.crafting.FusionRecipe;
import com.brandon3055.draconicevolution.api.crafting.StackIngredient;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class FusionRecipeBuilder
extends AbstractItemStackRecipeBuilder<FusionRecipeBuilder> {
    private final ItemStack result;
    private Ingredient catalyst = null;
    private long energy = -1L;
    private TechLevel techLevel = null;
    private List<FusionRecipe.FusionIngredient> ingredients = new ArrayList<FusionRecipe.FusionIngredient>();

    protected FusionRecipeBuilder(ResourceLocation id, ItemStack result) {
        super(id, result);
        this.result = result;
    }

    public static FusionRecipeBuilder builder(ItemLike result) {
        return FusionRecipeBuilder.builder(result, 1);
    }

    public static FusionRecipeBuilder builder(ItemLike result, int count) {
        return FusionRecipeBuilder.builder(new ItemStack(result, count));
    }

    public static FusionRecipeBuilder builder(ItemLike result, int count, ResourceLocation id) {
        return FusionRecipeBuilder.builder(new ItemStack(result, count), id);
    }

    public static FusionRecipeBuilder builder(ItemStack result) {
        return FusionRecipeBuilder.builder(result, BuiltInRegistries.ITEM.getKey((Object)result.getItem()));
    }

    public static FusionRecipeBuilder builder(ItemStack result, ResourceLocation id) {
        return new FusionRecipeBuilder(id, result);
    }

    public FusionRecipeBuilder catalyst(TagKey<Item> catalyst) {
        return this.catalyst(Ingredient.of(catalyst));
    }

    public FusionRecipeBuilder catalyst(Supplier<? extends ItemLike> catalyst) {
        return this.catalyst(Ingredient.of((ItemLike[])new ItemLike[]{catalyst.get()}));
    }

    public FusionRecipeBuilder catalyst(ItemLike ... catalyst) {
        return this.catalyst(Ingredient.of((ItemLike[])catalyst));
    }

    public FusionRecipeBuilder catalyst(ItemStack ... catalyst) {
        return this.catalyst(Ingredient.of((ItemStack[])catalyst));
    }

    public FusionRecipeBuilder catalyst(int count, TagKey<Item> catalyst) {
        return this.catalyst(StackIngredient.fromTag(catalyst, count));
    }

    public FusionRecipeBuilder catalyst(int count, ItemLike ... catalyst) {
        return this.catalyst(StackIngredient.fromItems(count, catalyst));
    }

    public FusionRecipeBuilder catalyst(int count, Supplier<? extends ItemLike> catalyst) {
        return this.catalyst(StackIngredient.fromItems(count, catalyst.get()));
    }

    public FusionRecipeBuilder catalyst(int count, ItemStack ... catalyst) {
        return this.catalyst(StackIngredient.fromStacks(count, catalyst));
    }

    public FusionRecipeBuilder catalyst(Ingredient catalyst) {
        this.catalyst = catalyst;
        return this;
    }

    public FusionRecipeBuilder energy(long totalEnergy) {
        this.energy = totalEnergy;
        return this;
    }

    public FusionRecipeBuilder techLevel(TechLevel techLevel) {
        this.techLevel = techLevel;
        return this;
    }

    public FusionRecipeBuilder ingredient(boolean consume, Ingredient ingredient) {
        this.ingredients.add(new FusionRecipe.FusionIngredient(ingredient, consume));
        return this;
    }

    public FusionRecipeBuilder ingredient(Ingredient ingredient) {
        return this.ingredient(true, ingredient);
    }

    public FusionRecipeBuilder ingredient(boolean consume, ItemStack ... ingredient) {
        return this.ingredient(consume, Ingredient.of((ItemStack[])ingredient));
    }

    public FusionRecipeBuilder ingredient(ItemStack ... ingredient) {
        return this.ingredient(true, ingredient);
    }

    public FusionRecipeBuilder ingredient(boolean consume, Supplier<? extends ItemLike> ingredient) {
        return this.ingredient(consume, Ingredient.of((ItemLike[])new ItemLike[]{ingredient.get()}));
    }

    public FusionRecipeBuilder ingredient(boolean consume, ItemLike ... ingredient) {
        return this.ingredient(consume, Ingredient.of((ItemLike[])ingredient));
    }

    public FusionRecipeBuilder ingredient(Supplier<? extends ItemLike> ingredient) {
        return this.ingredient(true, ingredient.get());
    }

    public FusionRecipeBuilder ingredient(ItemLike ... ingredient) {
        return this.ingredient(true, ingredient);
    }

    public FusionRecipeBuilder ingredient(boolean consume, TagKey<Item> ingredient) {
        return this.ingredient(consume, Ingredient.of(ingredient));
    }

    public FusionRecipeBuilder ingredient(TagKey<Item> ingredient) {
        return this.ingredient(true, ingredient);
    }

    protected void validate() {
        super.validate();
        if (this.catalyst == null) {
            throw new IllegalStateException("No catalyst is defined for fusion recipe " + this.id + "!");
        }
        if (this.energy == -1L) {
            throw new IllegalStateException("Energy requirement is not defined for fusion recipe " + this.id + "!");
        }
        if (this.techLevel == null) {
            throw new IllegalStateException("No TechLevel (crafting tier) is defined for fusion recipe " + this.id + "!");
        }
        if (this.ingredients.isEmpty()) {
            throw new IllegalStateException("No ingredients are defined for fusion recipe " + this.id + "!");
        }
    }

    public Recipe<?> _build() {
        return new FusionRecipe(this.result, this.catalyst, this.energy, this.techLevel, this.ingredients);
    }
}

