/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian;

import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.DEDamage;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class GuardianProjectileEntity
extends AbstractHurtingProjectile {
    private Vec3 target;
    private double splashRange = 15.0;
    private double power = 10.0;
    private double closestApproach;

    public GuardianProjectileEntity(EntityType<?> type, Level world) {
        super((EntityType)DEContent.ENTITY_GUARDIAN_PROJECTILE.get(), world);
    }

    public GuardianProjectileEntity(Level worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ, Vec3 target, double splashRange, double power) {
        super((EntityType)DEContent.ENTITY_GUARDIAN_PROJECTILE.get(), shooter, accelX, accelY, accelZ, worldIn);
        double accelDotProduct;
        this.target = target;
        this.splashRange = splashRange;
        this.power = power;
        if (target != null) {
            this.closestApproach = this.distanceToSqr(target);
        }
        if ((accelDotProduct = Math.sqrt(accelX * accelX + accelY * accelY + accelZ * accelZ)) != 0.0) {
            this.xPower = accelX / accelDotProduct * 0.3;
            this.yPower = accelY / accelDotProduct * 0.3;
            this.zPower = accelZ / accelDotProduct * 0.3;
        }
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        Entity shooter = this.getOwner();
        if (!(result.getType() == HitResult.Type.ENTITY && ((EntityHitResult)result).getEntity().is(shooter) || this.level().isClientSide)) {
            this.detonate();
        }
    }

    public void tick() {
        super.tick();
        if (this.target != null) {
            double distSq = this.distanceToSqr(this.target);
            if (distSq <= 1.0) {
                this.detonate();
            } else if (distSq < this.closestApproach) {
                this.closestApproach = distSq;
            } else if (this.tickCount > 5) {
                this.detonate();
            }
        }
    }

    private void detonate() {
        GuardianFightManager manager;
        List list = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(this.splashRange), EntitySelector.NO_CREATIVE_OR_SPECTATOR);
        Entity shooter = this.getOwner();
        for (LivingEntity entity : list) {
            double distance;
            double df;
            if (entity == shooter || (df = 1.0 - (distance = (double)entity.distanceTo((Entity)this)) / this.power) <= 0.0) continue;
            float damage = (int)(((df *= (double)Explosion.getSeenPercent((Vec3)this.position(), (Entity)entity)) * df + df) / 2.0 * 6.0 * this.power + 1.0);
            entity.hurt(DEDamage.guardianProjectile(this.level(), (Entity)this, shooter), damage);
        }
        boolean destroy = false;
        if (shooter instanceof DraconicGuardianEntity && (manager = ((DraconicGuardianEntity)shooter).getFightManager()) != null && this.blockPosition().getY() > manager.getArenaOrigin().getY() + 20) {
            destroy = true;
        }
        this.level().explode(shooter, (double)this.blockPosition().getX(), (double)this.blockPosition().getY(), (double)this.blockPosition().getZ(), 8.0f, destroy ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
        DraconicNetwork.sendImpactEffect(this.level(), this.blockPosition(), 0);
        this.discard();
    }

    public boolean isPickable() {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.DRAGON_BREATH;
    }

    protected boolean shouldBurn() {
        return false;
    }
}

