/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian;

import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.entity.GuardianCrystalEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.world.ChaosIslandFeature;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.level.Level;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum GuardianSpawnState {
    START_WAIT_FOR_PLAYER{

        @Override
        public void process(ServerLevel world, GuardianFightManager manager, List<EndCrystal> crystals, int ticks, BlockPos pos) {
            if (ticks % 20 == 0) {
                for (ServerPlayer player : manager.getTrackedPlayers()) {
                    if (!(pos.above(15).distSqr((Vec3i)player.blockPosition()) <= 225.0)) continue;
                    DraconicEvolution.LOGGER.info("Player In Range. Guardian spawn progressing to PREPARING_TO_SUMMON_PILLARS");
                    manager.setRespawnState(PREPARING_TO_SUMMON_PILLARS);
                }
            }
        }
    }
    ,
    PREPARING_TO_SUMMON_PILLARS{

        @Override
        public void process(ServerLevel world, GuardianFightManager manager, List<EndCrystal> crystals, int ticks, BlockPos pos) {
            if (ticks < 70) {
                if (ticks == 0 || ticks == 20 || ticks == 21 || ticks == 22 || ticks >= 65) {
                    world.levelEvent(3001, new BlockPos(pos.getX(), 128, pos.getZ()), 0);
                }
            } else {
                manager.setRespawnState(SUMMONING_PILLARS);
                DraconicEvolution.LOGGER.info("Guardian spawn progressing to SUMMONING_PILLARS");
            }
        }
    }
    ,
    SUMMONING_PILLARS{

        @Override
        public void process(ServerLevel level, GuardianFightManager manager, List<EndCrystal> crystals, int ticks, BlockPos pos) {
            boolean spawn;
            int spawnRate = 15;
            boolean bl = spawn = ticks % spawnRate == 0;
            if (spawn) {
                BlockPos nextSpawn = manager.getNextCrystalPos(ticks == 0);
                if (nextSpawn != null) {
                    for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)nextSpawn.offset(-10, -10, -10), (BlockPos)nextSpawn.offset(10, 10, 10))) {
                        level.removeBlock(blockpos, false);
                    }
                    ChaosIslandFeature.generateObelisk(level, nextSpawn, level.random);
                    level.setBlock(nextSpawn, ((BlockBCore)DEContent.INFUSED_OBSIDIAN.get()).defaultBlockState(), 3);
                    GuardianCrystalEntity crystal = new GuardianCrystalEntity((Level)level.getLevel(), (double)nextSpawn.getX() + 0.5, nextSpawn.getY() + 1, (double)nextSpawn.getZ() + 0.5, manager.getUniqueID());
                    crystal.setInvulnerable(true);
                    level.addFreshEntity((Entity)crystal);
                    crystal.setBeamTarget(pos.offset(0, 80, 0));
                    manager.crystalSpawned();
                } else {
                    manager.setRespawnState(SUMMONING_GUARDIAN);
                    DraconicEvolution.LOGGER.info("Guardian spawn progressing to SUMMONING_GUARDIAN");
                }
            }
        }
    }
    ,
    SUMMONING_GUARDIAN{

        @Override
        public void process(ServerLevel world, GuardianFightManager manager, List<EndCrystal> crystals, int ticks, BlockPos pos) {
            if (ticks >= 50) {
                manager.setRespawnState(END);
                manager.resetCrystals();
            } else if (ticks >= 30) {
                world.levelEvent(3001, pos.offset(0, 80, 0), 0);
            } else if (ticks < 5) {
                world.levelEvent(3001, pos.offset(0, 80, 0), 0);
            }
        }
    }
    ,
    END{

        @Override
        public void process(ServerLevel world, GuardianFightManager manager, List<EndCrystal> crystals, int ticks, BlockPos pos) {
        }
    };


    public abstract void process(ServerLevel var1, GuardianFightManager var2, List<EndCrystal> var3, int var4, BlockPos var5);
}

