/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import codechicken.lib.vec.Vector3;
import com.brandon3055.draconicevolution.client.sound.SimpleSoundImpl;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.brandon3055.draconicevolution.entity.guardian.control.ChargeUpPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import com.brandon3055.draconicevolution.entity.guardian.control.StartPhase;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEDamage;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class LaserBeamPhase
extends ChargeUpPhase {
    private static float BUILD_UP_TIME = 120.0f;
    private static float SECONDARY_DELAY = 10.0f;
    private static float SECONDARY_BUILD_UP = 20.0f;
    private boolean soundInitialized = false;
    private boolean secondarySoundInit = false;
    private Player attackTarget = null;
    private Vector3 beamPos = new Vector3();
    private DamageSource damage;
    private int laserTime = 0;
    private int maxLaserTime;

    public LaserBeamPhase(DraconicGuardianEntity guardian) {
        super(guardian, 60);
        this.damage = DEDamage.guardianLaser(guardian.level(), (Entity)guardian);
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (this.laserTime >= this.maxLaserTime) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START);
            return;
        }
        if (!this.selectTarget()) {
            return;
        }
        Vector3 guardianPos = Vector3.fromEntity((Entity)this.guardian);
        Vector3 targetPos = Vector3.fromEntity((Entity)this.attackTarget);
        Vector3 dirVec = targetPos.copy();
        dirVec.subtract(guardianPos);
        dirVec.normalize();
        float targetYaw = (float)(Mth.atan2((double)dirVec.x, (double)dirVec.z) * 57.2957763671875);
        this.guardian.setYRot(-targetYaw - 180.0f);
        Vector3 headPos = guardianPos.copy();
        float rotation = (this.guardian.getYRot() - 90.0f) / 360.0f * (float)Math.PI * 2.0f;
        headPos.add((double)(Mth.cos((float)rotation) * 7.0f), 0.0, (double)(Mth.sin((float)rotation) * 7.0f));
        this.beamPos = Vector3.fromEntityCenter((Entity)this.attackTarget);
        boolean obstructed = false;
        BlockHitResult result = this.guardian.level().clip(new ClipContext(headPos.vec3(), this.beamPos.vec3(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.guardian));
        if (result.getType() != HitResult.Type.MISS) {
            this.beamPos = new Vector3(result.getLocation());
            obstructed = true;
        }
        if (this.getBeamCharge() < 0.5f) {
            return;
        }
        float beamPower = (this.getBeamCharge() - 0.5f) / 0.5f;
        if (this.fireSecondary()) {
            DraconicNetwork.sendGuardianBeam(this.guardian.level(), headPos, this.beamPos, beamPower += this.getSecondaryCharge());
            beamPower += this.getSecondaryCharge() * 6.805647E37f;
        } else {
            DraconicNetwork.sendGuardianBeam(this.guardian.level(), headPos, this.beamPos, beamPower);
            beamPower *= 20.0f;
        }
        if (obstructed & this.chargedTime % 2 == 0) {
            this.guardian.level().explode(null, this.damage, null, this.beamPos.x, this.beamPos.y, this.beamPos.z, 8.0f, false, Level.ExplosionInteraction.MOB);
        } else if (!obstructed) {
            float prevHealth = this.attackTarget.getHealth();
            if (this.getSecondaryCharge() >= 1.0f) {
                this.attackTarget.getCombatTracker().recordDamage(this.damage, beamPower);
                this.attackTarget.setHealth(prevHealth - beamPower);
                this.attackTarget.gameEvent(GameEvent.ENTITY_DAMAGE, this.damage.getEntity());
                if (this.attackTarget.isDeadOrDying()) {
                    this.attackTarget.die(this.damage);
                }
            } else {
                this.attackTarget.hurt(this.damage, beamPower);
            }
        }
        if (this.getBeamCharge() >= 1.0f) {
            GuardianFightManager manager;
            if (this.laserTime == 0 && (manager = this.guardian.getFightManager()) != null) {
                manager.guardianUpdate(this.guardian);
            }
            ++this.laserTime;
        }
    }

    private boolean selectTarget() {
        if (this.attackTarget != null && this.isValidTarget((LivingEntity)this.attackTarget)) {
            return true;
        }
        Vec3 focus = Vec3.atCenterOf((Vec3i)this.guardian.getArenaOrigin());
        List targetOptions = this.guardian.level().players().stream().filter(e -> e.distanceToSqr(focus) <= 40000.0).filter(e -> StartPhase.AGRO_TARGETS.test((LivingEntity)this.guardian, (LivingEntity)e)).collect(Collectors.toList());
        if (targetOptions.isEmpty()) {
            this.guardian.getPhaseManager().setPhase(PhaseType.START);
            return false;
        }
        this.attackTarget = targetOptions.size() == 1 ? (Player)targetOptions.get(0) : (Player)targetOptions.get(this.random.nextInt(targetOptions.size()));
        this.beamPos = Vector3.fromEntityCenter((Entity)this.attackTarget);
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        super.clientTick();
        if (this.isCharged() && !this.soundInitialized) {
            this.soundInitialized = true;
            SimpleSoundImpl.create((SoundEvent)DESounds.BEAM.get(), SoundSource.HOSTILE, this.random).setPitchSupplier(() -> Float.valueOf(0.5f + this.getBeamCharge())).setStoppedSupplier(this::isEnded).setPos((Entity)this.guardian).setVolume(100.0f).loop().play(Minecraft.getInstance());
        }
        if (this.fireSecondary() && !this.secondarySoundInit) {
            this.secondarySoundInit = true;
            SimpleSoundImpl.create((SoundEvent)DESounds.BEAM.get(), SoundSource.HOSTILE, this.random).setPitchSupplier(() -> Float.valueOf(1.5f + this.getSecondaryCharge() / 2.0f)).setStoppedSupplier(this::isEnded).setPos((Entity)this.guardian).setVolume(100.0f).loop().play(Minecraft.getInstance());
        }
    }

    @Override
    public void initPhase() {
        super.initPhase();
        this.secondarySoundInit = false;
        this.soundInitialized = false;
        this.laserTime = 0;
        this.maxLaserTime = 120 + this.random.nextInt(120);
    }

    public float getBeamCharge() {
        return Math.min((float)this.chargedTime / BUILD_UP_TIME, 1.0f);
    }

    public boolean fireSecondary() {
        return (float)this.chargedTime - BUILD_UP_TIME - SECONDARY_DELAY > 0.0f;
    }

    public float getSecondaryCharge() {
        return Math.min(((float)this.chargedTime - BUILD_UP_TIME - SECONDARY_DELAY) / SECONDARY_BUILD_UP, 1.0f);
    }

    @Override
    public boolean isInvulnerable() {
        return (double)this.getBeamCharge() < 0.5;
    }

    public PhaseType<LaserBeamPhase> getType() {
        return PhaseType.LASER_BEAM;
    }
}

