/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.projectile;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.DEDamage;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;

public class DraconicArrowEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> ID_EFFECT_COLOR = SynchedEntityData.defineId(DraconicArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final ItemStack DEFAULT_ARROW_STACK = new ItemStack((ItemLike)Items.ARROW);
    private Potion potion = Potions.EMPTY;
    private final Set<MobEffectInstance> effects = Sets.newHashSet();
    private boolean fixedColor;
    private static final EntityDataAccessor<Integer> SPECTRAL_TIME = SynchedEntityData.defineId(DraconicArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Byte> TECH_LEVEL = SynchedEntityData.defineId(DraconicArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> PENETRATION = SynchedEntityData.defineId(DraconicArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Float> GRAV_COMPENSATION = SynchedEntityData.defineId(DraconicArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> INIT_VELOCITY = SynchedEntityData.defineId(DraconicArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> PROJ_ANTI_IMMUNE = SynchedEntityData.defineId(DraconicArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private int blockPenetration = 0;

    public DraconicArrowEntity(EntityType<? extends DraconicArrowEntity> p_36858_, Level p_36859_) {
        super(p_36858_, p_36859_, DEFAULT_ARROW_STACK);
    }

    public DraconicArrowEntity(EntityType<? extends DraconicArrowEntity> entityType, Level world, ItemStack arrowStack) {
        super(entityType, world, arrowStack);
    }

    public DraconicArrowEntity(Level world, double xPos, double yPos, double zPos, ItemStack arrowStack) {
        super((EntityType)DEContent.ENTITY_DRACONIC_ARROW.get(), xPos, yPos, zPos, world, arrowStack);
    }

    public DraconicArrowEntity(Level world, LivingEntity shooter, ItemStack arrowStack) {
        super((EntityType)DEContent.ENTITY_DRACONIC_ARROW.get(), shooter, world, arrowStack);
    }

    public void setSpectral(int spectralTime) {
        this.entityData.set(SPECTRAL_TIME, (Object)spectralTime);
    }

    public int getSpectralTime() {
        return (Integer)this.entityData.get(SPECTRAL_TIME);
    }

    public void setTechLevel(TechLevel techLevel) {
        this.entityData.set(TECH_LEVEL, (Object)((byte)techLevel.index));
    }

    public void setPenetration(float penetration) {
        int penCount = 0;
        while (penetration > this.random.nextFloat()) {
            ++penCount;
            penetration = (float)((double)penetration - 0.25);
        }
        this.entityData.set(PENETRATION, (Object)((byte)Math.min(penCount, 127)));
    }

    public void setProjectileImmuneOverride(boolean value) {
        this.entityData.set(PROJ_ANTI_IMMUNE, (Object)value);
    }

    public boolean getProjectileImmuneOverride() {
        return (Boolean)this.entityData.get(PROJ_ANTI_IMMUNE);
    }

    public void setGravComp(float gravComp) {
        this.entityData.set(GRAV_COMPENSATION, (Object)Float.valueOf(gravComp));
    }

    public void shoot(double p_70186_1_, double p_70186_3_, double p_70186_5_, float speed, float p_70186_8_) {
        super.shoot(p_70186_1_, p_70186_3_, p_70186_5_, speed, p_70186_8_);
        this.entityData.set(INIT_VELOCITY, (Object)Float.valueOf((float)this.getDeltaMovement().length()));
    }

    public void shootFromRotation(Entity p_234612_1_, float p_234612_2_, float p_234612_3_, float p_234612_4_, float speed, float p_234612_6_) {
        super.shootFromRotation(p_234612_1_, p_234612_2_, p_234612_3_, p_234612_4_, speed, p_234612_6_);
        this.entityData.set(INIT_VELOCITY, (Object)Float.valueOf((float)this.getDeltaMovement().length()));
    }

    public void tick() {
        this.superTick();
        if (this.level().isClientSide) {
            if (this.inGround) {
                if (this.inGroundTime % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        } else if (this.inGround && this.inGroundTime != 0 && !this.effects.isEmpty() && this.inGroundTime >= 600) {
            this.level().broadcastEntityEvent((Entity)this, (byte)0);
            this.potion = Potions.EMPTY;
            this.effects.clear();
            this.entityData.set(ID_EFFECT_COLOR, (Object)-1);
        }
    }

    private void superTick() {
        VoxelShape voxelshape;
        if (!this.leftOwner) {
            this.leftOwner = this.checkLeftOwner();
        }
        if (!this.level().isClientSide) {
            this.setSharedFlag(6, this.isCurrentlyGlowing());
        }
        this.baseTick();
        boolean flag = this.isNoPhysics();
        Vec3 vector3d = this.getDeltaMovement();
        if (this.xRotO == 0.0f && this.yRotO == 0.0f) {
            double f = vector3d.horizontalDistance();
            this.setYRot((float)(Mth.atan2((double)vector3d.x, (double)vector3d.z) * 57.2957763671875));
            this.setXRot((float)(Mth.atan2((double)vector3d.y, (double)f) * 57.2957763671875));
            this.yRotO = this.getYRot();
            this.xRotO = this.getXRot();
        }
        BlockPos blockpos = this.blockPosition();
        BlockState blockstate = this.level().getBlockState(blockpos);
        if (!(blockstate.isAir() || flag || (voxelshape = blockstate.getCollisionShape((BlockGetter)this.level(), blockpos)).isEmpty())) {
            Vec3 vector3d1 = this.position();
            for (AABB axisalignedbb : voxelshape.toAabbs()) {
                if (!axisalignedbb.move(blockpos).contains(vector3d1)) continue;
                this.inGround = true;
                break;
            }
        }
        if (this.shakeTime > 0) {
            --this.shakeTime;
        }
        if (this.isInWaterOrRain()) {
            this.clearFire();
        }
        if (this.inGround && !flag) {
            if (this.lastState != blockstate && this.shouldFall()) {
                this.startFalling();
            } else if (!this.level().isClientSide) {
                this.tickDespawn();
            }
            ++this.inGroundTime;
        } else {
            this.inGroundTime = 0;
            Vec3 vector3d2 = this.position();
            Vec3 vector3d3 = vector3d2.add(vector3d);
            BlockHitResult raytraceresult = this.level().clip(new ClipContext(vector3d2, vector3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (raytraceresult.getType() != HitResult.Type.MISS) {
                vector3d3 = raytraceresult.getLocation();
            }
            while (!this.isRemoved()) {
                EntityHitResult entityraytraceresult = this.findHitEntity(vector3d2, vector3d3);
                if (entityraytraceresult != null) {
                    raytraceresult = entityraytraceresult;
                }
                if (raytraceresult != null && raytraceresult.getType() == HitResult.Type.ENTITY) {
                    Entity entity = ((EntityHitResult)raytraceresult).getEntity();
                    Entity entity1 = this.getOwner();
                    if (entity instanceof Player && entity1 instanceof Player && !((Player)entity1).canHarmPlayer((Player)entity)) {
                        raytraceresult = null;
                        entityraytraceresult = null;
                    }
                }
                if (raytraceresult != null && raytraceresult.getType() != HitResult.Type.MISS && !flag) {
                    if (EventHooks.onProjectileImpact((Projectile)this, (HitResult)raytraceresult)) break;
                    this.onHit((HitResult)raytraceresult);
                    this.hasImpulse = true;
                }
                if (entityraytraceresult == null || this.getPierceLevel() <= 0 && (Byte)this.entityData.get(PENETRATION) <= 0) break;
                raytraceresult = null;
            }
            vector3d = this.getDeltaMovement();
            double d3 = vector3d.x;
            double d4 = vector3d.y;
            double d0 = vector3d.z;
            if (this.isCritArrow()) {
                for (int i = 0; i < 4; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.CRIT, this.getX() + d3 * (double)i / 4.0, this.getY() + d4 * (double)i / 4.0, this.getZ() + d0 * (double)i / 4.0, -d3, -d4 + 0.2, -d0);
                }
            }
            double d5 = this.getX() + d3;
            double d1 = this.getY() + d4;
            double d2 = this.getZ() + d0;
            double f1 = vector3d.horizontalDistance();
            if (flag) {
                this.setYRot((float)(Mth.atan2((double)(-d3), (double)(-d0)) * 57.2957763671875));
            } else {
                this.setYRot((float)(Mth.atan2((double)d3, (double)d0) * 57.2957763671875));
            }
            this.setXRot((float)(Mth.atan2((double)d4, (double)f1) * 57.2957763671875));
            this.setXRot(DraconicArrowEntity.lerpRotation((float)this.xRotO, (float)this.getXRot()));
            this.setYRot(DraconicArrowEntity.lerpRotation((float)this.yRotO, (float)this.getYRot()));
            float f2 = 0.99f;
            float f3 = 0.05f;
            if (this.isInWater()) {
                for (int j = 0; j < 4; ++j) {
                    float f4 = 0.25f;
                    this.level().addParticle((ParticleOptions)ParticleTypes.BUBBLE, d5 - d3 * 0.25, d1 - d4 * 0.25, d2 - d0 * 0.25, d3, d4, d0);
                }
                f2 = this.getWaterInertia();
            }
            this.setDeltaMovement(vector3d.scale((double)f2));
            if (!this.isNoGravity() && !flag) {
                Vec3 vector3d4 = this.getDeltaMovement();
                float antiGrav = ((Float)this.entityData.get(GRAV_COMPENSATION)).floatValue();
                if (antiGrav > 0.0f && !this.inGround) {
                    float antiGravActivation = Math.min((float)this.getDeltaMovement().length() / Math.max(((Float)this.entityData.get(INIT_VELOCITY)).floatValue() * 0.75f, 2.0f), 1.0f);
                    this.setDeltaMovement(vector3d4.x, vector3d4.y - (double)0.05f * (double)(1.0f - antiGravActivation * antiGrav), vector3d4.z);
                } else {
                    this.setDeltaMovement(vector3d4.x, vector3d4.y - (double)0.05f, vector3d4.z);
                }
            }
            this.setPos(d5, d1, d2);
            this.checkInsideBlocks();
        }
    }

    protected void onHitEntity(EntityHitResult p_213868_1_) {
        Player player;
        Entity entity = p_213868_1_.getEntity();
        float f = (float)this.getDeltaMovement().length();
        int i = Mth.ceil((double)Mth.clamp((double)((double)f * this.getBaseDamage()), (double)0.0, (double)2.147483647E9));
        byte penetration = (Byte)this.entityData.get(PENETRATION);
        if (this.getPierceLevel() > 0 || penetration > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercedAndKilledEntities == null) {
                this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercingIgnoreEntityIds.size() >= this.getPierceLevel() + 1 && this.piercingIgnoreEntityIds.size() >= penetration + 1) {
                this.discard();
                return;
            }
            this.piercingIgnoreEntityIds.add(entity.getId());
        }
        if (this.isCritArrow()) {
            long j = this.random.nextInt(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        Entity owner = this.getOwner();
        DamageSource damagesource = this.getDamageSource(entity);
        boolean isEnderman = entity.getType() == EntityType.ENDERMAN;
        int k = entity.getRemainingFireTicks();
        if (this.isOnFire() && !isEnderman) {
            entity.setSecondsOnFire(5);
        }
        if (penetration > 1 && entity instanceof Player && (player = (Player)entity).isUsingItem() && player.getUseItem().getItem() instanceof ShieldItem) {
            player.getCooldowns().addCooldown(player.getUseItem().getItem(), 100);
            this.level().broadcastEntityEvent((Entity)player, (byte)30);
            player.stopUsingItem();
        }
        if (entity.hurt(damagesource, (float)i)) {
            if (isEnderman) {
                return;
            }
            if (entity instanceof LivingEntity) {
                Vec3 vector3d;
                LivingEntity livingentity = (LivingEntity)entity;
                if (!this.level().isClientSide && this.getPierceLevel() <= 0 && penetration <= 0) {
                    livingentity.setArrowCount(livingentity.getArrowCount() + 1);
                }
                if (this.knockback > 0 && (vector3d = this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize().scale((double)this.knockback * 0.6)).lengthSqr() > 0.0) {
                    livingentity.push(vector3d.x, 0.1, vector3d.z);
                }
                if (!this.level().isClientSide && owner instanceof LivingEntity) {
                    EnchantmentHelper.doPostHurtEffects((LivingEntity)livingentity, (Entity)owner);
                    EnchantmentHelper.doPostDamageEffects((LivingEntity)((LivingEntity)owner), (Entity)livingentity);
                }
                this.doPostHurtEffects(livingentity);
                if (owner != null && livingentity != owner && livingentity instanceof Player && owner instanceof ServerPlayer && !this.isSilent()) {
                    ((ServerPlayer)owner).connection.send((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.ARROW_HIT_PLAYER, 0.0f));
                }
                if (!entity.isAlive() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add(livingentity);
                }
                if (!this.level().isClientSide && owner instanceof ServerPlayer) {
                    ServerPlayer serverplayerentity = (ServerPlayer)owner;
                    if (this.piercedAndKilledEntities != null && this.shotFromCrossbow()) {
                        CriteriaTriggers.KILLED_BY_CROSSBOW.trigger(serverplayerentity, (Collection)this.piercedAndKilledEntities);
                    } else if (!entity.isAlive() && this.shotFromCrossbow()) {
                        CriteriaTriggers.KILLED_BY_CROSSBOW.trigger(serverplayerentity, Arrays.asList(entity));
                    }
                }
            }
            this.playSound(this.getHitGroundSoundEvent(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
            if (this.getPierceLevel() <= 0 && penetration <= 0) {
                this.discard();
            }
        } else {
            entity.setRemainingFireTicks(k);
            this.setDeltaMovement(this.getDeltaMovement().scale(0.0));
            this.setYRot(this.getYRot() + 180.0f);
            this.yRotO += 180.0f;
            if (!this.level().isClientSide && this.getDeltaMovement().lengthSqr() < 1.0E-7) {
                if (this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
                this.discard();
            }
        }
    }

    private DamageSource getDamageSource(Entity target) {
        Entity owner = this.getOwner();
        TechLevel techLevel = TechLevel.byIndex((int)((Byte)this.entityData.get(TECH_LEVEL)).byteValue());
        boolean bypassImmune = this.getProjectileImmuneOverride() && DEConfig.projectileAntiImmuneEntities.contains(BuiltInRegistries.ENTITY_TYPE.getKey((Object)target.getType()).toString());
        return DEDamage.draconicArrow(this.level(), (Entity)this, owner, techLevel, bypassImmune);
    }

    protected void onHitBlock(BlockHitResult traceResult) {
        byte basePenetration = (Byte)this.entityData.get(PENETRATION);
        int remainingPenetration = basePenetration - this.blockPenetration;
        if (this.piercingIgnoreEntityIds != null) {
            remainingPenetration -= this.piercingIgnoreEntityIds.size();
        }
        double canPenetrate = (double)remainingPenetration * 0.25;
        byte techLevel = (Byte)this.entityData.get(TECH_LEVEL);
        if (canPenetrate > 0.0 && (double)basePenetration >= (double)techLevel * 1.5) {
            VoxelShape voxelshape;
            this.blockPenetration += remainingPenetration;
            BlockPos pos = traceResult.getBlockPos();
            BlockState blockstate = this.level().getBlockState(pos);
            if (!blockstate.isAir() && !(voxelshape = blockstate.getCollisionShape((BlockGetter)this.level(), pos)).isEmpty()) {
                boolean canPass = true;
                Vec3 vector3d1 = traceResult.getLocation().add(this.getDeltaMovement().normalize().multiply(canPenetrate, canPenetrate, canPenetrate));
                for (AABB axisalignedbb : voxelshape.toAabbs()) {
                    if (!axisalignedbb.move(pos).contains(vector3d1)) continue;
                    canPass = false;
                    break;
                }
                if (canPass) {
                    this.playSound(SoundEvents.ANCIENT_DEBRIS_BREAK, 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
                    for (int i = 0; i < 25; ++i) {
                        Vec3 critPos = traceResult.getLocation().add(this.getDeltaMovement().normalize().multiply(2.0, 2.0, 2.0).add((-0.5 + this.random.nextGaussian()) * 0.2, (-0.5 + this.random.nextGaussian()) * 0.2, (-0.5 + this.random.nextGaussian()) * 0.2));
                        Vec3 critVel = this.getDeltaMovement().normalize().multiply(5.0, 5.0, 5.0);
                        this.level().addParticle((ParticleOptions)ParticleTypes.CRIT, critPos.x, critPos.y, critPos.z, critVel.x, critVel.y, critVel.z);
                    }
                    Vec3 shrapnelTravelEnd = traceResult.getLocation().add(this.getDeltaMovement().normalize().multiply((double)remainingPenetration, (double)remainingPenetration, (double)remainingPenetration));
                    EntityHitResult result = this.findHitEntity(traceResult.getLocation(), shrapnelTravelEnd);
                    if (result != null) {
                        Entity entity = result.getEntity();
                        DamageSource damagesource = this.getDamageSource(entity);
                        float velocity = (float)this.getDeltaMovement().length();
                        int damage = Mth.ceil((double)Mth.clamp((double)((double)velocity * this.getBaseDamage()), (double)0.0, (double)2.147483647E9));
                        entity.hurt(damagesource, (float)damage * 0.75f);
                    }
                }
            }
        }
        this.lastState = this.level().getBlockState(traceResult.getBlockPos());
        BlockState blockstate = this.level().getBlockState(traceResult.getBlockPos());
        blockstate.onProjectileHit(this.level(), blockstate, traceResult, (Projectile)this);
        Vec3 vector3d = traceResult.getLocation().subtract(this.getX(), this.getY(), this.getZ());
        this.setDeltaMovement(vector3d);
        Vec3 vector3d1 = vector3d.normalize().scale((double)0.05f);
        this.setPosRaw(this.getX() - vector3d1.x, this.getY() - vector3d1.y, this.getZ() - vector3d1.z);
        this.playSound(this.getHitGroundSoundEvent(), 1.0f, 1.2f / (this.random.nextFloat() * 0.2f + 0.9f));
        this.inGround = true;
        this.shakeTime = 7;
        this.setCritArrow(false);
        this.setPierceLevel((byte)0);
        this.setSoundEvent(SoundEvents.ARROW_HIT);
        this.setShotFromCrossbow(false);
        this.resetPiercedEntities();
    }

    public void setEffectsFromItem(ItemStack p_184555_1_) {
        if (p_184555_1_.getItem() == Items.TIPPED_ARROW) {
            int i;
            this.potion = PotionUtils.getPotion((ItemStack)p_184555_1_);
            List collection = PotionUtils.getCustomEffects((ItemStack)p_184555_1_);
            if (!collection.isEmpty()) {
                for (MobEffectInstance effectinstance : collection) {
                    this.effects.add(new MobEffectInstance(effectinstance));
                }
            }
            if ((i = DraconicArrowEntity.getCustomColor(p_184555_1_)) == -1) {
                this.updateColor();
            } else {
                this.setFixedColor(i);
            }
        } else if (p_184555_1_.getItem() == Items.ARROW) {
            this.potion = Potions.EMPTY;
            this.effects.clear();
            this.entityData.set(ID_EFFECT_COLOR, (Object)-1);
        }
    }

    public static int getCustomColor(ItemStack p_191508_0_) {
        CompoundTag compoundnbt = p_191508_0_.getTag();
        return compoundnbt != null && compoundnbt.contains("CustomPotionColor", 99) ? compoundnbt.getInt("CustomPotionColor") : -1;
    }

    private void updateColor() {
        this.fixedColor = false;
        if (this.potion == Potions.EMPTY && this.effects.isEmpty()) {
            this.entityData.set(ID_EFFECT_COLOR, (Object)-1);
        } else {
            this.entityData.set(ID_EFFECT_COLOR, (Object)PotionUtils.getColor((Collection)PotionUtils.getAllEffects((Potion)this.potion, this.effects)));
        }
    }

    public void addEffect(MobEffectInstance p_184558_1_) {
        this.effects.add(p_184558_1_);
        this.getEntityData().set(ID_EFFECT_COLOR, (Object)PotionUtils.getColor((Collection)PotionUtils.getAllEffects((Potion)this.potion, this.effects)));
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(ID_EFFECT_COLOR, (Object)-1);
        this.entityData.define(SPECTRAL_TIME, (Object)0);
        this.entityData.define(TECH_LEVEL, (Object)((byte)TechLevel.DRACONIUM.index));
        this.entityData.define(PENETRATION, (Object)0);
        this.entityData.define(GRAV_COMPENSATION, (Object)Float.valueOf(0.0f));
        this.entityData.define(INIT_VELOCITY, (Object)Float.valueOf(0.0f));
        this.entityData.define(PROJ_ANTI_IMMUNE, (Object)false);
    }

    private void makeParticle(int p_184556_1_) {
        int i = this.getColor();
        if (i != -1 && p_184556_1_ > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i >> 0 & 0xFF) / 255.0;
            for (int j = 0; j < p_184556_1_; ++j) {
                this.level().addParticle((ParticleOptions)ParticleTypes.ENTITY_EFFECT, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), d0, d1, d2);
            }
        }
    }

    public int getColor() {
        return (Integer)this.entityData.get(ID_EFFECT_COLOR);
    }

    private void setFixedColor(int p_191507_1_) {
        this.fixedColor = true;
        this.entityData.set(ID_EFFECT_COLOR, (Object)p_191507_1_);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.potion != Potions.EMPTY && this.potion != null) {
            compound.putString("Potion", BuiltInRegistries.POTION.getKey((Object)this.potion).toString());
        }
        if (this.fixedColor) {
            compound.putInt("Color", this.getColor());
        }
        if (!this.effects.isEmpty()) {
            ListTag listnbt = new ListTag();
            for (MobEffectInstance effectinstance : this.effects) {
                listnbt.add((Object)effectinstance.save(new CompoundTag()));
            }
            compound.put("CustomPotionEffects", (Tag)listnbt);
        }
        if (this.getSpectralTime() > 0) {
            compound.putInt("spectral_time", ((Integer)this.entityData.get(SPECTRAL_TIME)).intValue());
        }
        compound.putByte("tech_level", ((Byte)this.entityData.get(TECH_LEVEL)).byteValue());
        compound.putByte("penetration", ((Byte)this.entityData.get(PENETRATION)).byteValue());
        compound.putFloat("grav_comp", ((Float)this.entityData.get(GRAV_COMPENSATION)).floatValue());
        compound.putFloat("init_velocity", ((Float)this.entityData.get(INIT_VELOCITY)).floatValue());
        compound.putBoolean("proj_anti_immune", ((Boolean)this.entityData.get(PROJ_ANTI_IMMUNE)).booleanValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Potion", 8)) {
            this.potion = PotionUtils.getPotion((CompoundTag)compound);
        }
        for (MobEffectInstance effectinstance : PotionUtils.getCustomEffects((CompoundTag)compound)) {
            this.addEffect(effectinstance);
        }
        if (compound.contains("Color", 99)) {
            this.setFixedColor(compound.getInt("Color"));
        } else {
            this.updateColor();
        }
        if (compound.contains("spectral_time")) {
            this.setSpectral(compound.getInt("spectral_time"));
        }
        if (compound.contains("tech_level")) {
            this.entityData.set(TECH_LEVEL, (Object)compound.getByte("tech_level"));
        }
        if (compound.contains("penetration")) {
            this.entityData.set(PENETRATION, (Object)compound.getByte("penetration"));
        }
        if (compound.contains("grav_comp")) {
            this.entityData.set(GRAV_COMPENSATION, (Object)Float.valueOf(compound.getFloat("grav_comp")));
        }
        if (compound.contains("init_velocity")) {
            this.entityData.set(INIT_VELOCITY, (Object)Float.valueOf(compound.getFloat("init_velocity")));
        }
        if (compound.contains("proj_anti_immune")) {
            this.entityData.set(PROJ_ANTI_IMMUNE, (Object)compound.getBoolean("proj_anti_immune"));
        }
    }

    protected void doPostHurtEffects(LivingEntity p_184548_1_) {
        int spectralTime;
        super.doPostHurtEffects(p_184548_1_);
        for (MobEffectInstance effectinstance : this.potion.getEffects()) {
            p_184548_1_.addEffect(new MobEffectInstance(effectinstance.getEffect(), Math.max(effectinstance.getDuration() / 8, 1), effectinstance.getAmplifier(), effectinstance.isAmbient(), effectinstance.isVisible()));
        }
        if (!this.effects.isEmpty()) {
            for (MobEffectInstance effectinstance1 : this.effects) {
                p_184548_1_.addEffect(effectinstance1);
            }
        }
        if ((spectralTime = ((Integer)this.entityData.get(SPECTRAL_TIME)).intValue()) > 0) {
            MobEffectInstance effectinstance;
            effectinstance = new MobEffectInstance(MobEffects.GLOWING, spectralTime, 0);
            p_184548_1_.addEffect(effectinstance);
        }
    }

    protected ItemStack getPickupItem() {
        if (this.effects.isEmpty() && this.potion == Potions.EMPTY) {
            return new ItemStack((ItemLike)Items.ARROW);
        }
        ItemStack itemstack = new ItemStack((ItemLike)Items.TIPPED_ARROW);
        PotionUtils.setPotion((ItemStack)itemstack, (Potion)this.potion);
        PotionUtils.setCustomEffects((ItemStack)itemstack, this.effects);
        if (this.fixedColor) {
            itemstack.getOrCreateTag().putInt("CustomPotionColor", this.getColor());
        }
        return itemstack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte p_70103_1_) {
        if (p_70103_1_ == 0) {
            int i = this.getColor();
            if (i != -1) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i >> 0 & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.ENTITY_EFFECT, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), d0, d1, d2);
                }
            }
        } else {
            super.handleEntityEvent(p_70103_1_);
        }
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return (Packet)SneakyUtils.unsafeCast((Object)BCoreNetwork.getEntitySpawnPacket((Entity)this));
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return source.is(DamageTypeTags.IS_FIRE) || super.isInvulnerableTo(source);
    }
}

