/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.projectile;

import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.DamageModData;
import com.brandon3055.draconicevolution.api.modules.lib.IDamageModifier;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.equipment.damage.DefaultStaffDmgMod;
import com.brandon3055.draconicevolution.lib.Serializers;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@Deprecated
public class DraconicProjectileEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(DraconicProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> ARROW_PROJECTILE = SynchedEntityData.defineId(DraconicProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> NO_DRAG = SynchedEntityData.defineId(DraconicProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> EFFECT_COLOR = SynchedEntityData.defineId(DraconicProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Optional<Module<?>>> DAMAGE_MODIFIER = SynchedEntityData.defineId(DraconicProjectileEntity.class, Serializers.OPT_MODULE_SERIALIZER);
    private static final IDamageModifier defaultStaffModifier = new DefaultStaffDmgMod();
    private Potion potion = Potions.EMPTY;
    private final Set<MobEffectInstance> customPotionEffects = Sets.newHashSet();
    private boolean fixedColor;
    private int flightTime = 0;
    private int maxFlightTime = -1;
    private int explosivePower = 0;
    private boolean explodeBlocks = false;
    private float projectileBaseDamage = 0.0f;
    private float secondaryChange = 0.0f;
    private boolean useDefaultStaffModifier = false;
    private boolean pseudoInstantTravel = false;

    public DraconicProjectileEntity(EntityType<? extends DraconicProjectileEntity> type, Level worldIn, ItemStack stack) {
        super(type, worldIn, stack);
    }

    public DraconicProjectileEntity(Level worldIn, double x, double y, double z, ItemStack stack) {
        super((EntityType)DEContent.ENTITY_DRACONIC_ARROW.get(), x, y, z, worldIn, stack);
    }

    public DraconicProjectileEntity(Level worldIn, LivingEntity shooter, ItemStack stack) {
        super((EntityType)DEContent.ENTITY_DRACONIC_ARROW.get(), shooter, worldIn, stack);
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(COLOR, (Object)-1);
        this.entityData.define(ARROW_PROJECTILE, (Object)true);
        this.entityData.define(NO_DRAG, (Object)false);
        this.entityData.define(EFFECT_COLOR, (Object)-1);
        this.entityData.define(DAMAGE_MODIFIER, Optional.empty());
    }

    public void setArrowProjectile(boolean isArrowProjectile) {
        this.entityData.set(ARROW_PROJECTILE, (Object)isArrowProjectile);
    }

    public boolean isArrowProjectile() {
        return (Boolean)this.entityData.get(ARROW_PROJECTILE);
    }

    public void setDamageModifier(Module<?> damageModule) {
        if (damageModule != null && damageModule.getData() instanceof DamageModData) {
            this.entityData.set(DAMAGE_MODIFIER, Optional.of(damageModule));
        } else {
            this.entityData.set(DAMAGE_MODIFIER, Optional.empty());
        }
    }

    @Nullable
    public Module<DamageModData> getDamageModifier() {
        Optional opt = (Optional)this.entityData.get(DAMAGE_MODIFIER);
        if (opt.isPresent() && ((Module)opt.get()).getData() instanceof DamageModData) {
            return (Module)opt.get();
        }
        return null;
    }

    public void setNoDrag(boolean hasNoDrag) {
        this.entityData.set(NO_DRAG, (Object)hasNoDrag);
    }

    public boolean hasNoDrag() {
        return (Boolean)this.entityData.get(NO_DRAG);
    }

    public void setMaxFlightTime(int maxFlightTime) {
        this.maxFlightTime = maxFlightTime;
    }

    public void setExplosivePower(int explosivePower, boolean damageBlocks) {
        this.explosivePower = explosivePower;
        this.explodeBlocks = damageBlocks;
    }

    public void setEffectColour(int colour) {
        this.entityData.set(EFFECT_COLOR, (Object)colour);
    }

    public int getEffectColor() {
        return (Integer)this.entityData.get(EFFECT_COLOR);
    }

    public void useDefaultStaffModifier() {
        this.useDefaultStaffModifier = true;
    }

    public void setPseudoInstantTravel(boolean pseudoInstantTravel) {
        this.pseudoInstantTravel = pseudoInstantTravel;
    }

    public void setProjectileBaseDamage(float projectileBaseDamage) {
        this.projectileBaseDamage = projectileBaseDamage;
    }

    protected boolean activateDamageEffect(@Nullable HitResult traceResult) {
        if (this.level().isClientSide) {
            return true;
        }
        Entity owner = this.getOwner();
        Module<DamageModData> damageMod = this.getDamageModifier();
        Vec3 pos = this.position();
        if (traceResult != null) {
            if (traceResult instanceof EntityHitResult) {
                pos = traceResult.getLocation();
            } else {
                Vec3 hitPos = traceResult.getLocation();
                if (hitPos.distanceTo(pos) > 1.0) {
                    Vec3 dirVec = pos.subtract(hitPos).normalize();
                    pos = hitPos.add(dirVec);
                }
            }
        }
        boolean disableDefault = false;
        if (damageMod != null || this.useDefaultStaffModifier) {
            IDamageModifier modifier = this.useDefaultStaffModifier ? defaultStaffModifier : damageMod.getData().modifier();
            modifier.doDamageAndEffects(this.level(), pos, traceResult, owner instanceof LivingEntity ? (LivingEntity)owner : null, this.projectileBaseDamage, this.secondaryChange, true);
            this.setDamageModifier(null);
            disableDefault = true;
        } else if (this.explosivePower > 0) {
            if (owner instanceof LivingEntity) {
                this.level().explode(owner, this.level().damageSources().explosion(owner, null), null, pos.x, pos.y, pos.z, (float)this.explosivePower, false, this.explodeBlocks ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE);
            } else {
                this.level().explode((Entity)this, pos.x, pos.y, pos.z, (float)this.explosivePower, false, this.explodeBlocks ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE);
            }
            this.explosivePower = 0;
            disableDefault = true;
        }
        if (!this.isArrowProjectile()) {
            this.kill();
        }
        return disableDefault;
    }

    public void shootFromRotation(Entity p_234612_1_, float playerXRot, float playerYRot, float someZeroOffset, float power, float inaccuracy) {
        if (power >= 100.0f) {
            this.setPseudoInstantTravel(true);
        }
        super.shootFromRotation(p_234612_1_, playerXRot, playerYRot, someZeroOffset, power, inaccuracy);
    }

    protected void onHitEntity(EntityHitResult entityRayTraceResult) {
        if (this.activateDamageEffect((HitResult)entityRayTraceResult)) {
            return;
        }
        super.onHitEntity(entityRayTraceResult);
    }

    protected void onHitBlock(BlockHitResult blockRayTraceResult) {
        if (this.activateDamageEffect((HitResult)blockRayTraceResult)) {
            return;
        }
        super.onHitBlock(blockRayTraceResult);
    }

    public void setPotionEffect(ItemStack stack) {
        if (stack.getItem() == Items.TIPPED_ARROW) {
            int i;
            this.potion = PotionUtils.getPotion((ItemStack)stack);
            List collection = PotionUtils.getCustomEffects((ItemStack)stack);
            if (!collection.isEmpty()) {
                for (MobEffectInstance effectinstance : collection) {
                    this.customPotionEffects.add(new MobEffectInstance(effectinstance));
                }
            }
            if ((i = DraconicProjectileEntity.getCustomColor(stack)) == -1) {
                this.refreshColor();
            } else {
                this.setFixedColor(i);
            }
        } else if (stack.getItem() == Items.ARROW) {
            this.potion = Potions.EMPTY;
            this.customPotionEffects.clear();
            this.entityData.set(COLOR, (Object)-1);
        }
    }

    public static int getCustomColor(ItemStack colour) {
        CompoundTag compoundnbt = colour.getTag();
        return compoundnbt != null && compoundnbt.contains("CustomPotionColor", 99) ? compoundnbt.getInt("CustomPotionColor") : -1;
    }

    private void refreshColor() {
        this.fixedColor = false;
        if (this.potion == Potions.EMPTY && this.customPotionEffects.isEmpty()) {
            this.entityData.set(COLOR, (Object)-1);
        } else {
            this.entityData.set(COLOR, (Object)PotionUtils.getColor((Collection)PotionUtils.getAllEffects((Potion)this.potion, this.customPotionEffects)));
        }
    }

    public void addEffect(MobEffectInstance effect) {
        this.customPotionEffects.add(effect);
        this.getEntityData().set(COLOR, (Object)PotionUtils.getColor((Collection)PotionUtils.getAllEffects((Potion)this.potion, this.customPotionEffects)));
    }

    public void tick() {
        boolean forceActivation;
        boolean bl = forceActivation = this.pseudoInstantTravel && !this.level().isAreaLoaded(this.getOnPos(), 20);
        if (this.hasNoDrag()) {
            Vec3 velocity = this.getDeltaMovement();
            super.tick();
            if (!this.isNoGravity()) {
                velocity = velocity.subtract(0.0, 0.05, 0.0);
            }
            this.setDeltaMovement(velocity);
        } else {
            super.tick();
        }
        if (this.level().isClientSide) {
            if (this.inGround) {
                if (this.inGroundTime % 5 == 0) {
                    this.spawnPotionParticles(1);
                }
            } else {
                this.spawnPotionParticles(2);
            }
        } else if (this.inGround && this.inGroundTime != 0 && !this.customPotionEffects.isEmpty() && this.inGroundTime >= 600) {
            this.level().broadcastEntityEvent((Entity)this, (byte)0);
            this.potion = Potions.EMPTY;
            this.customPotionEffects.clear();
            this.entityData.set(COLOR, (Object)-1);
        }
        if (!this.inGround) {
            if (this.maxFlightTime > 0) {
                ++this.flightTime;
                if (this.flightTime >= this.maxFlightTime || forceActivation) {
                    this.activateDamageEffect(null);
                }
            }
        } else {
            this.flightTime = 0;
        }
    }

    private void spawnPotionParticles(int particleCount) {
        int i = this.getColor();
        if (i != -1 && particleCount > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i >> 0 & 0xFF) / 255.0;
            for (int j = 0; j < particleCount; ++j) {
                this.level().addParticle((ParticleOptions)ParticleTypes.ENTITY_EFFECT, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), d0, d1, d2);
            }
        }
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    private void setFixedColor(int colour) {
        this.fixedColor = true;
        this.entityData.set(COLOR, (Object)colour);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.potion != Potions.EMPTY && this.potion != null) {
            compound.putString("Potion", BuiltInRegistries.POTION.getKey((Object)this.potion).toString());
        }
        if (this.fixedColor) {
            compound.putInt("Color", this.getColor());
        }
        if (!this.customPotionEffects.isEmpty()) {
            ListTag listnbt = new ListTag();
            for (MobEffectInstance effectinstance : this.customPotionEffects) {
                listnbt.add((Object)effectinstance.save(new CompoundTag()));
            }
            compound.put("CustomPotionEffects", (Tag)listnbt);
        }
        if (this.maxFlightTime != -1) {
            compound.putInt("MaxFlightTime", this.maxFlightTime);
            compound.putInt("FlightTime", this.flightTime);
        }
        if (this.explosivePower > 0) {
            compound.putShort("ExplosivePower", (short)this.explosivePower);
            compound.putBoolean("ExplodeBlocks", this.explodeBlocks);
        }
        compound.putBoolean("PseudoInstantTravel", this.pseudoInstantTravel);
        compound.putFloat("ProjectileBaseDamage", this.projectileBaseDamage);
        compound.putFloat("SecondaryChange", this.secondaryChange);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Potion", 8)) {
            this.potion = PotionUtils.getPotion((CompoundTag)compound);
        }
        for (MobEffectInstance effectinstance : PotionUtils.getCustomEffects((CompoundTag)compound)) {
            this.addEffect(effectinstance);
        }
        if (compound.contains("Color", 99)) {
            this.setFixedColor(compound.getInt("Color"));
        } else {
            this.refreshColor();
        }
        if (compound.contains("MaxFlightTime")) {
            this.maxFlightTime = compound.getInt("MaxFlightTime");
            this.flightTime = compound.getInt("FlightTime");
        }
        if (compound.contains("ExplosivePower")) {
            this.explosivePower = compound.getShort("ExplosivePower");
            this.explodeBlocks = compound.getBoolean("ExplodeBlocks");
        }
        this.pseudoInstantTravel = compound.getBoolean("PseudoInstantTravel");
        this.projectileBaseDamage = compound.getFloat("ProjectileBaseDamage");
        this.secondaryChange = compound.getFloat("SecondaryChange");
    }

    protected void doPostHurtEffects(LivingEntity living) {
        super.doPostHurtEffects(living);
        for (MobEffectInstance effectinstance : this.potion.getEffects()) {
            living.addEffect(new MobEffectInstance(effectinstance.getEffect(), Math.max(effectinstance.getDuration() / 8, 1), effectinstance.getAmplifier(), effectinstance.isAmbient(), effectinstance.isVisible()));
        }
        if (!this.customPotionEffects.isEmpty()) {
            for (MobEffectInstance effectinstance1 : this.customPotionEffects) {
                living.addEffect(effectinstance1);
            }
        }
    }

    protected ItemStack getPickupItem() {
        if (this.customPotionEffects.isEmpty() && this.potion == Potions.EMPTY) {
            return new ItemStack((ItemLike)Items.ARROW);
        }
        ItemStack itemstack = new ItemStack((ItemLike)Items.TIPPED_ARROW);
        PotionUtils.setPotion((ItemStack)itemstack, (Potion)this.potion);
        PotionUtils.setCustomEffects((ItemStack)itemstack, this.customPotionEffects);
        if (this.fixedColor) {
            itemstack.getOrCreateTag().putInt("CustomPotionColor", this.getColor());
        }
        return itemstack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte id) {
        if (id == 0) {
            int i = this.getColor();
            if (i != -1) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i >> 0 & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.ENTITY_EFFECT, this.getRandomX(0.5), this.getRandomY(), this.getRandomZ(0.5), d0, d1, d2);
                }
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return (Packet)SneakyUtils.unsafeCast((Object)BCoreNetwork.getEntitySpawnPacket((Entity)this));
    }
}

