/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.handlers.dislocator;

import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.draconicevolution.handlers.dislocator.EntityTarget;
import com.brandon3055.draconicevolution.handlers.dislocator.GroundTarget;
import com.brandon3055.draconicevolution.handlers.dislocator.PlayerTarget;
import com.brandon3055.draconicevolution.handlers.dislocator.TileTarget;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public abstract class DislocatorTarget {
    protected ResourceKey<Level> worldKey;

    public DislocatorTarget(ResourceKey<Level> worldKey) {
        this.worldKey = worldKey;
    }

    @Nullable
    public abstract TargetPos getTargetPos(MinecraftServer var1, UUID var2, UUID var3);

    public void preTeleport(MinecraftServer server, Entity entity) {
    }

    protected ServerLevel getTargetWorld(MinecraftServer server) {
        return server.getLevel(this.worldKey);
    }

    public CompoundTag save(CompoundTag nbt) {
        nbt.putByte("target_type", (byte)this.getType().ordinal());
        nbt.putString("world_key", this.worldKey.location().toString());
        return nbt;
    }

    protected void loadInternal(CompoundTag nbt) {
    }

    public ResourceKey<Level> getWorldKey() {
        return this.worldKey;
    }

    public static DislocatorTarget load(CompoundTag nbt) {
        try {
            TargetType type = TargetType.values()[nbt.getByte("target_type")];
            ResourceKey worldKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)new ResourceLocation(nbt.getString("world_key")));
            DislocatorTarget target = type.createInstance((ResourceKey<Level>)worldKey);
            target.loadInternal(nbt);
            return target;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public abstract TargetType getType();

    static enum TargetType {
        TILE(TileTarget::new),
        PLAYER(PlayerTarget::new),
        ENTITY_INVENTORY(EntityTarget::new),
        ON_GROUND(GroundTarget::new);

        private Function<ResourceKey<Level>, DislocatorTarget> factory;

        private TargetType(Function<ResourceKey<Level>, DislocatorTarget> factory) {
            this.factory = factory;
        }

        public DislocatorTarget createInstance(ResourceKey<Level> worldKey) {
            return this.factory.apply(worldKey);
        }
    }
}

