/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.init;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.api.hud.AbstractHudElement;
import com.brandon3055.brandonscore.client.hud.HudManager;
import com.brandon3055.brandonscore.handlers.contributor.ContributorHandler;
import com.brandon3055.draconicevolution.client.AtlasTextureHelper;
import com.brandon3055.draconicevolution.client.CustomBossInfoHandler;
import com.brandon3055.draconicevolution.client.DEGuiTextures;
import com.brandon3055.draconicevolution.client.DEShaders;
import com.brandon3055.draconicevolution.client.ModuleTextures;
import com.brandon3055.draconicevolution.client.gui.CelestialManipulatorGui;
import com.brandon3055.draconicevolution.client.gui.DisenchanterGui;
import com.brandon3055.draconicevolution.client.gui.DraconiumChestGui;
import com.brandon3055.draconicevolution.client.gui.EnergyCoreGui;
import com.brandon3055.draconicevolution.client.gui.EnergyTransfuserGui;
import com.brandon3055.draconicevolution.client.gui.EntityDetectorGui;
import com.brandon3055.draconicevolution.client.gui.FlowGateGui;
import com.brandon3055.draconicevolution.client.gui.FusionCraftingCoreGui;
import com.brandon3055.draconicevolution.client.gui.GeneratorGui;
import com.brandon3055.draconicevolution.client.gui.GrinderGui;
import com.brandon3055.draconicevolution.client.gui.ReactorGui;
import com.brandon3055.draconicevolution.client.gui.modular.ModularItemGui;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.ConfigurableItemGui;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.handler.ModularItemRenderOverrideHandler;
import com.brandon3055.draconicevolution.client.handler.OverlayRenderHandler;
import com.brandon3055.draconicevolution.client.keybinding.KeyBindings;
import com.brandon3055.draconicevolution.client.keybinding.KeyInputHandler;
import com.brandon3055.draconicevolution.client.render.entity.DraconicGuardianRenderer;
import com.brandon3055.draconicevolution.client.render.entity.GuardianCrystalRenderer;
import com.brandon3055.draconicevolution.client.render.entity.GuardianProjectileRenderer;
import com.brandon3055.draconicevolution.client.render.entity.GuardianWitherRenderer;
import com.brandon3055.draconicevolution.client.render.entity.projectile.DraconicArrowRenderer;
import com.brandon3055.draconicevolution.client.render.hud.ShieldHudElement;
import com.brandon3055.draconicevolution.client.render.tile.DraconiumChestTileRenderer;
import com.brandon3055.draconicevolution.client.render.tile.RenderEnergyCoreStabilizer;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileCelestialManipulator;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileChaosCrystal;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileCraftingInjector;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileDisenchanter;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileDislocatorPedestal;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEnergyCore;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEnergyCrystal;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEnergyPylon;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEnergyTransfuser;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEntityDetector;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileFusionCraftingCore;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileGenerator;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileGrinder;
import com.brandon3055.draconicevolution.client.render.tile.RenderTilePlacedItem;
import com.brandon3055.draconicevolution.client.render.tile.RenderTilePotentiometer;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileReactorComponent;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileReactorCore;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileStabilizedSpawner;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.equipment.IModularArmor;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.NotNull;

public class DEClient {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");
    public static final DeferredRegister<AbstractHudElement> HUDS = DeferredRegister.create((ResourceKey)HudManager.HUD_TYPE, (String)"draconicevolution");
    public static final DeferredHolder<AbstractHudElement, ShieldHudElement> SHIELD_HUD = HUDS.register("shield_hud", ShieldHudElement::new);
    private static final CrashLock LOCK2 = new CrashLock("Already Initialized.");

    public static void init(IEventBus modBus) {
        LOCK.lock();
        modBus.addListener(DEClient::clientSetupEvent);
        modBus.addListener(DEClient::registerRenderers);
        modBus.addListener(DEClient::onAddRenderLayers);
        modBus.addListener(DEClient::onResourceReload);
        HUDS.register(modBus);
        ModularItemRenderOverrideHandler.init();
        OverlayRenderHandler.init();
        DEShaders.init(modBus);
        ClientEventHandler.init(modBus);
        AtlasTextureHelper.init(modBus);
        KeyBindings.init(modBus);
        DEGuiTextures.init(modBus);
    }

    private static void clientSetupEvent(FMLClientSetupEvent event) {
        LOCK2.lock();
        DEClient.registerGuiFactories();
        DEClient.registerItemRenderers();
        DEClient.setupRenderLayers();
        CustomBossInfoHandler.init();
        NeoForge.EVENT_BUS.register((Object)new KeyInputHandler());
    }

    public static void onResourceReload(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)ModuleTextures.getAtlasHolder());
    }

    private static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_GRINDER.get(), RenderTileGrinder::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_DRACONIUM_CHEST.get(), DraconiumChestTileRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_STORAGE_CORE.get(), RenderTileEnergyCore::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_ENERGY_PYLON.get(), RenderTileEnergyPylon::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_CORE_STABILIZER.get(), RenderEnergyCoreStabilizer::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_STABILIZED_SPAWNER.get(), RenderTileStabilizedSpawner::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_GENERATOR.get(), RenderTileGenerator::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_IO_CRYSTAL.get(), RenderTileEnergyCrystal::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_RELAY_CRYSTAL.get(), RenderTileEnergyCrystal::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_WIRELESS_CRYSTAL.get(), RenderTileEnergyCrystal::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_REACTOR_CORE.get(), RenderTileReactorCore::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_REACTOR_INJECTOR.get(), RenderTileReactorComponent::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_REACTOR_STABILIZER.get(), RenderTileReactorComponent::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_CRAFTING_CORE.get(), RenderTileFusionCraftingCore::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_CRAFTING_INJECTOR.get(), RenderTileCraftingInjector::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_POTENTIOMETER.get(), RenderTilePotentiometer::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_ENERGY_TRANSFUSER.get(), RenderTileEnergyTransfuser::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_CHAOS_CRYSTAL.get(), RenderTileChaosCrystal::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_DISLOCATOR_PEDESTAL.get(), RenderTileDislocatorPedestal::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_PLACED_ITEM.get(), RenderTilePlacedItem::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_DISENCHANTER.get(), RenderTileDisenchanter::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_CELESTIAL_MANIPULATOR.get(), RenderTileCelestialManipulator::new);
        event.registerBlockEntityRenderer((BlockEntityType)DEContent.TILE_ENTITY_DETECTOR.get(), RenderTileEntityDetector::new);
        event.registerEntityRenderer((EntityType)DEContent.ENTITY_DRACONIC_GUARDIAN.get(), DraconicGuardianRenderer::new);
        event.registerEntityRenderer((EntityType)DEContent.ENTITY_GUARDIAN_PROJECTILE.get(), GuardianProjectileRenderer::new);
        event.registerEntityRenderer((EntityType)DEContent.ENTITY_GUARDIAN_CRYSTAL.get(), GuardianCrystalRenderer::new);
        event.registerEntityRenderer((EntityType)DEContent.ENTITY_DRACONIC_ARROW.get(), DraconicArrowRenderer::new);
        event.registerEntityRenderer((EntityType)DEContent.ENTITY_GUARDIAN_WITHER.get(), GuardianWitherRenderer::new);
    }

    private static void registerGuiFactories() {
        MenuScreens.register((MenuType)((MenuType)DEContent.MENU_GENERATOR.get()), GeneratorGui.Screen::new);
        MenuScreens.register((MenuType)((MenuType)DEContent.MENU_GRINDER.get()), GrinderGui.Screen::new);
        MenuScreens.register((MenuType)((MenuType)DEContent.MENU_CONFIGURABLE_ITEM.get()), ConfigurableItemGui.Screen::new);
        MenuScreens.register((MenuType)((MenuType)DEContent.MENU_MODULAR_ITEM.get()), ModularItemGui.Screen::new);
        MenuScreens.register((MenuType)((MenuType)DEContent.MENU_DRACONIUM_CHEST.get()), DraconiumChestGui.Screen::new);
        MenuScreens.register((MenuType)((MenuType)DEContent.MENU_ENERGY_CORE.get()), EnergyCoreGui.Screen::new);
        MenuScreens.register((MenuType)((MenuType)DEContent.MENU_REACTOR.get()), ReactorGui.Screen::new);
        MenuScreens.register((MenuType)((MenuType)DEContent.MENU_CELESTIAL_MANIPULATOR.get()), CelestialManipulatorGui.Screen::new);
        MenuScreens.register((MenuType)((MenuType)DEContent.MENU_DISENCHANTER.get()), DisenchanterGui.Screen::new);
        MenuScreens.register((MenuType)((MenuType)DEContent.MENU_FUSION_CRAFTING_CORE.get()), FusionCraftingCoreGui.Screen::new);
        MenuScreens.register((MenuType)((MenuType)DEContent.MENU_FLOW_GATE.get()), FlowGateGui.Screen::new);
        MenuScreens.register((MenuType)((MenuType)DEContent.MENU_ENTITY_DETECTOR.get()), EntityDetectorGui.Screen::new);
        MenuScreens.register((MenuType)((MenuType)DEContent.MENU_ENERGY_TRANSFUSER.get()), EnergyTransfuserGui.Screen::new);
    }

    private static void registerItemRenderers() {
    }

    private static void setupRenderLayers() {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DEContent.GRINDER.get()), (RenderType)RenderType.cutoutMipped());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DEContent.GENERATOR.get()), (RenderType)RenderType.cutoutMipped());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DEContent.ENERGY_TRANSFUSER.get()), (RenderType)RenderType.cutoutMipped());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DEContent.PORTAL.get()), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DEContent.OVERWORLD_DRACONIUM_ORE.get()), renderType -> renderType == RenderType.solid() || renderType == RenderType.cutoutMipped());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DEContent.END_DRACONIUM_ORE.get()), renderType -> renderType == RenderType.solid() || renderType == RenderType.cutoutMipped());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DEContent.NETHER_DRACONIUM_ORE.get()), renderType -> renderType == RenderType.solid() || renderType == RenderType.cutoutMipped());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)DEContent.DEEPSLATE_DRACONIUM_ORE.get()), renderType -> renderType == RenderType.solid() || renderType == RenderType.cutoutMipped());
    }

    public static boolean deElytraVisible(ItemStack stack, LivingEntity entity) {
        if (ContributorHandler.shouldCancelElytra((LivingEntity)entity)) {
            return false;
        }
        Item item = stack.getItem();
        if (item instanceof IModularArmor) {
            IModularArmor item2 = (IModularArmor)item;
            return item2.canElytraFlyBC(stack, entity);
        }
        if (BrandonsCore.equipmentManager != null) {
            IModularArmor item3;
            ItemStack curio = BrandonsCore.equipmentManager.findMatchingItem(e -> e.getItem() instanceof IModularArmor, entity);
            Item item4 = curio.getItem();
            return item4 instanceof IModularArmor && (item3 = (IModularArmor)item4).canElytraFlyBC(curio, entity);
        }
        return false;
    }

    private static void onAddRenderLayers(EntityRenderersEvent.AddLayers event) {
        for (PlayerSkin.Model skin : event.getSkins()) {
            LivingEntityRenderer renderer = (LivingEntityRenderer)event.getSkin(skin);
            assert (renderer != null);
            renderer.addLayer((RenderLayer)new ElytraLayer((RenderLayerParent)renderer, event.getEntityModels()){

                public boolean shouldRender(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
                    return DEClient.deElytraVisible(stack, entity);
                }
            });
        }
    }
}

