/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration;

import com.brandon3055.brandonscore.handlers.HandHelper;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import net.neoforged.fml.OptionalMod;
import net.neoforged.neoforge.event.entity.living.LivingAttackEvent;
import net.neoforged.neoforgespi.language.IModInfo;

public class ModHelper {
    private static Map<String, String> loadedMods = null;
    public static final OptionalMod<?> TINKERS_CONSTRUCT = OptionalMod.of((String)"tconstruct");
    public static final OptionalMod<?> AVARITIA = OptionalMod.of((String)"avaritia");
    public static final OptionalMod<?> ROTARYCRAFT = OptionalMod.of((String)"rotarycraft");
    public static final OptionalMod<?> JEI = OptionalMod.of((String)"jei");
    public static final OptionalMod<?> BAUBLES = OptionalMod.of((String)"baubles");
    public static final OptionalMod<?> ENDERSTORAGE = OptionalMod.of((String)"enderstorage");
    private static Item cleaver;
    private static Item avaritiaSword;
    private static Item bedrockSword;

    public static boolean isHoldingCleaver(Player player) {
        if (!TINKERS_CONSTRUCT.isPresent()) {
            return false;
        }
        if (cleaver == null) {
            cleaver = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation("tconstruct", "cleaver"));
        }
        return cleaver != null && HandHelper.getItem((Player)player, (Item)cleaver) != null;
    }

    public static boolean isHoldingAvaritiaSword(Player player) {
        if (!AVARITIA.isPresent()) {
            return false;
        }
        if (avaritiaSword == null) {
            avaritiaSword = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation("avaritia", "infinity_sword"));
        }
        return avaritiaSword != null && !player.getMainHandItem().isEmpty() && player.getMainHandItem().getItem().equals(avaritiaSword);
    }

    public static boolean isHoldingBedrockSword(Player player) {
        if (!ROTARYCRAFT.isPresent()) {
            return false;
        }
        if (bedrockSword == null) {
            bedrockSword = (Item)BuiltInRegistries.ITEM.get(new ResourceLocation("rotarycraft", "rotarycraft_item_bedsword"));
        }
        return bedrockSword != null && !player.getMainHandItem().isEmpty() && player.getMainHandItem().getItem().equals(bedrockSword);
    }

    public static boolean canRemoveEnchants(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        ResourceLocation registry = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        return registry != null && !registry.getNamespace().equals("tconstruct");
    }

    public static float applyModDamageAdjustments(LivingAttackEvent event, ModuleHost host) {
        Player attacker;
        Player player = attacker = event.getSource().getEntity() instanceof Player ? (Player)event.getSource().getEntity() : null;
        if (attacker == null) {
            return event.getAmount();
        }
        if (ModHelper.isHoldingAvaritiaSword(attacker)) {
            event.getEntity().invulnerableTime = 0;
            return 300.0f;
        }
        if (event.getSource().is(DamageTypeTags.BYPASSES_ARMOR) || event.getSource().is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return event.getAmount() * 2.0f;
        }
        return event.getAmount();
    }

    public static boolean isWrench(ItemStack stack) {
        String name = String.valueOf(BuiltInRegistries.ITEM.getKey((Object)stack.getItem())).toLowerCase(Locale.ENGLISH);
        return name.contains("wrench") || name.contains("binder") || name.contains("hammer");
    }

    public static Map<String, String> getLoadedMods() {
        if (loadedMods == null) {
            loadedMods = Collections.synchronizedMap(new HashMap());
            for (IModInfo mod : ModList.get().getMods()) {
                loadedMods.put(mod.getModId(), mod.getDisplayName());
            }
        }
        return loadedMods;
    }
}

