/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.equipment;

import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.integration.equipment.CurioWrapper;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.lib.WTFException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class CuriosIntegration
extends EquipmentManager {
    public static final TagKey<Item> CURIO_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("curios", "curio"));
    public static final TagKey<Item> BODY_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("curios", "body"));

    public void registerCap(RegisterCapabilitiesEvent event, Item item) {
        event.registerItem(CuriosCapability.ITEM, (stack, context) -> new CurioWrapper((ItemStack)stack), new ItemLike[]{item});
    }

    @Nullable
    public Optional<IItemHandlerModifiable> getInventory(LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).map(ICuriosItemHandler::getEquippedCurios);
    }

    public ItemStack findMatchingItem(Item item, LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).map(e -> e.findFirstCurio(item)).flatMap(e -> e.map(SlotResult::stack)).orElse(ItemStack.EMPTY);
    }

    public ItemStack findMatchingItem(Predicate<ItemStack> predicate, LivingEntity entity) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).map(e -> e.findFirstCurio(predicate)).flatMap(e -> e.map(SlotResult::stack)).orElse(ItemStack.EMPTY);
    }

    public List<ResourceLocation> getSlotIcons(LivingEntity entity) {
        Optional optional = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (optional.isPresent()) {
            ICuriosItemHandler handler = (ICuriosItemHandler)optional.orElseThrow(WTFException::new);
            ArrayList<ResourceLocation> icons = new ArrayList<ResourceLocation>();
            handler.getCurios().forEach((s, h) -> {
                for (int i = 0; i < h.getSlots(); ++i) {
                    ResourceLocation icon = CuriosApi.getSlotIcon((String)s);
                    icons.add(new ResourceLocation(icon.getNamespace(), "textures/" + icon.getPath() + ".png"));
                }
            });
            return icons;
        }
        return Collections.emptyList();
    }

    public static void generateTags(Function<TagKey<Item>, TagsProvider.TagAppender> builder) {
        builder.apply(CURIO_TAG).add(new ResourceKey[]{DEContent.DISLOCATOR_ADVANCED.getKey(), DEContent.MAGNET.getKey(), DEContent.MAGNET_ADVANCED.getKey(), DEContent.CAPACITOR_WYVERN.getKey(), DEContent.CAPACITOR_DRACONIC.getKey(), DEContent.CAPACITOR_CHAOTIC.getKey(), DEContent.CAPACITOR_CREATIVE.getKey()});
        builder.apply(BODY_TAG).add(new ResourceKey[]{DEContent.CHESTPIECE_WYVERN.getKey(), DEContent.CHESTPIECE_DRACONIC.getKey(), DEContent.CHESTPIECE_CHAOTIC.getKey()});
    }
}

