/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.inventory;

import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class InvJunkFilter
implements IItemHandlerModifiable {
    private ItemStack stack;
    private NonNullList<ItemStack> stacks;

    public InvJunkFilter(ItemStack stack, int filterSize) {
        this.stack = stack;
        this.stacks = NonNullList.withSize((int)filterSize, (Object)ItemStack.EMPTY);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return stack.getItem() instanceof BlockItem;
    }

    public int getSlots() {
        return this.stacks.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return ItemStack.EMPTY;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return null;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return null;
    }

    public int getSlotLimit(int slot) {
        return 0;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
    }

    public void saveItems() {
        if (this.stack == null) {
            LogHelperBC.bigError((String)"TolkienTweaks: Tried to load Dynamic Item Stack inventory from null item!", (Object[])new Object[0]);
            return;
        }
        CompoundTag compound = ItemNBTHelper.getCompound((ItemStack)this.stack);
        ListTag list = new ListTag();
        for (ItemStack stack : this.stacks) {
            if (stack == null || stack.getCount() <= 0) continue;
            CompoundTag tag = new CompoundTag();
            stack.save(tag);
            list.add((Object)tag);
        }
        compound.put("InvItems", (Tag)list);
    }

    public void loadItems() {
        if (this.stack == null) {
            LogHelperBC.bigError((String)"TolkienTweaks: Tried to save Dynamic Item Stack inventory to null item!", (Object[])new Object[0]);
            return;
        }
        CompoundTag compound = ItemNBTHelper.getCompound((ItemStack)this.stack);
        ListTag list = compound.getList("InvItems", 10);
        this.stacks.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.stacks.add((Object)ItemStack.of((CompoundTag)list.getCompound(i)));
        }
    }
}

