/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.inventory;

import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public interface ModularMenuCommon {
    public List<Slot> getSlots();

    default public Stream<ItemStack> getInventoryStacks() {
        return this.getSlots().stream().map(Slot::getItem).filter(stack -> !stack.isEmpty());
    }

    public static Stream<PropertyProvider> getProviders(Stream<ItemStack> stacks) {
        return stacks.map(e -> (PropertyProvider)e.getCapability(DECapabilities.Properties.ITEM)).filter(Objects::nonNull);
    }

    default public PropertyProvider findProvider(UUID identity) {
        return ModularMenuCommon.getProviders(this.getInventoryStacks()).filter(provider -> provider.getIdentity().equals(identity)).findFirst().orElse(null);
    }

    public static Stream<ModuleHost> getHosts(Stream<ItemStack> stacks) {
        return stacks.map(e -> (ModuleHost)e.getCapability(DECapabilities.Host.ITEM)).filter(Objects::nonNull);
    }

    default public ModuleHost findHost(UUID identity) {
        return ModularMenuCommon.getHosts(this.getInventoryStacks()).filter(provider -> provider.getIdentity().equals(identity)).findFirst().orElse(null);
    }

    default public UUID getIdentity(ItemStack stack) {
        PropertyProvider provider = (PropertyProvider)stack.getCapability(DECapabilities.Properties.ITEM);
        if (!stack.isEmpty() && provider != null) {
            return provider.getIdentity();
        }
        return null;
    }
}

