/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items;

import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class Debugger
extends Item {
    private static final Map<Integer, String> MODES = new HashMap<Integer, String>();
    private static Random rand = new Random();

    public Debugger(Item.Properties properties) {
        super(properties);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        Level world = player.level();
        return super.onLeftClickEntity(stack, player, entity);
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        double posX = player.getX() - player.getX() % 16.0 + 8.0;
        double posZ = player.getZ() - player.getZ() % 16.0 + 8.0;
        MODES.clear();
        MODES.put(0, "Complete Crafting");
        MODES.put(1, "Insert RF");
        MODES.put(2, "Extract RF");
        MODES.put(3, "List Particles");
        MODES.put(4, "Recipe");
        MODES.put(5, "Clear");
        MODES.put(6, "Mod Wiki");
        MODES.put(7, "Explode");
        MODES.put(8, "Light");
        this.handleRightClick(itemStack, world, player, hand);
        return super.use(world, player, hand);
    }

    public InteractionResultHolder<ItemStack> handleRightClick(ItemStack stack, Level world, Player player, InteractionHand hand) {
        int mode = ItemNBTHelper.getInteger((ItemStack)stack, (String)"mode", (int)0);
        if (player.isShiftKeyDown()) {
            if (++mode == MODES.size()) {
                mode = 0;
            }
            if (!world.isClientSide) {
                player.sendSystemMessage((Component)Component.literal((String)MODES.get(mode)));
            }
            ItemNBTHelper.setInteger((ItemStack)stack, (String)"mode", (int)mode);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        switch (mode) {
            case 0: {
                break;
            }
            case 3: {
                if (!world.isClientSide) break;
                break;
            }
            case 4: {
                if (world.isClientSide) break;
                break;
            }
            case 6: {
                if (!world.isClientSide) break;
                this.openWiki();
                break;
            }
            case 7: {
                if (world.isClientSide) break;
                this.destroyUniverse(player);
                break;
            }
            case 8: {
                if (world.isClientSide) break;
            }
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction side = context.getClickedFace();
        int mode = ItemNBTHelper.getInteger((ItemStack)stack, (String)"mode", (int)0);
        switch (mode) {
            case 0: 
            case 1: 
            case 2: {
                BlockEntity blockEntity = world.getBlockEntity(pos);
            }
        }
        return InteractionResult.PASS;
    }

    private void openWiki() {
    }

    private void destroyUniverse(Player player) {
    }

    static {
        MODES.put(0, "Complete Crafting");
        MODES.put(1, "Insert RF");
        MODES.put(2, "Extract RF");
        MODES.put(3, "List Particles");
        MODES.put(4, "Recipe");
        MODES.put(5, "Clear");
        MODES.put(6, "Mod Wiki");
        MODES.put(7, "Explode");
        MODES.put(8, "Light");
    }
}

