/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items;

import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.draconicevolution.blocks.tileentity.TileStabilizedSpawner;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.MobSoul;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;

public class ItemCore
extends Item {
    public ItemCore(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        InteractionHand hand = context.getHand();
        BlockPos pos = context.getClickedPos();
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof SpawnerBlockEntity) {
            if (!world.isClientSide) {
                SpawnData data = ((SpawnerBlockEntity)tile).getSpawner().nextSpawnData;
                if (data == null) {
                    return InteractionResult.FAIL;
                }
                String id = data.getEntityToSpawn().getString("id");
                if (id.isEmpty()) {
                    return InteractionResult.FAIL;
                }
                ResourceLocation name = new ResourceLocation(id);
                ItemStack soul = new ItemStack((ItemLike)DEContent.MOB_SOUL.get());
                ((MobSoul)((Object)DEContent.MOB_SOUL.get())).setEntity(name, soul);
                TileStabilizedSpawner.SpawnerTier tier = TileStabilizedSpawner.SpawnerTier.getTierFromCore(this);
                ItemStack spawner = new ItemStack((ItemLike)DEContent.STABILIZED_SPAWNER.get());
                CompoundTag managedData = new CompoundTag();
                spawner.getOrCreateTagElement("bc_tile_data").put("bc_managed_data", (Tag)managedData);
                managedData.put("mob_soul", (Tag)soul.save(new CompoundTag()));
                CompoundTag tierData = new CompoundTag();
                tierData.putByte("value", (byte)tier.ordinal());
                managedData.put("spawner_tier", (Tag)tierData);
                world.removeBlock(pos, false);
                world.addFreshEntity((Entity)new ItemEntity(world, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, spawner));
                InventoryUtils.consumeHeldItem((Player)context.getPlayer(), (ItemStack)context.getPlayer().getItemInHand(hand), (InteractionHand)hand);
            }
            return InteractionResult.PASS;
        }
        return super.useOn(context);
    }

    public boolean isFoil(ItemStack stack) {
        return stack.getItem() == DEContent.CORE_CHAOTIC.get() || super.isFoil(stack);
    }
}

