/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items;

import com.brandon3055.brandonscore.items.ItemBCore;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class MobSoul
extends ItemBCore {
    private static Map<String, Entity> renderEntityMap = new HashMap<String, Entity>();
    private static Map<String, String> entityNameCache = new HashMap<String, String>();
    public static List<String> randomDisplayList = null;
    private static Map<String, ResourceLocation> rlCache = new WeakHashMap<String, ResourceLocation>();

    public MobSoul(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        Direction facing = context.getClickedFace();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack stack = player.getItemInHand(context.getHand());
        if (player.isShiftKeyDown()) {
            Entity entity = this.createEntity(world, stack);
            double sX = (double)(pos.getX() + facing.getStepX()) + 0.5;
            double sY = (double)(pos.getY() + facing.getStepY()) + 0.5;
            double sZ = (double)(pos.getZ() + facing.getStepZ()) + 0.5;
            if (entity == null) {
                LogHelper.error("Mob Soul bound entity = null");
                return super.useOn(context);
            }
            entity.moveTo(sX, sY, sZ, player.getYRot(), 0.0f);
            if (!world.isClientSide) {
                CompoundTag compound = ItemNBTHelper.getCompound((ItemStack)stack);
                if (!compound.contains("EntityData") && entity instanceof Mob) {
                    ((Mob)entity).finalizeSpawn((ServerLevelAccessor)((ServerLevel)world), world.getCurrentDifficultyAt(new BlockPos(0, 0, 0)), MobSpawnType.SPAWN_EGG, null, null);
                }
                world.addFreshEntity(entity);
                if (!player.getAbilities().instabuild) {
                    InventoryUtils.consumeHeldItem((Player)player, (ItemStack)stack, (InteractionHand)context.getHand());
                }
            }
        }
        return super.useOn(context);
    }

    public Component getName(ItemStack stack) {
        String eName = this.getEntityString(stack);
        EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(MobSoul.getCachedRegName(eName));
        return Component.translatable((String)type.getDescriptionId()).append(" ").append(super.getName(stack));
    }

    public String getEntityString(ItemStack stack) {
        return ItemNBTHelper.getString((ItemStack)stack, (String)"EntityName", (String)"pig");
    }

    public void setEntity(ResourceLocation entityName, ItemStack stack) {
        ItemNBTHelper.setString((ItemStack)stack, (String)"EntityName", (String)String.valueOf(entityName));
    }

    @Nullable
    public CompoundTag getEntityData(ItemStack stack) {
        CompoundTag compound = ItemNBTHelper.getCompound((ItemStack)stack);
        if (compound.contains("EntityData")) {
            return compound.getCompound("EntityData");
        }
        return null;
    }

    public void setEntityData(CompoundTag compound, ItemStack stack) {
        compound.remove("UUID");
        compound.remove("Motion");
        ItemNBTHelper.getCompound((ItemStack)stack).put("EntityData", (Tag)compound);
    }

    public Entity createEntity(Level world, ItemStack stack) {
        try {
            String eName = this.getEntityString(stack);
            CompoundTag entityData = this.getEntityData(stack);
            EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(MobSoul.getCachedRegName(eName));
            Entity entity = type.create(world);
            if (entity == null) {
                return EntityType.PIG.create(world);
            }
            if (entityData != null) {
                entity.load(entityData);
            } else if (entity instanceof Mob) {
                ((Mob)entity).finalizeSpawn((ServerLevelAccessor)((ServerLevel)world), world.getCurrentDifficultyAt(new BlockPos(0, 0, 0)), MobSpawnType.SPAWN_EGG, null, null);
            }
            return entity;
        }
        catch (Throwable e) {
            return EntityType.PIG.create(world);
        }
    }

    public ItemStack getSoulFromEntity(Entity entity, boolean saveEntityData) {
        ItemStack soul = new ItemStack((ItemLike)DEContent.MOB_SOUL.get());
        String registryName = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()).toString();
        ItemNBTHelper.setString((ItemStack)soul, (String)"EntityName", (String)registryName);
        if (saveEntityData) {
            CompoundTag compound = new CompoundTag();
            entity.saveWithoutId(compound);
            this.setEntityData(compound, soul);
        }
        return soul;
    }

    public Entity getRenderEntity(ItemStack stack) {
        return this.getRenderEntity(this.getEntityString(stack));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Entity getRenderEntity(String name) {
        if (name.equals("[Random-Display]")) {
            if (randomDisplayList == null) {
                randomDisplayList = new ArrayList<String>();
                SpawnEggItem.BY_ID.keySet().forEach(type -> randomDisplayList.add(BuiltInRegistries.ENTITY_TYPE.getKey(type).toString()));
            }
            if (randomDisplayList.size() > 0) {
                name = randomDisplayList.get(ClientEventHandler.elapsedTicks / 20 % randomDisplayList.size());
            }
        }
        if (!renderEntityMap.containsKey(name)) {
            Entity entity;
            ClientLevel level = Minecraft.getInstance().level;
            try {
                EntityType type2 = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(MobSoul.getCachedRegName(name));
                entity = type2.create((Level)level);
                if (entity == null) {
                    entity = EntityType.PIG.create((Level)level);
                }
            }
            catch (Throwable e) {
                entity = EntityType.PIG.create((Level)level);
            }
            renderEntityMap.put(name, entity);
        }
        return renderEntityMap.get(name);
    }

    public static ResourceLocation getCachedRegName(String name) {
        return rlCache.computeIfAbsent(name, ResourceLocation::new);
    }
}

