/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.init.EquipCfg;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;

public class DETier
implements Tier {
    private TechLevel techLevel;

    public DETier(TechLevel techLevel) {
        this.techLevel = techLevel;
    }

    public int getUses() {
        return 0;
    }

    @Deprecated
    public int getLevel() {
        return this.techLevel.getHarvestLevel();
    }

    public int getEnchantmentValue() {
        return DETier.getEnchantability(this.techLevel);
    }

    public static int getEnchantability(TechLevel techLevel) {
        switch (techLevel) {
            case DRACONIUM: {
                return EquipCfg.draconiumEnchantability;
            }
            case WYVERN: {
                return EquipCfg.wyvernEnchantability;
            }
            case DRACONIC: {
                return EquipCfg.draconicEnchantability;
            }
            case CHAOTIC: {
                return EquipCfg.chaoticEnchantability;
            }
        }
        return 22;
    }

    public float getSpeed() {
        switch (this.techLevel) {
            case DRACONIUM: {
                return (float)EquipCfg.draconiumHarvestSpeed;
            }
            case WYVERN: {
                return (float)EquipCfg.wyvernHarvestSpeed;
            }
            case DRACONIC: {
                return (float)EquipCfg.draconicHarvestSpeed;
            }
            case CHAOTIC: {
                return (float)EquipCfg.chaoticHarvestSpeed;
            }
        }
        return 1.0f;
    }

    public float getAttackDamageBonus() {
        switch (this.techLevel) {
            case DRACONIUM: {
                return (float)EquipCfg.draconiumDamage;
            }
            case WYVERN: {
                return (float)EquipCfg.wyvernDamage;
            }
            case DRACONIC: {
                return (float)EquipCfg.draconicDamage;
            }
            case CHAOTIC: {
                return (float)EquipCfg.chaoticDamage;
            }
        }
        return 1.0f;
    }

    public float getAttackSpeed() {
        switch (this.techLevel) {
            case DRACONIUM: {
                return (float)EquipCfg.draconiumSwingSpeed;
            }
            case WYVERN: {
                return (float)EquipCfg.wyvernSwingSpeed;
            }
            case DRACONIC: {
                return (float)EquipCfg.draconicSwingSpeed;
            }
            case CHAOTIC: {
                return (float)EquipCfg.chaoticSwingSpeed;
            }
        }
        return 1.0f;
    }

    public Ingredient getRepairIngredient() {
        return Ingredient.EMPTY;
    }
}

