/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.api.IReaperItem;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.ProjectileData;
import com.brandon3055.draconicevolution.api.modules.data.SpeedData;
import com.brandon3055.draconicevolution.api.modules.entities.AutoFireEntity;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.entity.projectile.DraconicArrowEntity;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import com.brandon3055.draconicevolution.init.TechProperties;
import com.brandon3055.draconicevolution.items.equipment.IModularEnergyItem;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;
import org.jetbrains.annotations.NotNull;

public class ModularBow
extends BowItem
implements IReaperItem,
IModularEnergyItem {
    private final TechLevel techLevel;

    public ModularBow(TechProperties props) {
        super((Item.Properties)props);
        this.techLevel = props.getTechLevel();
    }

    @Override
    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    @Override
    @NotNull
    public ModuleHostImpl instantiateHost(ItemStack stack) {
        ModuleHostImpl host = new ModuleHostImpl(this.techLevel, ModuleCfg.toolWidth(this.techLevel), ModuleCfg.toolHeight(this.techLevel), "bow", ModuleCfg.removeInvalidModules, new ModuleCategory[0]);
        host.addCategories(ModuleCategory.RANGED_WEAPON);
        return host;
    }

    @Override
    @NotNull
    public ModularOPStorage instantiateOPStorage(ItemStack stack, Supplier<ModuleHost> hostSupplier) {
        return new ModularOPStorage(hostSupplier, EquipCfg.getBaseToolEnergy(this.techLevel), EquipCfg.getBaseToolTransfer(this.techLevel));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        this.addModularItemInformation(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public int getReaperLevel(ItemStack stack) {
        return this.techLevel.index;
    }

    public void onUseTick(Level pLevel, LivingEntity player, ItemStack stack, int count) {
        AutoFireEntity entity;
        if (this.getUseDuration(stack) - count >= ModularBow.getChargeTicks(stack) && (entity = (AutoFireEntity)((ModuleHost)stack.getCapability(DECapabilities.Host.ITEM)).getEntitiesByType(ModuleTypes.AUTO_FIRE).map(e -> (AutoFireEntity)e).findAny().orElse(null)) != null && entity.getAutoFireEnabled()) {
            InteractionHand usingHand = player.getUsedItemHand();
            player.stopUsingItem();
            stack.releaseUsing(player.level(), player, 0);
            player.startUsingItem(usingHand);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack;
        boolean hasAmmo = !player.getProjectile(stack = player.getItemInHand(hand)).isEmpty() || EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.INFINITY_ARROWS, (ItemStack)stack) > 0;
        InteractionResultHolder ret = EventHooks.onArrowNock((ItemStack)stack, (Level)world, (Player)player, (InteractionHand)hand, (boolean)hasAmmo);
        if (ret != null) {
            return ret;
        }
        if (EnergyUtils.getEnergyStored((ItemStack)stack) < ModularBow.calculateShotEnergy(stack)) {
            hasAmmo = false;
        }
        if (!player.getAbilities().instabuild && !hasAmmo) {
            return InteractionResultHolder.fail((Object)stack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            boolean noAmmoRequired = player.getAbilities().instabuild || EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.INFINITY_ARROWS, (ItemStack)stack) > 0;
            ItemStack ammoStack = player.getProjectile(stack);
            int drawTime = this.getUseDuration(stack) - timeLeft;
            if ((drawTime = EventHooks.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)drawTime, (!ammoStack.isEmpty() || noAmmoRequired ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!ammoStack.isEmpty() || noAmmoRequired) {
                if (ammoStack.isEmpty()) {
                    ammoStack = new ItemStack((ItemLike)Items.ARROW);
                }
                ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.Host.ITEM);
                ProjectileData projData = host.getModuleData(ModuleTypes.PROJ_MODIFIER, new ProjectileData(0.0f, 0.0f, 0.0f, 0.0f, 0.0f));
                float powerForTime = ModularBow.getPowerForTime(drawTime, stack) * (projData.velocity() + 1.0f);
                if ((double)powerForTime >= 0.1) {
                    boolean infiniteAmmo;
                    boolean bl = infiniteAmmo = player.getAbilities().instabuild || ammoStack.getItem() instanceof ArrowItem && ((ArrowItem)ammoStack.getItem()).isInfinite(ammoStack, stack, player);
                    if (!level.isClientSide) {
                        long energyRequired;
                        ArrowItem arrowitem = (ArrowItem)(ammoStack.getItem() instanceof ArrowItem ? ammoStack.getItem() : Items.ARROW);
                        AbstractArrow arrowEntity = this.customArrow(arrowitem.createArrow(level, ammoStack, (LivingEntity)player), ammoStack);
                        if (arrowEntity instanceof Arrow) {
                            ((Arrow)arrowEntity).setEffectsFromItem(ammoStack);
                        } else if (arrowEntity instanceof DraconicArrowEntity) {
                            ((DraconicArrowEntity)arrowEntity).setEffectsFromItem(ammoStack);
                        }
                        arrowEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, powerForTime * 3.0f, 1.0f - projData.accuracy());
                        if (arrowEntity instanceof DraconicArrowEntity) {
                            DraconicArrowEntity deArrow = (DraconicArrowEntity)arrowEntity;
                            deArrow.setTechLevel(this.techLevel);
                            deArrow.setPenetration(projData.penetration());
                            deArrow.setGravComp(projData.antiGrav());
                            if (host.getEntitiesByType(ModuleTypes.PROJ_ANTI_IMMUNE).findAny().isPresent()) {
                                deArrow.setProjectileImmuneOverride(true);
                            }
                        }
                        if (powerForTime == 1.0f) {
                            arrowEntity.setCritArrow(true);
                        }
                        arrowEntity.setBaseDamage(arrowEntity.getBaseDamage() * (double)(projData.damage() + 1.0f));
                        int j = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.POWER_ARROWS, (ItemStack)stack);
                        if (j > 0) {
                            arrowEntity.setBaseDamage(arrowEntity.getBaseDamage() + (double)j * 0.5 + 0.5);
                        }
                        if (this.extractEnergy(player, stack, energyRequired = (long)((double)EquipCfg.bowBaseEnergy * arrowEntity.getBaseDamage() * (double)powerForTime * 3.0)) < energyRequired) {
                            return;
                        }
                        int k = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.PUNCH_ARROWS, (ItemStack)stack);
                        if (k > 0) {
                            arrowEntity.setKnockback(k);
                        }
                        if (EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.FLAMING_ARROWS, (ItemStack)stack) > 0) {
                            arrowEntity.setSecondsOnFire(100);
                        }
                        if (infiniteAmmo) {
                            arrowEntity.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                        }
                        level.addFreshEntity((Entity)arrowEntity);
                    }
                    level.playSound((Player)null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.random.nextFloat() * 0.4f + 1.2f) + powerForTime * 0.5f);
                    if (!infiniteAmmo && !player.getAbilities().instabuild) {
                        ammoStack.shrink(1);
                        if (ammoStack.isEmpty()) {
                            player.getInventory().removeItem(ammoStack);
                        }
                    }
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                }
            }
        }
    }

    public AbstractArrow customArrow(AbstractArrow arrow, ItemStack stack) {
        if (arrow.getType() != EntityType.ARROW && arrow.getType() != EntityType.SPECTRAL_ARROW) {
            return arrow;
        }
        Entity owner = arrow.getOwner();
        if (!(owner instanceof LivingEntity)) {
            return new DraconicArrowEntity((EntityType<? extends DraconicArrowEntity>)((EntityType)DEContent.ENTITY_DRACONIC_ARROW.get()), arrow.level(), stack);
        }
        DraconicArrowEntity newArrow = new DraconicArrowEntity(arrow.level(), (LivingEntity)arrow.getOwner(), stack);
        if (arrow instanceof SpectralArrow) {
            newArrow.setSpectral(((SpectralArrow)arrow).duration);
        }
        return newArrow;
    }

    public static float calculateDamage(ItemStack stack) {
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.Host.ITEM);
        ProjectileData projData = host.getModuleData(ModuleTypes.PROJ_MODIFIER, new ProjectileData(0.0f, 0.0f, 0.0f, 0.0f, 0.0f));
        float baseDamage = 2.0f;
        baseDamage *= 1.0f + projData.damage();
        baseDamage *= 3.0f * (1.0f + projData.velocity());
        int j = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.POWER_ARROWS, (ItemStack)stack);
        if (j > 0) {
            baseDamage = (float)((double)baseDamage + ((double)j * 0.5 + 0.5));
        }
        return baseDamage;
    }

    public static long calculateShotEnergy(ItemStack stack) {
        float damage = ModularBow.calculateDamage(stack);
        return (long)(damage * (float)EquipCfg.bowBaseEnergy);
    }

    public static float getPowerForTime(int time, ItemStack stack) {
        float fullChargeTime = ModularBow.getChargeTicks(stack);
        float power = (float)time / fullChargeTime;
        if ((power = (power * power + power * 2.0f) / 3.0f) > 1.0f) {
            power = 1.0f;
        }
        return power;
    }

    public static int getChargeTicks(ItemStack stack) {
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.Host.ITEM);
        SpeedData data = host.getModuleData(ModuleTypes.SPEED);
        float speedModifier = data == null ? 0.0f : (float)data.speedMultiplier();
        return (int)Math.ceil(20.0f / (speedModifier += 1.0f));
    }

    @Override
    public void addModularItemInformation(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        IModularEnergyItem.super.addModularItemInformation(stack, worldIn, tooltip, flagIn);
        if (worldIn != null && stack.getCapability(DECapabilities.Host.ITEM) != null) {
            tooltip.add((Component)Component.translatable((String)"tooltip.draconicevolution.bow.damage", (Object[])new Object[]{Float.valueOf((float)Math.round(ModularBow.calculateDamage(stack) * 10.0f) / 10.0f)}).withStyle(ChatFormatting.DARK_GREEN));
            tooltip.add((Component)Component.translatable((String)"tooltip.draconicevolution.bow.energy_per_shot", (Object[])new Object[]{Utils.addCommas((long)ModularBow.calculateShotEnergy(stack))}).withStyle(ChatFormatting.DARK_GREEN));
        }
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.damageBarVisible(stack);
    }

    public int getBarWidth(ItemStack stack) {
        return this.damageBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        return this.damageBarColour(stack);
    }

    public boolean canBeHurtBy(DamageSource source) {
        return source.is(DamageTypes.FELL_OUT_OF_WORLD);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.getAge() >= 0) {
            entity.setExtendedLifetime();
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public boolean isEnchantable(ItemStack p_41456_) {
        return true;
    }
}

