/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.IDraconicMelee;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import com.brandon3055.draconicevolution.init.TechProperties;
import com.brandon3055.draconicevolution.items.equipment.DETier;
import com.brandon3055.draconicevolution.items.equipment.IModularEnergyItem;
import com.brandon3055.draconicevolution.items.equipment.IModularMiningTool;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ModularPickaxe
extends PickaxeItem
implements IModularMiningTool,
IDraconicMelee,
IModularEnergyItem {
    private final TechLevel techLevel;
    private final DETier itemTier;

    public ModularPickaxe(DETier tier, TechProperties props) {
        super((Tier)tier, 0, 0.0f, (Item.Properties)props);
        this.techLevel = props.getTechLevel();
        this.itemTier = (DETier)this.getTier();
    }

    @Override
    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    @Override
    public DETier getItemTier() {
        return this.itemTier;
    }

    @Override
    public double getSwingSpeedMultiplier() {
        return EquipCfg.pickaxeSwingSpeedMultiplier;
    }

    @Override
    public double getDamageMultiplier() {
        return EquipCfg.pickaxeDamageMultiplier;
    }

    @Override
    @NotNull
    public ModuleHostImpl instantiateHost(ItemStack stack) {
        return new ModuleHostImpl(this.techLevel, ModuleCfg.toolWidth(this.techLevel), ModuleCfg.toolHeight(this.techLevel), "pickaxe", ModuleCfg.removeInvalidModules, new ModuleCategory[0]);
    }

    @Override
    @NotNull
    public ModularOPStorage instantiateOPStorage(ItemStack stack, Supplier<ModuleHost> hostSupplier) {
        return new ModularOPStorage(hostSupplier, EquipCfg.getBaseToolEnergy(this.techLevel), EquipCfg.getBaseToolTransfer(this.techLevel));
    }

    @Override
    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return IModularMiningTool.super.getDestroySpeed(stack, state);
    }

    @Override
    public float getBaseEfficiency() {
        return this.getTier().getSpeed();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        this.addModularItemInformation(stack, worldIn, tooltip, flagIn);
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.damageBarVisible(stack);
    }

    public int getBarWidth(ItemStack stack) {
        return this.damageBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        return this.damageBarColour(stack);
    }

    public boolean canBeHurtBy(DamageSource source) {
        return source.is(DamageTypes.FELL_OUT_OF_WORLD);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.getAge() >= 0) {
            entity.setExtendedLifetime();
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public boolean isEnchantable(ItemStack p_41456_) {
        return true;
    }
}

