/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.IReaperItem;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.DamageModData;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import com.brandon3055.draconicevolution.init.TechProperties;
import com.brandon3055.draconicevolution.items.equipment.DETier;
import com.brandon3055.draconicevolution.items.equipment.IModularEnergyItem;
import com.brandon3055.draconicevolution.items.equipment.IModularMelee;
import com.brandon3055.draconicevolution.items.equipment.IModularMiningTool;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ModularStaff
extends DiggerItem
implements IReaperItem,
IModularMiningTool,
IModularMelee,
IModularEnergyItem {
    private final TechLevel techLevel;
    private final DETier itemTier;

    public ModularStaff(DETier tier, TechProperties props) {
        super(0.0f, 0.0f, (Tier)tier, BlockTags.MINEABLE_WITH_PICKAXE, (Item.Properties)props);
        this.techLevel = props.getTechLevel();
        this.itemTier = (DETier)this.getTier();
    }

    @Override
    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    @Override
    public DETier getItemTier() {
        return this.itemTier;
    }

    @Override
    public double getSwingSpeedMultiplier() {
        return EquipCfg.staffSwingSpeedMultiplier;
    }

    @Override
    public double getDamageMultiplier() {
        return EquipCfg.staffDamageMultiplier;
    }

    @Override
    @NotNull
    public ModuleHostImpl instantiateHost(ItemStack stack) {
        ModuleHostImpl host = new ModuleHostImpl(this.techLevel, ModuleCfg.staffWidth(this.techLevel), ModuleCfg.staffHeight(this.techLevel), "staff", ModuleCfg.removeInvalidModules, new ModuleCategory[0]);
        host.addCategories(ModuleCategory.TOOL_AXE);
        host.addCategories(ModuleCategory.TOOL_HOE);
        host.addCategories(ModuleCategory.TOOL_SHOVEL);
        return host;
    }

    @Override
    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return true;
    }

    @Override
    @NotNull
    public ModularOPStorage instantiateOPStorage(ItemStack stack, Supplier<ModuleHost> hostSupplier) {
        return new ModularOPStorage(hostSupplier, EquipCfg.getBaseStaffEnergy(this.techLevel), EquipCfg.getBaseStaffTransfer(this.techLevel));
    }

    @Override
    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return IModularMiningTool.super.getDestroySpeed(stack, state);
    }

    @Override
    public float getBaseEfficiency() {
        return this.getTier().getSpeed() * EquipCfg.getStaffEffMult();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        this.addModularItemInformation(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public int getReaperLevel(ItemStack stack) {
        return this.techLevel.index + 1;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.category == EnchantmentCategory.DIGGER || enchantment.category == EnchantmentCategory.WEAPON || enchantment.category.name().equals("PICKAXE_OR_SHOVEL") || enchantment.category.name().equals("SWORD_OR_AXE") || enchantment.category.name().equals("SWORD_OR_AXE_OR_CROSSBOW") || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.damageBarVisible(stack);
    }

    public int getBarWidth(ItemStack stack) {
        return this.damageBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        return this.damageBarColour(stack);
    }

    public boolean canBeHurtBy(DamageSource source) {
        return source.is(DamageTypes.FELL_OUT_OF_WORLD);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.getAge() >= 0) {
            entity.setExtendedLifetime();
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public boolean isEnchantable(ItemStack p_41456_) {
        return true;
    }

    public static float getRenderChargeState(float chargeTime) {
        if (chargeTime >= 40.0f) {
            return Math.min(1.0f, 0.5f + (chargeTime - 40.0f) / 5.0f);
        }
        if (chargeTime >= 20.0f) {
            return Math.min(0.5f, (chargeTime - 20.0f) / 5.0f);
        }
        return 0.0f;
    }

    public static float getDrawPower(float drawProgress) {
        drawProgress = (drawProgress * drawProgress + drawProgress * 2.0f) / 3.0f;
        return Math.min(drawProgress, 1.0f);
    }

    private boolean canFire(ItemStack stack, Player player) {
        return true;
    }

    @Nullable
    public static Module<DamageModData> getDamageModule(ItemStack stack) {
        ModuleHost host = (ModuleHost)stack.getCapability(DECapabilities.Host.ITEM);
        ModuleEntity entity = host.getEntitiesByType(ModuleTypes.DAMAGE_MOD).findAny().orElse(null);
        return entity != null && entity.getModule().getData() instanceof DamageModData ? entity.getModule() : null;
    }
}

