/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import com.brandon3055.brandonscore.api.hud.IHudItem;
import com.brandon3055.brandonscore.lib.DelayedTask;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import com.brandon3055.brandonscore.utils.TargetPos;
import com.brandon3055.draconicevolution.handlers.DESounds;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.tools.DislocatorAdvanced;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class Dislocator
extends Item
implements IHudItem {
    public Dislocator(Item.Properties properties) {
        super(properties.fireResistant());
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public Entity dislocateEntity(ItemStack stack, @Nonnull Entity user, @Nonnull Entity target, TargetPos targetPos) {
        if (target.level().isClientSide) {
            return target;
        }
        if (targetPos == null) {
            this.messageUser(user, (Component)Component.translatable((String)"dislocate.draconicevolution.not_set").withStyle(ChatFormatting.RED));
            return target;
        }
        BCoreNetwork.sendSound((Level)target.level(), (BlockPos)target.blockPosition(), (SoundEvent)((SoundEvent)DESounds.PORTAL.get()), (SoundSource)SoundSource.PLAYERS, (float)0.1f, (float)(target.level().random.nextFloat() * 0.1f + 0.9f), (boolean)false);
        Entity finalTarget = target = targetPos.teleport(target);
        DelayedTask.run((int)1, () -> BCoreNetwork.sendSound((Level)finalTarget.level(), (BlockPos)finalTarget.blockPosition(), (SoundEvent)((SoundEvent)DESounds.PORTAL.get()), (SoundSource)SoundSource.PLAYERS, (float)0.1f, (float)(finalTarget.level().random.nextFloat() * 0.1f + 0.9f), (boolean)false));
        return target;
    }

    public void messageUser(Entity user, Component message) {
        if (user instanceof Player) {
            ((Player)user).displayClientMessage(message, true);
        }
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (entity instanceof Player && !(this instanceof DislocatorAdvanced)) {
            this.messageUser((Entity)player, (Component)Component.translatable((String)"dislocate.draconicevolution.player_need_advanced").withStyle(ChatFormatting.RED));
            return true;
        }
        if (player.level().isClientSide || !entity.canChangeDimensions() || !(entity instanceof LivingEntity) || player.getCooldowns().getCooldownPercent((Item)this, 0.0f) > 0.0f) {
            return true;
        }
        TargetPos location = this.getTargetPos(stack, player.level());
        player.getCooldowns().addCooldown((Item)this, 20);
        this.dislocateEntity(stack, (Entity)player, entity, location);
        stack.hurtAndBreak(1, (LivingEntity)player, e -> {});
        if (location != null) {
            this.messageUser((Entity)player, (Component)Component.literal((String)(I18n.get((String)"dislocate.draconicevolution.entity_sent_to", (Object[])new Object[0]) + " " + location.getReadableName(false))).withStyle(ChatFormatting.GREEN));
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (world.isClientSide) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        TargetPos targetPos = this.getTargetPos(stack, world);
        if (player.isShiftKeyDown()) {
            if (targetPos == null) {
                targetPos = new TargetPos((Entity)player);
                this.setLocation(stack, targetPos);
                this.messageUser((Entity)player, (Component)Component.translatable((String)"dislocate.draconicevolution.bound_to").append("{" + targetPos.getReadableName(false) + "}").withStyle(ChatFormatting.GREEN));
            } else {
                this.messageUser((Entity)player, (Component)Component.translatable((String)"dislocate.draconicevolution.already_bound").withStyle(ChatFormatting.RED));
            }
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (targetPos == null) {
            this.messageUser((Entity)player, (Component)Component.translatable((String)"dislocate.draconicevolution.not_set").withStyle(ChatFormatting.RED));
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (player.getHealth() > 2.0f || player.getAbilities().instabuild) {
            player.getCooldowns().addCooldown((Item)this, 20);
            this.dislocateEntity(stack, (Entity)player, (Entity)player, targetPos);
            stack.hurtAndBreak(1, (LivingEntity)player, e -> {});
            if (!player.getAbilities().instabuild) {
                player.setHealth(player.getHealth() - 2.0f);
            }
        } else {
            this.messageUser((Entity)player, (Component)Component.translatable((String)"dislocate.draconicevolution.low_health").withStyle(ChatFormatting.RED));
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public boolean isFoil(ItemStack stack) {
        return this.getTargetPos(stack, null) != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flagIn) {
        TargetPos targetPos = this.getTargetPos(stack, world);
        if (targetPos == null) {
            tooltip.add((Component)Component.translatable((String)"dislocate.draconicevolution.un_set_info1").withStyle(ChatFormatting.RED));
            tooltip.add((Component)Component.translatable((String)"dislocate.draconicevolution.un_set_info2").withStyle(ChatFormatting.WHITE));
            tooltip.add((Component)Component.translatable((String)"dislocate.draconicevolution.un_set_info3").withStyle(ChatFormatting.WHITE));
            tooltip.add((Component)Component.translatable((String)"dislocate.draconicevolution.un_set_info4").withStyle(ChatFormatting.WHITE));
            tooltip.add((Component)Component.translatable((String)"dislocate.draconicevolution.un_set_info5").withStyle(ChatFormatting.WHITE));
        } else {
            tooltip.add((Component)Component.translatable((String)"dislocate.draconicevolution.bound_to").withStyle(ChatFormatting.GREEN));
            tooltip.add((Component)Component.literal((String)(ChatFormatting.WHITE + "{" + targetPos.getReadableName(flagIn.isAdvanced()) + "}")));
            tooltip.add((Component)Component.translatable((String)"dislocate.draconicevolution.uses_remain", (Object[])new Object[]{stack.getMaxDamage() - stack.getDamageValue() + 1}).withStyle(ChatFormatting.BLUE));
        }
    }

    public TargetPos getTargetPos(ItemStack stack, @Nullable Level world) {
        CompoundTag targetTag = stack.getTagElement("target");
        if (targetTag != null) {
            return new TargetPos(targetTag);
        }
        return null;
    }

    public void setLocation(ItemStack stack, TargetPos pos) {
        stack.addTagElement("target", (Tag)pos.writeToNBT());
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public boolean isValidRepairItem(ItemStack toRepair, ItemStack repair) {
        return repair.getItem() == DEContent.INGOT_DRACONIUM.get();
    }

    public float getXpRepairRatio(ItemStack stack) {
        return 1.0f;
    }

    public void generateHudText(ItemStack stack, Player player, List<Component> displayList) {
        TargetPos location = this.getTargetPos(stack, player.level());
        if (location != null) {
            displayList.add(stack.getHoverName());
            displayList.add((Component)Component.literal((String)("{" + location.getReadableName(false) + ")")));
        }
    }

    public boolean canBeHurtBy(DamageSource source) {
        return source.is(DamageTypes.FELL_OUT_OF_WORLD);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.getAge() >= 0) {
            entity.setExtendedLifetime();
        }
        return super.onEntityItemUpdate(stack, entity);
    }
}

