/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import com.brandon3055.brandonscore.items.ItemBCore;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.init.DEContent;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerXpEvent;

public class Magnet
extends ItemBCore {
    private final int range;

    public Magnet(Item.Properties properties, int range) {
        super(properties);
        this.range = range;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil(ItemStack stack) {
        return Magnet.isEnabled(stack);
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entity, int itemSlot, boolean isSelected) {
        this.updateMagnet(stack, entity);
    }

    private void updateMagnet(ItemStack stack, Entity entity) {
        if (!entity.isShiftKeyDown() && Magnet.isEnabled(stack) && entity instanceof Player) {
            Player player = (Player)entity;
            Level world = entity.getCommandSenderWorld();
            List items = entity.tickCount % 10 == 0 ? world.getEntitiesOfClass(ItemEntity.class, new AABB(entity.getX(), entity.getY(), entity.getZ(), entity.getX(), entity.getY(), entity.getZ()).inflate((double)this.range, (double)this.range, (double)this.range)) : world.getEntitiesOfClass(ItemEntity.class, new AABB(entity.getX(), entity.getY(), entity.getZ(), entity.getX(), entity.getY(), entity.getZ()).inflate(5.0, 5.0, 5.0));
            boolean flag = false;
            for (ItemEntity itemEntity : items) {
                Player closest;
                CompoundTag itemTag;
                if (!itemEntity.isAlive() || (itemTag = itemEntity.getPersistentData()) != null && itemTag.contains("PreventRemoteMovement") || itemEntity.getOwner() != null && itemEntity.getOwner().equals((Object)entity.getUUID()) && itemEntity.pickupDelay > 0 || (closest = world.getNearestPlayer((Entity)itemEntity, 4.0)) != null && closest != entity) continue;
                BlockPos pos = itemEntity.blockPosition();
                boolean blocked = false;
                for (BlockPos checkPos : BlockPos.betweenClosed((BlockPos)pos.offset(-5, -5, -5), (BlockPos)pos.offset(5, 5, 5))) {
                    if (world.getBlockState(checkPos).getBlock() != DEContent.DISLOCATION_INHIBITOR.get()) continue;
                    blocked = true;
                    break;
                }
                if (blocked) continue;
                if (entity.distanceToSqr((Entity)itemEntity) > 4.0) {
                    flag = true;
                }
                if (world.isClientSide) continue;
                if (itemEntity.pickupDelay > 0) {
                    itemEntity.pickupDelay = 0;
                }
                itemEntity.setDeltaMovement(0.0, 0.0, 0.0);
                itemEntity.fallDistance = 0.0f;
                itemEntity.setPos(entity.getX() - 0.2 + world.random.nextDouble() * 0.4, entity.getY() - 0.6, entity.getZ() - 0.2 + world.random.nextDouble() * 0.4);
            }
            if (flag && DEConfig.itemDislocatorSound) {
                world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, 1.0f + world.random.nextFloat() * 0.1f);
            }
            List xp = world.getEntitiesOfClass(ExperienceOrb.class, new AABB(entity.getX(), entity.getY(), entity.getZ(), entity.getX(), entity.getY(), entity.getZ()).inflate(4.0, 4.0, 4.0));
            for (ExperienceOrb orb : xp) {
                PlayerXpEvent.PickupXp event;
                if (world.isClientSide || !orb.isAlive() || (event = (PlayerXpEvent.PickupXp)NeoForge.EVENT_BUS.post((Event)new PlayerXpEvent.PickupXp(player, orb))).isCanceled()) continue;
                if (DEConfig.itemDislocatorSound) {
                    world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, 0.5f * ((world.random.nextFloat() - world.random.nextFloat()) * 0.7f + 1.8f));
                }
                player.take((Entity)orb, 1);
                player.giveExperiencePoints(orb.value);
                orb.discard();
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            Magnet.toggleEnabled(stack, player);
        }
        return super.use(world, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Level p_77624_2_, List list, TooltipFlag p_77624_4_) {
    }

    public static boolean isEnabled(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)"IsActive", (boolean)false);
    }

    public static void toggleEnabled(ItemStack stack, Player player) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)"IsActive", (!Magnet.isEnabled(stack) ? 1 : 0) != 0);
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.1f, Magnet.isEnabled(stack) ? 1.0f : 0.5f);
    }
}

