/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.lib;

import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.handlers.ProcessHandler;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;

public class ExplosionHelper {
    private final ServerLevel serverWorld;
    private BlockPos start;
    private HashSet<LevelChunk> modifiedChunks = new HashSet();
    private HashSet<Long> blocksToUpdate = new HashSet();
    private HashSet<Long> lightUpdates = new HashSet();
    private HashSet<Long> tilesToRemove = new HashSet();
    private HashMap<ChunkPos, LevelChunk> chunkCache = new HashMap();
    private static final BlockState AIR = Blocks.AIR.defaultBlockState();
    public BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();
    public LinkedList<HashSet<Long>> toRemove = new LinkedList();

    public ExplosionHelper(ServerLevel serverWorld, BlockPos start) {
        this.serverWorld = serverWorld;
        this.start = start;
    }

    public void setBlocksForRemoval(LinkedList<HashSet<Long>> list) {
        this.toRemove = list;
    }

    public void addBlocksForUpdate(Collection<Long> blocksToUpdate) {
        this.blocksToUpdate.addAll(blocksToUpdate);
    }

    private void removeBlock(BlockPos pos) {
        LevelChunk chunk = this.getChunk(pos);
        BlockState oldState = chunk.getBlockState(pos);
        if (oldState.getBlock() instanceof EntityBlock) {
            this.serverWorld.removeBlock(pos, false);
            this.serverWorld.getLightEngine().checkBlock(pos);
            return;
        }
        LevelChunkSection storage = this.getBlockStorage(pos);
        if (storage != null) {
            storage.setBlockState(pos.getX() & 0xF, pos.getY() & 0xF, pos.getZ() & 0xF, AIR);
        }
        this.setChunkModified(pos);
        this.serverWorld.getLightEngine().checkBlock(pos);
    }

    public void setChunkModified(BlockPos blockPos) {
        LevelChunk chunk = this.getChunk(blockPos);
        this.setChunkModified(chunk);
    }

    public void setChunkModified(LevelChunk chunk) {
        this.modifiedChunks.add(chunk);
    }

    private LevelChunk getChunk(BlockPos pos) {
        ChunkPos cp = new ChunkPos(pos);
        if (!this.chunkCache.containsKey(cp)) {
            this.chunkCache.put(cp, this.serverWorld.getChunk(pos.getX() >> 4, pos.getZ() >> 4));
        }
        return this.chunkCache.get(cp);
    }

    private LevelChunkSection getBlockStorage(BlockPos pos) {
        LevelChunk chunk = this.getChunk(pos);
        return chunk.getSection(chunk.getSectionIndex(pos.getY()));
    }

    public void finish() {
        LogHelper.dev("EH: finish");
        RemovalProcess process = new RemovalProcess(this);
        ProcessHandler.addProcess((IProcess)process);
    }

    public boolean isAirBlock(BlockPos pos) {
        return this.serverWorld.isEmptyBlock(pos);
    }

    public BlockState getBlockState(BlockPos pos) {
        LevelChunkSection storage = this.getBlockStorage(pos);
        if (storage == null) {
            return Blocks.AIR.defaultBlockState();
        }
        return storage.getBlockState(pos.getX() & 0xF, pos.getY() & 0xF, pos.getZ() & 0xF);
    }

    private static class RemovalProcess
    implements IProcess {
        public boolean isDead = false;
        private ExplosionHelper helper;
        int index = 0;
        private MinecraftServer server;
        public BlockPos.MutableBlockPos mPos = new BlockPos.MutableBlockPos();

        public RemovalProcess(ExplosionHelper helper) {
            this.helper = helper;
            this.server = helper.serverWorld.getServer();
        }

        public void updateProcess() {
            this.server.nextTickTimeNanos = Util.getNanos();
            while (Util.getNanos() - this.server.nextTickTimeNanos < 50000000L && this.helper.toRemove.size() > 0) {
                LogHelper.dev("Processing chunks at rad: " + this.index);
                HashSet<Long> set = this.helper.toRemove.removeFirst();
                for (long pos : set) {
                    this.helper.removeBlock((BlockPos)this.mPos.set(pos));
                }
                ++this.index;
            }
            this.finishChunks();
            if (this.helper.toRemove.isEmpty()) {
                this.isDead = true;
                this.updateBlocks();
                DraconicNetwork.sendExplosionEffect((ResourceKey<Level>)this.helper.serverWorld.dimension(), this.helper.start, 0, true);
            }
        }

        public void finishChunks() {
            for (LevelChunk chunk : this.helper.modifiedChunks) {
                chunk.setLightCorrect(false);
                ThreadedLevelLightEngine lightManager = (ThreadedLevelLightEngine)this.helper.serverWorld.getLightEngine();
                ClientboundLevelChunkWithLightPacket packet = new ClientboundLevelChunkWithLightPacket(chunk, this.helper.serverWorld.getLightEngine(), null, null);
                this.helper.serverWorld.getChunkSource().chunkMap.getPlayers(chunk.getPos(), false).forEach(e -> e.connection.send((Packet)packet));
            }
            this.helper.modifiedChunks.clear();
        }

        private void updateBlocks() {
            LogHelper.startTimer("Updating Blocks");
            try {
                LogHelper.dev("Updating " + this.helper.blocksToUpdate.size() + " Blocks");
                int i = 0;
                ArrayList list = new ArrayList();
                for (long pos : this.helper.blocksToUpdate) {
                    BlockState state = this.helper.serverWorld.getBlockState((BlockPos)this.mPos.set(pos));
                    if (state.getBlock() instanceof FallingBlock) {
                        state.getBlock().tick(state, this.helper.serverWorld, (BlockPos)this.helper.mPos.set(pos), this.helper.serverWorld.random);
                    }
                    state.neighborChanged((Level)this.helper.serverWorld, (BlockPos)this.mPos.set(pos), Blocks.AIR, this.mPos.set(pos).above(), false);
                }
                LogHelper.dev("Total Falling Blocks " + i);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            LogHelper.stopTimer();
        }

        public boolean isDead() {
            return this.isDead;
        }
    }
}

