/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.network;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CrystalUpdateBatcher {
    public static final Map<Integer, BlockPos> ID_CRYSTAL_MAP = new HashMap<Integer, BlockPos>();
    private static final Map<ServerPlayer, List<BatchedCrystalUpdate>> batchQue = new HashMap<ServerPlayer, List<BatchedCrystalUpdate>>();

    public static void queData(BatchedCrystalUpdate update, ServerPlayer target) {
        batchQue.computeIfAbsent(target, e -> new ArrayList()).add(update);
    }

    public static void tickEnd() {
        if (!batchQue.isEmpty()) {
            for (ServerPlayer playerMP : batchQue.keySet()) {
                List<BatchedCrystalUpdate> playerData = batchQue.get(playerMP);
                if (playerData.isEmpty()) continue;
                PacketCustom packet = new PacketCustom(DraconicNetwork.CHANNEL_NAME, 1);
                packet.writeVarInt(playerData.size());
                playerData.forEach(update -> update.writeData((MCDataOutput)packet));
                packet.sendToPlayer(playerMP);
            }
            batchQue.clear();
        }
    }

    public static void handleBatchedData(MCDataInput input) {
        int count = input.readVarInt();
        for (int i = 0; i < count; ++i) {
            BlockEntity tile;
            BatchedCrystalUpdate update = new BatchedCrystalUpdate();
            update.readData(input);
            if (!ID_CRYSTAL_MAP.containsKey(update.crystalID) || !((tile = BrandonsCore.proxy.getClientWorld().getBlockEntity(ID_CRYSTAL_MAP.get(update.crystalID))) instanceof TileCrystalBase) || tile.isRemoved()) continue;
            ((TileCrystalBase)tile).receiveBatchedUpdate(update);
        }
    }

    public static class BatchedCrystalUpdate {
        public int crystalID;
        public long crystalCapacity;
        public Map<Byte, Byte> indexToFlowMap = new LinkedHashMap<Byte, Byte>();

        public BatchedCrystalUpdate() {
        }

        public BatchedCrystalUpdate(int crystalID, long crystalCapacity) {
            this.crystalID = crystalID;
            this.crystalCapacity = crystalCapacity;
        }

        public void writeData(MCDataOutput output) {
            output.writeVarInt(this.crystalID);
            output.writeVarLong(this.crystalCapacity);
            output.writeByte(this.indexToFlowMap.size());
            for (Byte index : this.indexToFlowMap.keySet()) {
                output.writeByte((int)index.byteValue());
                output.writeByte((int)this.indexToFlowMap.get(index).byteValue());
            }
        }

        public void readData(MCDataInput input) {
            this.crystalID = input.readVarInt();
            this.crystalCapacity = input.readVarLong();
            int count = input.readByte();
            for (int i = 0; i < count; ++i) {
                byte index = input.readByte();
                this.indexToFlowMap.put(index, input.readByte());
            }
        }
    }
}

