package com.brandon3055.draconicevolution.api.modules.items;

import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.data.EnergyLinkData;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCoreStabilizer;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyPylon;
import com.brandon3055.draconicevolution.blocks.tileentity.TileStructureBlock;
import com.brandon3055.draconicevolution.init.ItemData;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

import java.util.UUID;
import java.util.function.Supplier;

import static com.brandon3055.draconicevolution.DraconicEvolution.MODID;

public class EnergyLinkModuleItem extends ModuleItem<EnergyLinkData> {


    public EnergyLinkModuleItem(Properties properties, Supplier<Module<?>> moduleSupplier) {
        super(properties, moduleSupplier);
    }

    public EnergyLinkModuleItem(Supplier<Module<?>> moduleSupplier) {
        super(new Properties().stacksTo(1), moduleSupplier);
    }

    @Override
    public void inventoryTick(ItemStack stack, Level level, Entity entity, int p_41407_, boolean p_41408_) {
        if (!(level instanceof ServerLevel serverLevel) || TimeKeeper.getServerTick() % 20 != 0) return;
        checkResetLink(stack, serverLevel);
    }

    public static void checkResetLink(ItemStack stack, ServerLevel level) {
        GlobalPos pos = stack.get(ItemData.LINK_MODULE_LINK_POS);
        UUID uuid = stack.get(ItemData.LINK_MODULE_LINK_ID);
        if (pos == null || uuid == null) {
            return;
        }

        ServerLevel coreLevel = level.getServer().getLevel(pos.dimension());

        boolean reset = coreLevel == null;
        if (!reset) {
            if (coreLevel.getBlockEntity(pos.pos()) instanceof TileEnergyCore core) {
                if (!uuid.equals(core.linkUUID.get())) {
                    reset = true;
                }
            } else {
                reset = true;
            }
        }

        if (reset) {
            stack.remove(ItemData.LINK_MODULE_LINK_POS);
            stack.remove(ItemData.LINK_MODULE_LINK_ID);
        }
    }

    @Override
    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        if (level.isClientSide || player == null || !player.isShiftKeyDown()) return InteractionResult.SUCCESS;

        BlockEntity blockEntity = level.getBlockEntity(context.getClickedPos());
        if (blockEntity instanceof TileStructureBlock structureBlock) blockEntity = (BlockEntity) structureBlock.getController();
        if (blockEntity instanceof TileEnergyPylon pylon) blockEntity = pylon.getCore();
        if (blockEntity instanceof TileEnergyCoreStabilizer stabilizer) blockEntity = stabilizer.getCore();
        if (!(blockEntity instanceof TileEnergyCore core)) return InteractionResult.PASS;
        UUID linkId = core.linkUUID.get();

        if (!core.active.get() || linkId == null) {
            player.sendSystemMessage(Component.translatable("module." + MODID + ".energy_link.core_not_active"));
            return InteractionResult.PASS;
        }

        ItemStack stack = context.getItemInHand();
        BlockPos pos = core.getBlockPos();
        stack.set(ItemData.LINK_MODULE_LINK_POS, GlobalPos.of(level.dimension(), pos));
        stack.set(ItemData.LINK_MODULE_LINK_ID, linkId);

        return InteractionResult.CONSUME;
    }
}
