package com.brandon3055.draconicevolution.blocks.machines;

import com.brandon3055.brandonscore.blocks.EntityBlockBCore;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.draconicevolution.init.DEContent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;

/**
 * Created by brandon3055 on 14/11/2016.
 */
public class FlowGate extends EntityBlockBCore {

    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    private final boolean fluxGate;

    public FlowGate(Properties properties, boolean fluxGate) {
        super(properties);
        this.fluxGate = fluxGate;
        this.registerDefaultState(stateDefinition.any().setValue(FACING, Direction.NORTH));
        setBlockEntity(() -> fluxGate ? DEContent.TILE_FLUX_GATE.get() : DEContent.TILE_FLUID_GATE.get(), true);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(FACING);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.defaultBlockState().setValue(FACING, context.getNearestLookingDirection().getOpposite());
    }

    @Override
    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return state.setValue(FACING, FacingUtils.rotateXYZ(state.getValue(FACING)));
    }
}