package com.brandon3055.draconicevolution.datagen;

import com.brandon3055.brandonscore.datagen.MultiBlockProvider;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.DETags;
import net.minecraft.core.BlockPos;
import net.minecraft.data.DataGenerator;
import net.neoforged.neoforge.common.Tags;

/**
 * Created by brandon3055 on 26/06/2022
 */
public class MultiBlockGenerator extends MultiBlockProvider {

    public MultiBlockGenerator(DataGenerator gen) {
        super(gen, DraconicEvolution.MODID);
    }

    @Override
    protected void buildMultiBlocks() {
        buildTier1();
        buildTier2();
        buildTier3();
        buildTier4();
        buildTier5();
        buildTier6();
        buildTier7();
        buildTier8();
    }

    private void buildTier1() {
        builder("energy_core_1")
                .key('X', DEContent.ENERGY_CORE)
                .addRow("X")
                .build();
    }

    private void buildTier2() {
        builder("energy_core_2")
                .key('X', DEContent.ENERGY_CORE)
                .key('D', DETags.Blocks.STORAGE_BLOCKS_DRACONIUM)
                .setOrigin(new BlockPos(1, 1, 1))

                .addRow("   ")
                .addRow(" D ")
                .addRow("   ")
                .newLayer()
                .addRow(" D ")
                .addRow("DXD")
                .addRow(" D ")
                .newLayer()
                .addRow("   ")
                .addRow(" D ")
                .addRow("   ")
                .build();

    }

    private void buildTier3() {
        builder("energy_core_3")
                .key('X', DEContent.ENERGY_CORE)
                .key('D', DETags.Blocks.STORAGE_BLOCKS_DRACONIUM)
                .setOrigin(new BlockPos(1, 1, 1))

                .addRow("DDD")
                .addRow("DDD")
                .addRow("DDD")
                .newLayer()
                .addRow("DDD")
                .addRow("DXD")
                .addRow("DDD")
                .newLayer()
                .addRow("DDD")
                .addRow("DDD")
                .addRow("DDD")
                .build();

    }

    private void buildTier4() {
        builder("energy_core_4")
                .key('X', DEContent.ENERGY_CORE)
                .key('D', DETags.Blocks.STORAGE_BLOCKS_DRACONIUM)
                .key('R', Tags.Blocks.STORAGE_BLOCKS_REDSTONE)
                .setOrigin(new BlockPos(2, 2, 2))

                .addRow("     ")
                .addRow(" DDD ")
                .addRow(" DDD ")
                .addRow(" DDD ")
                .addRow("     ")
                .newLayer()
                .addRow(" DDD ")
                .addRow("DRRRD")
                .addRow("DRRRD")
                .addRow("DRRRD")
                .addRow(" DDD ")
                .newLayer()
                .addRow(" DDD ")
                .addRow("DRRRD")
                .addRow("DRXRD")
                .addRow("DRRRD")
                .addRow(" DDD ")
                .newLayer()
                .addRow(" DDD ")
                .addRow("DRRRD")
                .addRow("DRRRD")
                .addRow("DRRRD")
                .addRow(" DDD ")
                .newLayer()
                .addRow("     ")
                .addRow(" DDD ")
                .addRow(" DDD ")
                .addRow(" DDD ")
                .addRow("     ")
                .build();

    }

    private void buildTier5() {
        builder("energy_core_5")
                .key('X', DEContent.ENERGY_CORE)
                .key('D', DETags.Blocks.STORAGE_BLOCKS_DRACONIUM)
                .key('R', Tags.Blocks.STORAGE_BLOCKS_REDSTONE)
                .setOrigin(new BlockPos(3, 3, 3))

                .addRow("       ")
                .addRow("       ")
                .addRow("  DDD  ")
                .addRow("  DDD  ")
                .addRow("  DDD  ")
                .addRow("       ")
                .addRow("       ")
                .newLayer()
                .addRow("       ")
                .addRow("  DDD  ")
                .addRow(" DRRRD ")
                .addRow(" DRRRD ")
                .addRow(" DRRRD ")
                .addRow("  DDD  ")
                .addRow("       ")
                .newLayer()
                .addRow("  DDD  ")
                .addRow(" DRRRD ")
                .addRow("DRRRRRD")
                .addRow("DRRRRRD")
                .addRow("DRRRRRD")
                .addRow(" DRRRD ")
                .addRow("  DDD  ")
                .newLayer()
                .addRow("  DDD  ")
                .addRow(" DRRRD ")
                .addRow("DRRRRRD")
                .addRow("DRRXRRD")
                .addRow("DRRRRRD")
                .addRow(" DRRRD ")
                .addRow("  DDD  ")
                .newLayer()
                .addRow("  DDD  ")
                .addRow(" DRRRD ")
                .addRow("DRRRRRD")
                .addRow("DRRRRRD")
                .addRow("DRRRRRD")
                .addRow(" DRRRD ")
                .addRow("  DDD  ")
                .newLayer()
                .addRow("       ")
                .addRow("  DDD  ")
                .addRow(" DRRRD ")
                .addRow(" DRRRD ")
                .addRow(" DRRRD ")
                .addRow("  DDD  ")
                .addRow("       ")
                .newLayer()
                .addRow("       ")
                .addRow("       ")
                .addRow("  DDD  ")
                .addRow("  DDD  ")
                .addRow("  DDD  ")
                .addRow("       ")
                .addRow("       ")
                .build();

    }

    private void buildTier6() {
        builder("energy_core_6")
                .key('X', DEContent.ENERGY_CORE)
                .key('D', DETags.Blocks.STORAGE_BLOCKS_DRACONIUM)
                .key('R', Tags.Blocks.STORAGE_BLOCKS_REDSTONE)
                .setOrigin(new BlockPos(4, 4, 4))

                .addRow("         ")
                .addRow("         ")
                .addRow("         ")
                .addRow("   DDD   ")
                .addRow("   DDD   ")
                .addRow("   DDD   ")
                .addRow("         ")
                .addRow("         ")
                .addRow("         ")
                .newLayer()
                .addRow("         ")
                .addRow("         ")
                .addRow("  DDDDD  ")
                .addRow("  DRRRD  ")
                .addRow("  DRRRD  ")
                .addRow("  DRRRD  ")
                .addRow("  DDDDD  ")
                .addRow("         ")
                .addRow("         ")
                .newLayer()
                .addRow("         ")
                .addRow("  DDDDD  ")
                .addRow(" DRRRRRD ")
                .addRow(" DRRRRRD ")
                .addRow(" DRRRRRD ")
                .addRow(" DRRRRRD ")
                .addRow(" DRRRRRD ")
                .addRow("  DDDDD  ")
                .addRow("         ")
                .newLayer()
                .addRow("   DDD   ")
                .addRow("  DRRRD  ")
                .addRow(" DRRRRRD ")
                .addRow("DRRRRRRRD")
                .addRow("DRRRRRRRD")
                .addRow("DRRRRRRRD")
                .addRow(" DRRRRRD ")
                .addRow("  DRRRD  ")
                .addRow("   DDD   ")
                .newLayer()
                .addRow("   DDD   ")
                .addRow("  DRRRD  ")
                .addRow(" DRRRRRD ")
                .addRow("DRRRRRRRD")
                .addRow("DRRRXRRRD")
                .addRow("DRRRRRRRD")
                .addRow(" DRRRRRD ")
                .addRow("  DRRRD  ")
                .addRow("   DDD   ")
                .newLayer()
                .addRow("   DDD   ")
                .addRow("  DRRRD  ")
                .addRow(" DRRRRRD ")
                .addRow("DRRRRRRRD")
                .addRow("DRRRRRRRD")
                .addRow("DRRRRRRRD")
                .addRow(" DRRRRRD ")
                .addRow("  DRRRD  ")
                .addRow("   DDD   ")
                .newLayer()
                .addRow("         ")
                .addRow("  DDDDD  ")
                .addRow(" DRRRRRD ")
                .addRow(" DRRRRRD ")
                .addRow(" DRRRRRD ")
                .addRow(" DRRRRRD ")
                .addRow(" DRRRRRD ")
                .addRow("  DDDDD  ")
                .addRow("         ")
                .newLayer()
                .addRow("         ")
                .addRow("         ")
                .addRow("  DDDDD  ")
                .addRow("  DRRRD  ")
                .addRow("  DRRRD  ")
                .addRow("  DRRRD  ")
                .addRow("  DDDDD  ")
                .addRow("         ")
                .addRow("         ")
                .newLayer()
                .addRow("         ")
                .addRow("         ")
                .addRow("         ")
                .addRow("   DDD   ")
                .addRow("   DDD   ")
                .addRow("   DDD   ")
                .addRow("         ")
                .addRow("         ")
                .addRow("         ")
                .build();

    }

    private void buildTier7() {
        builder("energy_core_7")
                .key('X', DEContent.ENERGY_CORE)
                .key('D', DETags.Blocks.STORAGE_BLOCKS_DRACONIUM)
                .key('R', Tags.Blocks.STORAGE_BLOCKS_REDSTONE)
                .setOrigin(new BlockPos(5, 5, 5))

                .addRow("           ")
                .addRow("           ")
                .addRow("           ")
                .addRow("           ")
                .addRow("    DDD    ")
                .addRow("    DDD    ")
                .addRow("    DDD    ")
                .addRow("           ")
                .addRow("           ")
                .addRow("           ")
                .addRow("           ")
                .newLayer()
                .addRow("           ")
                .addRow("           ")
                .addRow("           ")
                .addRow("   DDDDD   ")
                .addRow("   DRRRD   ")
                .addRow("   DRRRD   ")
                .addRow("   DRRRD   ")
                .addRow("   DDDDD   ")
                .addRow("           ")
                .addRow("           ")
                .addRow("           ")
                .newLayer()
                .addRow("           ")
                .addRow("           ")
                .addRow("   DDDDD   ")
                .addRow("  DRRRRRD  ")
                .addRow("  DRRRRRD  ")
                .addRow("  DRRRRRD  ")
                .addRow("  DRRRRRD  ")
                .addRow("  DRRRRRD  ")
                .addRow("   DDDDD   ")
                .addRow("           ")
                .addRow("           ")
                .newLayer()
                .addRow("           ")
                .addRow("   DDDDD   ")
                .addRow("  DRRRRRD  ")
                .addRow(" DRRRRRRRD ")
                .addRow(" DRRRRRRRD ")
                .addRow(" DRRRRRRRD ")
                .addRow(" DRRRRRRRD ")
                .addRow(" DRRRRRRRD ")
                .addRow("  DRRRRRD  ")
                .addRow("   DDDDD   ")
                .addRow("           ")
                .newLayer()
                .addRow("    DDD    ")
                .addRow("   DRRRD   ")
                .addRow("  DRRRRRD  ")
                .addRow(" DRRRRRRRD ")
                .addRow("DRRRRRRRRRD")
                .addRow("DRRRRRRRRRD")
                .addRow("DRRRRRRRRRD")
                .addRow(" DRRRRRRRD ")
                .addRow("  DRRRRRD  ")
                .addRow("   DRRRD   ")
                .addRow("    DDD    ")

                .newLayer()
                .addRow("    DDD    ")
                .addRow("   DRRRD   ")
                .addRow("  DRRRRRD  ")
                .addRow(" DRRRRRRRD ")
                .addRow("DRRRRRRRRRD")
                .addRow("DRRRRXRRRRD")
                .addRow("DRRRRRRRRRD")
                .addRow(" DRRRRRRRD ")
                .addRow("  DRRRRRD  ")
                .addRow("   DRRRD   ")
                .addRow("    DDD    ")
                .newLayer()
                .addRow("    DDD    ")
                .addRow("   DRRRD   ")
                .addRow("  DRRRRRD  ")
                .addRow(" DRRRRRRRD ")
                .addRow("DRRRRRRRRRD")
                .addRow("DRRRRRRRRRD")
                .addRow("DRRRRRRRRRD")
                .addRow(" DRRRRRRRD ")
                .addRow("  DRRRRRD  ")
                .addRow("   DRRRD   ")
                .addRow("    DDD    ")
                .newLayer()
                .addRow("           ")
                .addRow("   DDDDD   ")
                .addRow("  DRRRRRD  ")
                .addRow(" DRRRRRRRD ")
                .addRow(" DRRRRRRRD ")
                .addRow(" DRRRRRRRD ")
                .addRow(" DRRRRRRRD ")
                .addRow(" DRRRRRRRD ")
                .addRow("  DRRRRRD  ")
                .addRow("   DDDDD   ")
                .addRow("           ")
                .newLayer()
                .addRow("           ")
                .addRow("           ")
                .addRow("   DDDDD   ")
                .addRow("  DRRRRRD  ")
                .addRow("  DRRRRRD  ")
                .addRow("  DRRRRRD  ")
                .addRow("  DRRRRRD  ")
                .addRow("  DRRRRRD  ")
                .addRow("   DDDDD   ")
                .addRow("           ")
                .addRow("           ")
                .newLayer()
                .addRow("           ")
                .addRow("           ")
                .addRow("           ")
                .addRow("   DDDDD   ")
                .addRow("   DRRRD   ")
                .addRow("   DRRRD   ")
                .addRow("   DRRRD   ")
                .addRow("   DDDDD   ")
                .addRow("           ")
                .addRow("           ")
                .addRow("           ")
                .newLayer()
                .addRow("           ")
                .addRow("           ")
                .addRow("           ")
                .addRow("           ")
                .addRow("    DDD    ")
                .addRow("    DDD    ")
                .addRow("    DDD    ")
                .addRow("           ")
                .addRow("           ")
                .addRow("           ")
                .addRow("           ")
                .build();

    }

    private void buildTier8() {
        builder("energy_core_8")
                .key('X', DEContent.ENERGY_CORE)
                .key('D', DETags.Blocks.STORAGE_BLOCKS_DRACONIUM)
                .key('A', DETags.Blocks.STORAGE_BLOCKS_DRACONIUM_AWAKENED)
                .setOrigin(new BlockPos(6, 6, 6))

                .addRow("             ")
                .addRow("             ")
                .addRow("             ")
                .addRow("             ")
                .addRow("    AAAAA    ")
                .addRow("    AAAAA    ")
                .addRow("    AAAAA    ")
                .addRow("    AAAAA    ")
                .addRow("    AAAAA    ")
                .addRow("             ")
                .addRow("             ")
                .addRow("             ")
                .addRow("             ")
                .newLayer()
                .addRow("             ")
                .addRow("             ")
                .addRow("             ")
                .addRow("   AAAAAAA   ")
                .addRow("   ADDDDDA   ")
                .addRow("   ADDDDDA   ")
                .addRow("   ADDDDDA   ")
                .addRow("   ADDDDDA   ")
                .addRow("   ADDDDDA   ")
                .addRow("   AAAAAAA   ")
                .addRow("             ")
                .addRow("             ")
                .addRow("             ")
                .newLayer()
                .addRow("             ")
                .addRow("             ")
                .addRow("   AAAAAAA   ")
                .addRow("  ADDDDDDDA  ")
                .addRow("  ADDDDDDDA  ")
                .addRow("  ADDDDDDDA  ")
                .addRow("  ADDDDDDDA  ")
                .addRow("  ADDDDDDDA  ")
                .addRow("  ADDDDDDDA  ")
                .addRow("  ADDDDDDDA  ")
                .addRow("   AAAAAAA   ")
                .addRow("             ")
                .addRow("             ")
                .newLayer()
                .addRow("             ")
                .addRow("   AAAAAAA   ")
                .addRow("  ADDDDDDDA  ")
                .addRow(" ADDDDDDDDDA ")
                .addRow(" ADDDDDDDDDA ")
                .addRow(" ADDDDDDDDDA ")
                .addRow(" ADDDDDDDDDA ")
                .addRow(" ADDDDDDDDDA ")
                .addRow(" ADDDDDDDDDA ")
                .addRow(" ADDDDDDDDDA ")
                .addRow("  ADDDDDDDA  ")
                .addRow("   AAAAAAA   ")
                .addRow("             ")
                .newLayer()
                .addRow("    AAAAA    ")
                .addRow("   ADDDDDA   ")
                .addRow("  ADDDDDDDA  ")
                .addRow(" ADDDDDDDDDA ")
                .addRow("ADDDDDDDDDDDA")
                .addRow("ADDDDDDDDDDDA")
                .addRow("ADDDDDDDDDDDA")
                .addRow("ADDDDDDDDDDDA")
                .addRow("ADDDDDDDDDDDA")
                .addRow(" ADDDDDDDDDA ")
                .addRow("  ADDDDDDDA  ")
                .addRow("   ADDDDDA   ")
                .addRow("    AAAAA    ")
                .newLayer()
                .addRow("    AAAAA    ")
                .addRow("   ADDDDDA   ")
                .addRow("  ADDDDDDDA  ")
                .addRow(" ADDDDDDDDDA ")
                .addRow("ADDDDDDDDDDDA")
                .addRow("ADDDDDDDDDDDA")
                .addRow("ADDDDDDDDDDDA")
                .addRow("ADDDDDDDDDDDA")
                .addRow("ADDDDDDDDDDDA")
                .addRow(" ADDDDDDDDDA ")
                .addRow("  ADDDDDDDA  ")
                .addRow("   ADDDDDA   ")
                .addRow("    AAAAA    ")

                .newLayer()
                .addRow("    AAAAA    ")
                .addRow("   ADDDDDA   ")
                .addRow("  ADDDDDDDA  ")
                .addRow(" ADDDDDDDDDA ")
                .addRow("ADDDDDDDDDDDA")
                .addRow("ADDDDDDDDDDDA")
                .addRow("ADDDDDXDDDDDA")
                .addRow("ADDDDDDDDDDDA")
                .addRow("ADDDDDDDDDDDA")
                .addRow(" ADDDDDDDDDA ")
                .addRow("  ADDDDDDDA  ")
                .addRow("   ADDDDDA   ")
                .addRow("    AAAAA    ")
                .newLayer()
                .addRow("    AAAAA    ")
                .addRow("   ADDDDDA   ")
                .addRow("  ADDDDDDDA  ")
                .addRow(" ADDDDDDDDDA ")
                .addRow("ADDDDDDDDDDDA")
                .addRow("ADDDDDDDDDDDA")
                .addRow("ADDDDDDDDDDDA")
                .addRow("ADDDDDDDDDDDA")
                .addRow("ADDDDDDDDDDDA")
                .addRow(" ADDDDDDDDDA ")
                .addRow("  ADDDDDDDA  ")
                .addRow("   ADDDDDA   ")
                .addRow("    AAAAA    ")
                .newLayer()
                .addRow("    AAAAA    ")
                .addRow("   ADDDDDA   ")
                .addRow("  ADDDDDDDA  ")
                .addRow(" ADDDDDDDDDA ")
                .addRow("ADDDDDDDDDDDA")
                .addRow("ADDDDDDDDDDDA")
                .addRow("ADDDDDDDDDDDA")
                .addRow("ADDDDDDDDDDDA")
                .addRow("ADDDDDDDDDDDA")
                .addRow(" ADDDDDDDDDA ")
                .addRow("  ADDDDDDDA  ")
                .addRow("   ADDDDDA   ")
                .addRow("    AAAAA    ")
                .newLayer()
                .addRow("             ")
                .addRow("   AAAAAAA   ")
                .addRow("  ADDDDDDDA  ")
                .addRow(" ADDDDDDDDDA ")
                .addRow(" ADDDDDDDDDA ")
                .addRow(" ADDDDDDDDDA ")
                .addRow(" ADDDDDDDDDA ")
                .addRow(" ADDDDDDDDDA ")
                .addRow(" ADDDDDDDDDA ")
                .addRow(" ADDDDDDDDDA ")
                .addRow("  ADDDDDDDA  ")
                .addRow("   AAAAAAA   ")
                .addRow("             ")
                .newLayer()
                .addRow("             ")
                .addRow("             ")
                .addRow("   AAAAAAA   ")
                .addRow("  ADDDDDDDA  ")
                .addRow("  ADDDDDDDA  ")
                .addRow("  ADDDDDDDA  ")
                .addRow("  ADDDDDDDA  ")
                .addRow("  ADDDDDDDA  ")
                .addRow("  ADDDDDDDA  ")
                .addRow("  ADDDDDDDA  ")
                .addRow("   AAAAAAA   ")
                .addRow("             ")
                .addRow("             ")
                .newLayer()
                .addRow("             ")
                .addRow("             ")
                .addRow("             ")
                .addRow("   AAAAAAA   ")
                .addRow("   ADDDDDA   ")
                .addRow("   ADDDDDA   ")
                .addRow("   ADDDDDA   ")
                .addRow("   ADDDDDA   ")
                .addRow("   ADDDDDA   ")
                .addRow("   AAAAAAA   ")
                .addRow("             ")
                .addRow("             ")
                .addRow("             ")
                .newLayer()
                .addRow("             ")
                .addRow("             ")
                .addRow("             ")
                .addRow("             ")
                .addRow("    AAAAA    ")
                .addRow("    AAAAA    ")
                .addRow("    AAAAA    ")
                .addRow("    AAAAA    ")
                .addRow("    AAAAA    ")
                .addRow("             ")
                .addRow("             ")
                .addRow("             ")
                .addRow("             ")
                .build();

    }
}
