/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.capability;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.capability.IdentityProvider;
import com.brandon3055.draconicevolution.api.capability.PropertyProvider;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleType;
import com.brandon3055.draconicevolution.api.modules.data.ModuleData;
import com.brandon3055.draconicevolution.api.modules.lib.InstallResult;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleContext;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleEntity;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.network.chat.Component;

public interface ModuleHost
extends IdentityProvider,
AutoCloseable,
PropertyProvider {
    public Stream<Module<?>> getModules();

    public List<ModuleEntity<?>> getModuleEntities();

    public void addModule(ModuleEntity<?> var1, ModuleContext var2);

    public void removeModule(ModuleEntity<?> var1, ModuleContext var2);

    default public boolean isModuleSupported(ModuleEntity<?> entity) {
        Module<?> module = entity.getModule();
        ModuleType<?> type = module.getType();
        if (this.getTypeBlackList().contains(type)) {
            return false;
        }
        if (this.getAdditionalTypes().contains(type) || module.getCategories().contains(ModuleCategory.ALL)) {
            return true;
        }
        Collection<ModuleCategory> hostCats = this.getModuleCategories();
        for (ModuleCategory cat : module.getCategories()) {
            if (!hostCats.contains(cat)) continue;
            return true;
        }
        return false;
    }

    public Collection<ModuleCategory> getModuleCategories();

    default public Collection<ModuleType<?>> getAdditionalTypes() {
        return Collections.emptyList();
    }

    default public Collection<ModuleType<?>> getTypeBlackList() {
        return Collections.emptyList();
    }

    public TechLevel getHostTechLevel();

    public int getGridWidth();

    public int getGridHeight();

    @Nullable
    default public <T extends ModuleData<T>> T getModuleData(ModuleType<T> moduleType) {
        return (T)((ModuleData)this.getModules().filter(module -> module.getType() == moduleType).map(Module::getData).reduce((o1, other) -> o1.combine(other)).orElse(null));
    }

    default public <T extends ModuleData<T>> T getModuleData(ModuleType<T> moduleType, T fallback) {
        T data = this.getModuleData(moduleType);
        return data == null ? fallback : data;
    }

    default public Stream<ModuleEntity<?>> getEntitiesByType(ModuleType<?> moduleType) {
        return this.getModuleEntities().stream().filter(e -> e.getModule().getType() == moduleType);
    }

    default public Stream<ModuleType<?>> getInstalledTypes() {
        return this.getModules().map(Module::getType).distinct();
    }

    default public <T extends ModuleData<T>> void getDataInformation(T moduleData, Map<Component, Component> map, ModuleContext context) {
        if (moduleData == null) {
            return;
        }
        moduleData.addInformation(map, context);
    }

    default public void addInformation(Map<Component, Component> map, ModuleContext context) {
        this.getInstalledTypes().map(this::getModuleData).forEach(data -> this.getDataInformation((ModuleData)SneakyUtils.unsafeCast((Object)data), map, context));
    }

    public static InstallResult checkAddModule(ModuleHost host, Module<?> newModule) {
        return newModule.doInstallationCheck(host.getModules());
    }

    public boolean checkRemoveModule(ModuleEntity<?> var1, List<Component> var2);

    public void handleTick(ModuleContext var1);

    @Override
    public void markDirty();

    @Override
    public void close();

    default public void save() {
        this.close();
    }
}

