/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.draconicevolution.blocks.tileentity.TileStabilizedSpawner;
import com.brandon3055.draconicevolution.handlers.DEEventHandler;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.items.MobSoul;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import org.jetbrains.annotations.Nullable;

public class StabilizedSpawnerLogic
extends BaseSpawner {
    private TileStabilizedSpawner tile;
    private double mobRotation;
    private double prevMobRotation;
    private int spawnRange = 4;

    public StabilizedSpawnerLogic(TileStabilizedSpawner tile) {
        this.tile = tile;
    }

    public void clientTick(Level level, BlockPos pos) {
        if (!this.isNearPlayer(level, pos)) {
            this.prevMobRotation = this.mobRotation;
        } else {
            double d3 = (float)pos.getX() + level.random.nextFloat();
            double d4 = (float)pos.getY() + level.random.nextFloat();
            double d5 = (float)pos.getZ() + level.random.nextFloat();
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d3, d4, d5, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, d3, d4, d5, 0.0, 0.0, 0.0);
            if (this.tile.spawnDelay.get() > 0) {
                this.tile.spawnDelay.dec();
            }
            this.prevMobRotation = this.mobRotation;
            this.mobRotation = (this.mobRotation + (double)(1000.0f / ((float)this.tile.spawnDelay.get() + 200.0f))) % 360.0;
        }
    }

    public void serverTick(ServerLevel level, BlockPos pos) {
        if (this.isNearPlayer((Level)level, pos)) {
            if (this.tile.spawnDelay.get() == -1) {
                this.resetTimer();
            }
            if (this.tile.spawnDelay.get() > 0) {
                this.tile.spawnDelay.dec();
                return;
            }
            TileStabilizedSpawner.SpawnerTier tier = (TileStabilizedSpawner.SpawnerTier)this.tile.spawnerTier.get();
            boolean flag = false;
            int successCount = 0;
            for (int i = 0; i < tier.getSpawnCount() + tier.ordinal() + 3; ++i) {
                Entity entity = ((MobSoul)((Object)DEContent.MOB_SOUL.get())).createEntity((Level)level, this.tile.mobSoul.get());
                do {
                    double spawnX = (double)pos.getX() + (level.random.nextDouble() - level.random.nextDouble()) * (double)this.spawnRange + 0.5;
                    double spawnY = pos.getY() + level.random.nextInt(3) - 1;
                    double spawnZ = (double)pos.getZ() + (level.random.nextDouble() - level.random.nextDouble()) * (double)this.spawnRange + 0.5;
                    entity.absMoveTo(spawnX, spawnY, spawnZ, 0.0f, 0.0f);
                } while (entity.blockPosition().getX() == this.tile.getBlockPos().getX() && entity.blockPosition().getZ() == this.tile.getBlockPos().getZ());
                int nearbyCount = level.getEntitiesOfClass(entity.getClass(), new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1)).inflate((double)this.spawnRange)).size();
                if (nearbyCount >= tier.getMaxCluster()) {
                    this.resetTimer();
                    return;
                }
                LivingEntity entityliving = entity instanceof LivingEntity ? (LivingEntity)entity : null;
                entity.moveTo(entity.getX(), entity.getY(), entity.getZ(), level.random.nextFloat() * 360.0f, 0.0f);
                if (entityliving == null || !(entityliving instanceof Mob) || this.canEntitySpawnSpawner((Mob)entityliving, (ServerLevel)this.tile.getLevel(), (float)entity.getX(), (float)entity.getY(), (float)entity.getZ(), this)) {
                    if (!tier.requiresPlayer() && entity instanceof Mob) {
                        ((Mob)entity).setPersistenceRequired();
                        entity.getPersistentData().putLong("DESpawnedMob", System.currentTimeMillis());
                        DEEventHandler.onMobSpawnedBySpawner((Mob)entity);
                    }
                    if (!level.tryAddFreshEntityWithPassengers(entity)) {
                        this.resetTimer();
                        return;
                    }
                    level.levelEvent(2004, pos, 0);
                    if (entityliving != null) {
                        if (entity instanceof Mob) {
                            ((Mob)entity).spawnAnim();
                        }
                        if (tier == TileStabilizedSpawner.SpawnerTier.CHAOTIC) {
                            double velocity = 2.5;
                            entity.setDeltaMovement((level.random.nextDouble() - 0.5) * velocity, level.random.nextDouble() * velocity, (level.random.nextDouble() - 0.5) * velocity);
                        }
                    }
                    flag = true;
                    ++successCount;
                }
                if (successCount >= tier.getSpawnCount()) break;
            }
            if (flag) {
                this.resetTimer();
            }
        }
    }

    public boolean canEntitySpawnSpawner(Mob entity, ServerLevel level, float x, float y, float z, BaseSpawner spawner) {
        MobSpawnEvent.PositionCheck event = new MobSpawnEvent.PositionCheck(entity, (ServerLevelAccessor)level, MobSpawnType.SPAWNER, null);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == MobSpawnEvent.PositionCheck.Result.DEFAULT) {
            return (((TileStabilizedSpawner.SpawnerTier)this.tile.spawnerTier.get()).ignoreSpawnReq() || entity.checkSpawnRules((LevelAccessor)level, MobSpawnType.SPAWNER)) && entity.checkSpawnObstruction((LevelReader)level);
        }
        return event.getResult() == MobSpawnEvent.PositionCheck.Result.SUCCEED;
    }

    private void resetTimer() {
        TileStabilizedSpawner.SpawnerTier tier = (TileStabilizedSpawner.SpawnerTier)this.tile.spawnerTier.get();
        if (tier.getMaxDelay() <= tier.getMinDelay()) {
            this.tile.spawnDelay.set((short)tier.getMinDelay());
        } else {
            int i = tier.getMaxDelay() - tier.getMinDelay();
            this.tile.spawnDelay.set((short)(tier.getMinDelay() + this.tile.getLevel().random.nextInt(i)));
        }
        this.broadcastEvent(this.tile.getLevel(), this.tile.getBlockPos(), 1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getSpin() {
        return this.mobRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getoSpin() {
        return this.prevMobRotation;
    }

    public CompoundTag save(CompoundTag compound) {
        return compound;
    }

    public void load(@Nullable Level level, BlockPos pos, CompoundTag tag) {
    }

    public boolean onEventTriggered(Level level, int delay) {
        return false;
    }

    @Nullable
    public Entity getOrCreateDisplayEntity(Level p_254323_, BlockPos p_254313_) {
        return this.tile.getRenderEntity();
    }

    public void broadcastEvent(Level level, BlockPos blockPos, int event) {
        level.blockEvent(blockPos, Blocks.SPAWNER, event, 0);
    }

    public boolean isNearPlayer(Level p_151344_, BlockPos p_151345_) {
        return this.tile.isActive();
    }
}

