/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.api.power.OPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.client.particle.IntParticleData;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.IRedstoneEmitter;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.lib.datamanager.ManagedShort;
import com.brandon3055.brandonscore.lib.entityfilter.EntityFilter;
import com.brandon3055.brandonscore.lib.entityfilter.FilterType;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.EntityDetectorMenu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class TileEntityDetector
extends TileBCore
implements MenuProvider,
IInteractTile,
IRedstoneEmitter {
    public float lookYaw = 0.0f;
    public float lookPitch = 1.5707964f;
    public float lastLookYaw = 0.0f;
    public float lastLookPitch = 0.0f;
    public final ManagedShort pulseRate = (ManagedShort)this.register((IManagedData)new ManagedShort("pulse_rate", 30, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public final ManagedShort range = (ManagedShort)this.register((IManagedData)new ManagedShort("range", 10, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public final ManagedByte rsMinDetection = (ManagedByte)this.register((IManagedData)new ManagedByte("rs_min_detection", 1, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public final ManagedByte rsMaxDetection = (ManagedByte)this.register((IManagedData)new ManagedByte("rs_max_detection", 1, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public final ManagedBool pulseRsMode = (ManagedBool)this.register((IManagedData)new ManagedBool("pulse_rs_mode", new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE}));
    public final ManagedByte outputStrength = (ManagedByte)this.register((IManagedData)new ManagedByte("output_strength", new DataFlags[]{DataFlags.SAVE_NBT}));
    private int pulseTimer = -1;
    private int pulseDuration = 0;
    public OPStorage opStorage = new ModularOPStorage(this, 512000L, 32000L, 0L);
    public EntityFilter entityFilter;
    public List<String> playerNames = new ArrayList<String>();

    public TileEntityDetector(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_ENTITY_DETECTOR.get(), pos, state);
        this.capManager.setManaged("energy", CapabilityOP.BLOCK, (INBTSerializable)this.opStorage, new Direction[0]).saveBoth().syncContainer();
        this.entityFilter = this.isAdvanced() ? new EntityFilter(false, FilterType.values()) : new EntityFilter(true, new FilterType[]{FilterType.PLAYER, FilterType.HOSTILE});
        this.entityFilter.setDirtyHandler(() -> ((TileEntityDetector)this).setChanged());
        this.entityFilter.setupServerPacketHandling(() -> this.createClientBoundPacket(9), packet -> this.sendPacketToClients(this.getAccessingPlayers(), (PacketCustom)packet));
        this.entityFilter.setupClientPacketHandling(() -> this.createServerBoundPacket(9));
        this.setClientSidePacketHandler(9, input -> this.entityFilter.receivePacketFromServer(input));
        this.setServerSidePacketHandler(9, (input, player) -> this.entityFilter.receivePacketFromClient(input));
        this.setSavedDataObject("entity_filter", (INBTSerializable)this.entityFilter);
        this.setItemSavedDataObject("entity_filter", (INBTSerializable)this.entityFilter);
    }

    public static void register(RegisterCapabilitiesEvent event) {
        TileEntityDetector.energyCapability((RegisterCapabilitiesEvent)event, DEContent.TILE_ENTITY_DETECTOR);
    }

    public void tick() {
        super.tick();
        if (this.level.isClientSide) {
            this.updateAnimation();
            return;
        }
        if (this.pulseTimer == -1) {
            this.pulseTimer = this.pulseRate.get();
        } else if (this.pulseTimer > 0) {
            --this.pulseTimer;
        } else if (this.pulseTimer <= 0) {
            if (this.opStorage.getEnergyStored() >= this.getPulseCost()) {
                this.pulseTimer = this.pulseRate.get();
                this.doScanPulse();
            } else {
                this.pulseTimer = 10;
            }
        }
        if (this.outputStrength.get() > 0 && this.pulseRsMode.get() && this.pulseDuration <= 0) {
            this.outputStrength.zero();
            this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
        } else {
            --this.pulseDuration;
        }
    }

    public void onPlayerOpenContainer(Player player) {
        super.onPlayerOpenContainer(player);
        if (player instanceof ServerPlayer) {
            this.entityFilter.syncClient((ServerPlayer)player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void updateAnimation() {
        List entities = this.entityFilter.filterEntities((Collection)this.level.getEntitiesOfClass(Entity.class, new AABB(this.worldPosition).inflate((double)this.range.get(), (double)this.range.get(), (double)this.range.get())));
        Entity closest = null;
        double closestDist = -1.0;
        Vec3 posVec = new Vec3((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ());
        for (Entity entity : entities) {
            if (closest == null) {
                closest = entity;
                closestDist = entity.distanceToSqr(posVec);
                continue;
            }
            if (!(entity.distanceToSqr(posVec) < closestDist)) continue;
            closest = entity;
            closestDist = entity.distanceToSqr(posVec);
        }
        this.lastLookYaw = this.lookYaw;
        this.lastLookPitch = this.lookPitch;
        if (closest != null) {
            Vector3 closePos = new Vector3(closest.getEyePosition());
            Vector3 relative = closePos.copy().subtract(Vector3.fromBlockPosCenter((BlockPos)this.getBlockPos()));
            double dist = closePos.distance(Vector3.fromBlockPosCenter((BlockPos)this.getBlockPos()));
            float targetYaw = (float)(Mth.atan2((double)relative.x, (double)relative.z) * 57.29577951308232) + 180.0f;
            float deviation = targetYaw - this.lookYaw;
            if (deviation < -180.0f) {
                this.lookYaw -= 360.0f;
                this.lastLookYaw -= 360.0f;
            } else if (deviation > 180.0f) {
                this.lookYaw += 360.0f;
                this.lastLookYaw += 360.0f;
            }
            this.lookYaw = (float)((double)this.lookYaw + (double)(targetYaw - this.lookYaw) * 0.2);
            float pitchAngle = (float)(Mth.atan2((double)relative.y, (double)dist) * 57.29577951308232);
            this.lookPitch = (float)((double)this.lookPitch + (double)(pitchAngle - this.lookPitch) * 0.2);
        } else {
            this.lookYaw = (float)((double)this.lookYaw + 1.15);
            if (this.lookYaw >= 360.0f) {
                this.lookYaw -= 360.0f;
                this.lastLookYaw -= 360.0f;
            }
            if (this.lookPitch % 360.0f > 0.0f) {
                this.lookPitch = (float)((double)this.lookPitch - 1.15);
            } else if (this.lookPitch % 360.0f < 0.0f) {
                this.lookPitch = (float)((double)this.lookPitch + 1.15);
            }
        }
        IntParticleData data = new IntParticleData((ParticleType)DEParticles.SPARK.get(), new Integer[]{0, 255, 255, (int)((double)0.4f * ((double)this.level.random.nextFloat() + 0.1) * 100.0), 15, 30, 10, -5});
        Vector3 pos = Vector3.fromTileCenter((BlockEntity)this).add((-0.5 + this.level.random.nextDouble()) * 0.1, 0.005, (-0.5 + this.level.random.nextDouble()) * 0.1);
        this.level.addParticle((ParticleOptions)data, pos.x, pos.y, pos.z, 0.02, 0.0, 0.02);
        int i = this.level.random.nextInt(4);
        double x = i / 2;
        double z = i % 2;
        boolean advanced = this.isAdvanced();
        data = new IntParticleData((ParticleType)DEParticles.SPARK.get(), new Integer[]{advanced ? 255 : 76, advanced ? 178 : 0, advanced ? 0 : 255, (int)((double)0.4f * ((double)this.level.random.nextFloat() + 0.1) * 100.0), 15, 30, 10, -5});
        pos = Vector3.fromTile((BlockEntity)this).add(0.14 + x * 0.72, 0.17, 0.14 + z * 0.72);
        this.level.addParticle((ParticleOptions)data, pos.x, pos.y, pos.z, 0.002, 0.0, 0.002);
    }

    public void doScanPulse() {
        List entities = this.entityFilter.filterEntities((Collection)this.level.getEntitiesOfClass(Entity.class, new AABB(this.worldPosition).inflate((double)this.range.get(), (double)this.range.get(), (double)this.range.get())));
        double min = this.rsMinDetection.get() - 1;
        double max = this.rsMaxDetection.get();
        int eCount = entities.size();
        int output = min == max ? ((double)eCount > min ? 15 : 0) : (max - min == 15.0 ? (int)Math.max(0.0, Math.min(15.0, (double)eCount - min)) : (int)Math.max(0.0, Math.min(15.0, MathUtils.map((double)eCount, (double)min, (double)max, (double)0.0, (double)15.0))));
        if (this.outputStrength.get() != output) {
            this.outputStrength.set((int)((byte)output));
            this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
        }
        if (this.pulseRsMode.get()) {
            this.pulseDuration = 2;
        }
        this.opStorage.modifyEnergyStored((long)(-this.getPulseCost()));
    }

    public void adjustPulseRate(boolean decrement, boolean shift) {
        this.sendPacketToServer(output -> output.writeBoolean(decrement), shift ? 1 : 0);
    }

    public void adjustRange(boolean decrement, boolean shift) {
        this.sendPacketToServer(output -> output.writeBoolean(decrement), shift ? 3 : 2);
    }

    public void adjustRSMin(boolean decrement, boolean shift) {
        this.sendPacketToServer(output -> output.writeBoolean(decrement), shift ? 5 : 4);
    }

    public void adjustRSMax(boolean decrement, boolean shift) {
        this.sendPacketToServer(output -> output.writeBoolean(decrement), shift ? 7 : 6);
    }

    public void togglePulsemode() {
        this.sendPacketToServer(output -> output.writeBoolean(false), 8);
    }

    public void receivePacketFromClient(MCDataInput data, ServerPlayer client, int id) {
        super.receivePacketFromClient(data, client, id);
        if (id <= 8) {
            boolean decrement = data.readBoolean();
            boolean shift = id % 2 == 1;
            switch (id) {
                case 0: 
                case 1: {
                    short min = this.isAdvanced() ? (short)5 : 30;
                    short max = 1200;
                    int change = shift ? 100 : 5;
                    this.pulseRate.add(decrement ? (short)(-change) : (short)change);
                    if (this.pulseRate.get() < min) {
                        this.pulseRate.set(min);
                    } else if (this.pulseRate.get() > max) {
                        this.pulseRate.set(max);
                    }
                    this.pulseTimer = this.pulseRate.get();
                    break;
                }
                case 2: 
                case 3: {
                    short min = 1;
                    short max = this.isAdvanced() ? (short)64 : 16;
                    int change = shift ? 5 : 1;
                    this.range.add(decrement ? (short)(-change) : (short)change);
                    if (this.range.get() < min) {
                        this.range.set(min);
                        break;
                    }
                    if (this.range.get() <= max) break;
                    this.range.set(max);
                    break;
                }
                case 4: 
                case 5: {
                    int change = shift ? 5 : 1;
                    int value = this.rsMinDetection.add((int)(decrement ? (byte)(-change) : (byte)change));
                    int max = this.rsMaxDetection.get();
                    if (value < 0) {
                        value = 0;
                    } else if (value > max) {
                        value = max;
                    }
                    this.rsMinDetection.set((int)((byte)value));
                    break;
                }
                case 6: 
                case 7: {
                    int change = shift ? 5 : 1;
                    int value = this.rsMaxDetection.get() + (decrement ? -change : change);
                    int min = this.rsMinDetection.get();
                    if (value < min) {
                        value = min;
                    } else if (value > 127) {
                        value = 127;
                    }
                    this.rsMaxDetection.set((int)((byte)value));
                    break;
                }
                case 8: {
                    this.pulseRsMode.set(!this.pulseRsMode.get());
                }
            }
        }
    }

    @Nullable
    public AbstractContainerMenu createMenu(int currentWindowIndex, Inventory playerInventory, Player player) {
        return new EntityDetectorMenu(currentWindowIndex, playerInventory, this);
    }

    public InteractionResult useWithoutItem(BlockState state, Player player, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            player.openMenu((MenuProvider)this, this.worldPosition);
            MinecraftServer server = player.getServer();
            if (server != null) {
                ListTag list = new ListTag();
                for (String name : server.getPlayerList().getPlayerNamesArray()) {
                    list.add((Object)StringTag.valueOf((String)name));
                }
                CompoundTag compound = new CompoundTag();
                compound.put("List", (Tag)list);
                this.sendPacketToClient((ServerPlayer)player, output -> output.writeCompoundNBT(compound), 16);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public int getWeakPower(BlockState blockState, Direction side) {
        return this.outputStrength.get();
    }

    public int getStrongPower(BlockState blockState, Direction side) {
        return this.outputStrength.get();
    }

    public void receivePacketFromServer(MCDataInput data, int id) {
        super.receivePacketFromServer(data, id);
        if (id == 16) {
            ListTag list = data.readCompoundNBT().getList("List", 8);
            this.playerNames.clear();
            for (int i = 0; i < list.size(); ++i) {
                this.playerNames.add(list.getString(i));
            }
        }
    }

    public int getPulseCost() {
        return (int)(125.0 * Math.pow(this.range.get(), 1.5));
    }

    public boolean isAdvanced() {
        return this.getBlockState().is((Block)DEContent.ENTITY_DETECTOR_ADVANCED.get());
    }
}

