/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity.chest;

import codechicken.lib.inventory.InventoryUtils;
import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.api.power.OPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedFloat;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Locale;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class SmeltingLogic {
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();
    public final ManagedEnum<FeedMode> feedMode;
    public final ManagedFloat smeltProgress;
    public final ManagedFloat smeltingPower;
    private final TileBCore tile;
    private final IItemHandler inputInv;
    private final IItemHandler outputInv;
    private final InventorySlotMapper[] wrappedSlots;
    private IItemHandlerModifiable feedSourceInv;
    private OPStorage opStorage;
    private int feedSchedule = 0;
    private boolean outputBlocked = false;
    private boolean inputInvalid = false;
    private int energyPerSmeltTick = 32;

    public SmeltingLogic(TileBCore tile, IItemHandlerModifiable inputInv, IItemHandler outputInv, OPStorage opStorage) {
        this.tile = tile;
        this.inputInv = inputInv;
        this.outputInv = outputInv;
        this.opStorage = opStorage;
        this.wrappedSlots = new InventorySlotMapper[inputInv.getSlots()];
        for (int i = 0; i < inputInv.getSlots(); ++i) {
            this.wrappedSlots[i] = new InventorySlotMapper(inputInv, i);
        }
        this.feedMode = (ManagedEnum)tile.register((IManagedData)new ManagedEnum("feed_mode", (Enum)FeedMode.OFF, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_CONTAINER, DataFlags.CLIENT_CONTROL}));
        this.smeltProgress = (ManagedFloat)tile.register((IManagedData)new ManagedFloat("smelt_progress", 0.0f, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER}));
        this.smeltingPower = (ManagedFloat)tile.register((IManagedData)new ManagedFloat("smelt_speed", 0.0f, new DataFlags[]{DataFlags.SAVE_NBT_SYNC_CONTAINER}));
        this.feedMode.addValueListener(e -> this.inputInventoryChanged().attemptAutoFeed());
    }

    public void setFeedSourceInv(IItemHandlerModifiable feedSourceInv) {
        this.feedSourceInv = feedSourceInv;
    }

    public void tick(boolean enableSmelting) {
        boolean blockedAt100;
        long opStored = this.opStorage.getOPStored();
        long opMax = this.opStorage.getMaxOPStored();
        if ((enableSmelting &= opStored > 0L) && this.feedSchedule > 0 && --this.feedSchedule == 0) {
            this.attemptAutoFeed();
        }
        float availablePower = (float)opStored < (float)opMax / 4.0f ? (float)opStored / ((float)opMax / 4.0f) : 1.0f;
        boolean isSmelting = enableSmelting && !this.inputInvalid && !this.outputBlocked;
        this.smeltingPower.set(MathHelper.approachLinear((float)this.smeltingPower.get(), (float)(isSmelting ? availablePower : 0.0f), (float)0.1f));
        float maxEfficiency = 4.0f;
        float speedModifier = this.smeltingPower.get() * maxEfficiency;
        boolean bl = blockedAt100 = this.outputBlocked && this.smeltProgress.get() >= 1.0f;
        if (enableSmelting && !blockedAt100 && !this.inputInvalid) {
            this.updateSmelting(speedModifier);
        } else if (!(!(this.smeltProgress.get() > 0.0f) || this.outputBlocked && enableSmelting)) {
            this.smeltProgress.set(Math.max(0.0f, this.smeltProgress.get() - 0.01f));
        }
    }

    private void updateSmelting(float speedModifier) {
        Level world = this.tile.getLevel();
        int validRecipes = 0;
        int completedSmelts = 0;
        int slowestRecipe = 0;
        boolean attemptSmelt = this.smeltProgress.get() >= 1.0f;
        for (int i = 0; i < this.wrappedSlots.length; ++i) {
            ItemStack result;
            InventorySlotMapper slot = this.wrappedSlots[i];
            ItemStack stack = slot.getItem(0);
            if (stack.isEmpty() || stack.getCount() == 1 && this.feedMode.get() == FeedMode.STiCKY) continue;
            SingleRecipeInput input = new SingleRecipeInput(stack);
            RecipeHolder holder = world.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)input, world).orElse(null);
            if (holder == null) continue;
            SmeltingRecipe recipe = (SmeltingRecipe)holder.value();
            ++validRecipes;
            slowestRecipe = Math.max(slowestRecipe, recipe.getCookingTime());
            if (!attemptSmelt || !InventoryUtils.insertItem((IItemHandler)this.outputInv, (ItemStack)(result = recipe.assemble(input, (HolderLookup.Provider)this.tile.getLevel().registryAccess())), (boolean)true).isEmpty() || this.inputInv.extractItem(i, 1, false).isEmpty()) continue;
            InventoryUtils.insertItem((IItemHandler)this.outputInv, (ItemStack)result, (boolean)false);
            this.recipesUsed.addTo((Object)holder.id(), 1);
            ++completedSmelts;
        }
        if (validRecipes == 0) {
            this.inputInvalid = true;
            return;
        }
        float smeltingSpeed = 1.0f / (float)slowestRecipe * speedModifier;
        int energy = Math.max(1, (int)((float)this.energyPerSmeltTick * (speedModifier < 1.0f ? speedModifier : speedModifier * speedModifier))) * validRecipes;
        if (attemptSmelt) {
            this.opStorage.modifyEnergyStored((long)(-energy));
            if (completedSmelts > 0) {
                this.smeltProgress.set(0.0f);
                this.attemptAutoFeed();
            } else {
                this.outputBlocked = true;
            }
        } else {
            long extracted = this.opStorage.modifyEnergyStored((long)(-energy));
            if ((long)energy > extracted) {
                smeltingSpeed *= (float)extracted / (float)energy;
            }
            this.smeltProgress.set(Math.min(1.0f, this.smeltProgress.get() + smeltingSpeed));
        }
    }

    private void attemptAutoFeed() {
        if (this.feedSourceInv == null || this.feedMode.get() == FeedMode.OFF || this.isInputFull()) {
            return;
        }
        this.feedSchedule = 0;
        for (int i = 0; i < this.feedSourceInv.getSlots(); ++i) {
            ItemStack stack = this.feedSourceInv.getStackInSlot(i);
            if (stack.isEmpty() || !this.isSmeltable(stack)) continue;
            ItemStack remainder = this.insertItem(this.inputInv, stack);
            this.feedSourceInv.setStackInSlot(i, remainder);
            if (!remainder.isEmpty() && remainder.getCount() >= stack.getCount() || !this.isInputFull()) continue;
            this.inputInvalid = false;
            this.outputBlocked = false;
            return;
        }
    }

    public ItemStack insertItem(IItemHandler handler, ItemStack insert) {
        insert = insert.copy();
        for (int pass = 0; pass < 2; ++pass) {
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                if ((pass == 0 || this.feedMode.get() != FeedMode.ALL) && stack.isEmpty() || !(insert = handler.insertItem(slot, insert, false)).isEmpty()) continue;
                return ItemStack.EMPTY;
            }
        }
        return insert;
    }

    private boolean isInputFull() {
        int fullSlots = 0;
        for (int i = 0; i < this.inputInv.getSlots(); ++i) {
            ItemStack stack = this.inputInv.getStackInSlot(i);
            if (stack.getCount() < stack.getMaxStackSize() && (!stack.isEmpty() || this.feedMode.get() == FeedMode.ALL)) continue;
            ++fullSlots;
        }
        return fullSlots == this.inputInv.getSlots();
    }

    private boolean isInputEmpty() {
        for (int i = 0; i < this.inputInv.getSlots(); ++i) {
            if (this.inputInv.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public SmeltingLogic scheduleAutoFeed() {
        if (this.feedSchedule == 0 && this.feedMode.get() != FeedMode.OFF) {
            this.feedSchedule = 10;
        }
        return this;
    }

    public SmeltingLogic inputInventoryChanged() {
        this.inputInvalid = this.inputInvalid && this.isInputEmpty();
        this.outputBlocked = false;
        if (!this.isInputEmpty()) {
            this.scheduleAutoFeed();
        }
        return this;
    }

    public SmeltingLogic outputInventoryChanged() {
        this.outputBlocked = false;
        return this;
    }

    public void saveAdditionalNBT(CompoundTag nbt) {
        CompoundTag compound = new CompoundTag();
        this.recipesUsed.forEach((recipe, count) -> compound.putInt(recipe.toString(), count.intValue()));
        nbt.put("recipes_used", (Tag)compound);
    }

    public void loadAdditionalNBT(CompoundTag nbt) {
        CompoundTag compound = nbt.getCompound("recipes_used");
        for (String s : compound.getAllKeys()) {
            this.recipesUsed.put((Object)ResourceLocation.parse((String)s), compound.getInt(s));
        }
    }

    public boolean isSmeltable(ItemStack stack) {
        return this.tile.getLevel().getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(stack), this.tile.getLevel()).isPresent();
    }

    private static class InventorySlotMapper
    implements RecipeInput {
        private final IItemHandlerModifiable itemHandler;
        private final int slot;

        public InventorySlotMapper(IItemHandlerModifiable itemHandler, int slot) {
            this.itemHandler = itemHandler;
            this.slot = slot;
        }

        public int size() {
            return 1;
        }

        public boolean isEmpty() {
            return this.itemHandler.getStackInSlot(this.slot).isEmpty();
        }

        public ItemStack getItem(int index) {
            return index == 0 ? this.itemHandler.getStackInSlot(this.slot) : ItemStack.EMPTY;
        }
    }

    public static enum FeedMode {
        OFF("chest/feed_off"),
        ALL("chest/feed_all"),
        FILTER("chest/feed_filter"),
        STiCKY("chest/feed_filter_sticky");

        private String sprite;

        private FeedMode(String sprite) {
            this.sprite = sprite;
        }

        public String getSprite() {
            return this.sprite;
        }

        public String localKey() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

