/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.init;

import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.draconicevolution.api.DataComponentAccessor;
import com.brandon3055.draconicevolution.api.capability.DECapabilities;
import com.brandon3055.draconicevolution.api.capability.ModuleProvider;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalDirectIO;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalRelay;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalWirelessIO;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorInjector;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorStabilizer;
import com.brandon3055.draconicevolution.blocks.tileentity.TileCelestialManipulator;
import com.brandon3055.draconicevolution.blocks.tileentity.TileCreativeOPCapacitor;
import com.brandon3055.draconicevolution.blocks.tileentity.TileDisenchanter;
import com.brandon3055.draconicevolution.blocks.tileentity.TileDislocatorPedestal;
import com.brandon3055.draconicevolution.blocks.tileentity.TileDislocatorReceptacle;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyPylon;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyTransfuser;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEntityDetector;
import com.brandon3055.draconicevolution.blocks.tileentity.TileFusionCraftingCore;
import com.brandon3055.draconicevolution.blocks.tileentity.TileFusionCraftingInjector;
import com.brandon3055.draconicevolution.blocks.tileentity.TileGenerator;
import com.brandon3055.draconicevolution.blocks.tileentity.TileGrinder;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePlacedItem;
import com.brandon3055.draconicevolution.blocks.tileentity.chest.TileDraconiumChest;
import com.brandon3055.draconicevolution.blocks.tileentity.flowgate.TileFluidGate;
import com.brandon3055.draconicevolution.blocks.tileentity.flowgate.TileFluxGate;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.DEModules;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.integration.equipment.IDEEquipment;
import com.brandon3055.draconicevolution.items.equipment.IModularEnergyItem;
import com.brandon3055.draconicevolution.items.equipment.IModularItem;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;

public class CapabilityData {
    private static final CrashLock LOCK = new CrashLock("Already Initialized");

    private static ModuleHostImpl getItemHostCap(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof IModularItem)) {
            throw new IllegalStateException("ITEM_HOST_DATA can only be used on an ItemStack who's item implements IModularItem!");
        }
        IModularItem item2 = (IModularItem)item;
        ModuleHostImpl host = item2.createHostCapForRegistration(stack);
        assert (host != null);
        host.updateDataAccess(DataComponentAccessor.itemStack(stack));
        return host;
    }

    private static ModularOPStorage getEnergyCap(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof IModularEnergyItem)) {
            throw new IllegalStateException("ITEM_HOST_DATA can only be used on an ItemStack who's item implements IModularEnergyItem!");
        }
        IModularEnergyItem item2 = (IModularEnergyItem)item;
        ModularOPStorage storage = item2.createOPCapForRegistration(stack);
        assert (storage != null);
        storage.updateDataAccess(DataComponentAccessor.itemStack(stack));
        return storage;
    }

    public static void init(IEventBus modBus) {
        LOCK.lock();
        modBus.addListener(CapabilityData::register);
    }

    public static void register(RegisterCapabilitiesEvent event) {
        DEContent.ITEMS.getEntries().forEach(holder -> {
            Item item = (Item)holder.get();
            if (item instanceof IModularItem) {
                IModularItem modularItem = (IModularItem)item;
                event.registerItem(DECapabilities.Host.ITEM, (stack, v) -> CapabilityData.getItemHostCap(stack), new ItemLike[]{item});
                if (item instanceof IModularEnergyItem) {
                    IModularEnergyItem modularEnergyItem = (IModularEnergyItem)item;
                    event.registerItem(CapabilityOP.ITEM, (stack, v) -> CapabilityData.getEnergyCap(stack), new ItemLike[]{item});
                    event.registerItem(Capabilities.EnergyStorage.ITEM, (stack, v) -> CapabilityData.getEnergyCap(stack), new ItemLike[]{item});
                }
            }
            if (item instanceof IDEEquipment) {
                EquipmentManager.registerCapability(event, item);
            }
            if (item instanceof ModuleProvider) {
                ModuleProvider provider = (ModuleProvider)item;
                event.registerItem(DECapabilities.Module.ITEM, (stack, context) -> provider, new ItemLike[]{item});
            }
        });
        DEModules.ITEMS.getEntries().forEach(holder -> {
            Item item = (Item)holder.get();
            if (item instanceof ModuleProvider) {
                ModuleProvider provider = (ModuleProvider)item;
                event.registerItem(DECapabilities.Module.ITEM, (stack, context) -> provider, new ItemLike[]{item});
            }
        });
        TileGenerator.register(event);
        TileGrinder.register(event);
        TileDisenchanter.register(event);
        TileEnergyTransfuser.register(event);
        TileDislocatorPedestal.register(event);
        TileDislocatorReceptacle.register(event);
        TileCreativeOPCapacitor.register(event);
        TileEntityDetector.register(event);
        TileCelestialManipulator.register(event);
        TileDraconiumChest.register(event);
        TilePlacedItem.register(event);
        TileFusionCraftingInjector.register(event);
        TileFusionCraftingCore.register(event);
        TileEnergyCore.register(event);
        TileEnergyPylon.register(event);
        TileReactorStabilizer.register(event);
        TileReactorInjector.register(event);
        TileFluxGate.register(event);
        TileFluidGate.register(event);
        TileCrystalDirectIO.register(event);
        TileCrystalRelay.register(event);
        TileCrystalWirelessIO.register(event);
    }
}

