/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.init;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.AOEData;
import com.brandon3055.draconicevolution.api.modules.data.AutoFeedData;
import com.brandon3055.draconicevolution.api.modules.data.DamageData;
import com.brandon3055.draconicevolution.api.modules.data.DamageModData;
import com.brandon3055.draconicevolution.api.modules.data.EnergyData;
import com.brandon3055.draconicevolution.api.modules.data.EnergyLinkData;
import com.brandon3055.draconicevolution.api.modules.data.FlightData;
import com.brandon3055.draconicevolution.api.modules.data.JumpData;
import com.brandon3055.draconicevolution.api.modules.data.NoData;
import com.brandon3055.draconicevolution.api.modules.data.ProjectileData;
import com.brandon3055.draconicevolution.api.modules.data.ShieldControlData;
import com.brandon3055.draconicevolution.api.modules.data.ShieldData;
import com.brandon3055.draconicevolution.api.modules.data.SpeedData;
import com.brandon3055.draconicevolution.api.modules.data.TreeHarvestData;
import com.brandon3055.draconicevolution.api.modules.data.UndyingData;
import com.brandon3055.draconicevolution.api.modules.items.EnderCollectionModuleItem;
import com.brandon3055.draconicevolution.api.modules.items.EnergyLinkModuleItem;
import com.brandon3055.draconicevolution.api.modules.items.EnergyModuleItem;
import com.brandon3055.draconicevolution.api.modules.items.ModuleItem;
import com.brandon3055.draconicevolution.api.modules.lib.BaseModule;
import com.brandon3055.draconicevolution.api.modules.lib.IDamageModifier;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleImpl;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import com.brandon3055.draconicevolution.modules.ProjectileVelocityModule;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegistryBuilder;

public class DEModules {
    public static final ResourceKey<Registry<Module<?>>> MODULE_KEY = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"modules"));
    public static Registry<Module<?>> REGISTRY;
    public static final DeferredRegister<Module<?>> MODULES;
    public static final DeferredRegister<Item> ITEMS;
    public static final Set<String> MODULE_PROVIDING_MODS;
    private static final StreamCodec<RegistryFriendlyByteBuf, Holder<Module<?>>> HOLDER_STREAM_CODEC;
    private static final StreamCodec<RegistryFriendlyByteBuf, Module<?>> STREAM_CODEC;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIUM_ENERGY;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_ENERGY;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIC_ENERGY;
    public static final DeferredHolder<Module<?>, Module<?>> CHAOTIC_ENERGY;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIUM_ENERGY;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_ENERGY;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIC_ENERGY;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_CHAOTIC_ENERGY;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_ENERGY_LINK;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIC_ENERGY_LINK;
    public static final DeferredHolder<Module<?>, Module<?>> CHAOTIC_ENERGY_LINK;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_ENERGY_LINK;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIC_ENERGY_LINK;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_CHAOTIC_ENERGY_LINK;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIUM_SPEED;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_SPEED;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIC_SPEED;
    public static final DeferredHolder<Module<?>, Module<?>> CHAOTIC_SPEED;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIUM_SPEED;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_SPEED;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIC_SPEED;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_CHAOTIC_SPEED;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIUM_DAMAGE;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_DAMAGE;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIC_DAMAGE;
    public static final DeferredHolder<Module<?>, Module<?>> CHAOTIC_DAMAGE;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIUM_DAMAGE;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_DAMAGE;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIC_DAMAGE;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_CHAOTIC_DAMAGE;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIUM_AOE;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_AOE;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIC_AOE;
    public static final DeferredHolder<Module<?>, Module<?>> CHAOTIC_AOE;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIUM_AOE;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_AOE;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIC_AOE;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_CHAOTIC_AOE;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_MINING_STABILITY;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_MINING_STABILITY;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_TREE_HARVEST;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIC_TREE_HARVEST;
    public static final DeferredHolder<Module<?>, Module<?>> CHAOTIC_TREE_HARVEST;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_TREE_HARVEST;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIC_TREE_HARVEST;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_CHAOTIC_TREE_HARVEST;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_JUNK_FILTER;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_JUNK_FILTER;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_ENDER_COLLECTION;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIC_ENDER_COLLECTION;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_ENDER_COLLECTION;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIC_ENDER_COLLECTION;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_PROJ_VELOCITY;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIC_PROJ_VELOCITY;
    public static final DeferredHolder<Module<?>, Module<?>> CHAOTIC_PROJ_VELOCITY;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_PROJ_VELOCITY;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIC_PROJ_VELOCITY;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_CHAOTIC_PROJ_VELOCITY;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_PROJ_ACCURACY;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIC_PROJ_ACCURACY;
    public static final DeferredHolder<Module<?>, Module<?>> CHAOTIC_PROJ_ACCURACY;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_PROJ_ACCURACY;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIC_PROJ_ACCURACY;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_CHAOTIC_PROJ_ACCURACY;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_PROJ_GRAV_COMP;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIC_PROJ_GRAV_COMP;
    public static final DeferredHolder<Module<?>, Module<?>> CHAOTIC_PROJ_GRAV_COMP;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_PROJ_GRAV_COMP;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIC_PROJ_GRAV_COMP;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_CHAOTIC_PROJ_GRAV_COMP;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_PROJ_PENETRATION;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIC_PROJ_PENETRATION;
    public static final DeferredHolder<Module<?>, Module<?>> CHAOTIC_PROJ_PENETRATION;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_PROJ_PENETRATION;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIC_PROJ_PENETRATION;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_CHAOTIC_PROJ_PENETRATION;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_PROJ_DAMAGE;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIC_PROJ_DAMAGE;
    public static final DeferredHolder<Module<?>, Module<?>> CHAOTIC_PROJ_DAMAGE;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_PROJ_DAMAGE;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIC_PROJ_DAMAGE;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_CHAOTIC_PROJ_DAMAGE;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_AUTO_FIRE;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_AUTO_FIRE;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIC_PROJ_ANTI_IMMUNE;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIC_PROJ_ANTI_IMMUNE;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_SHIELD_CONTROL;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIC_SHIELD_CONTROL;
    public static final DeferredHolder<Module<?>, Module<?>> CHAOTIC_SHIELD_CONTROL;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_SHIELD_CONTROL;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIC_SHIELD_CONTROL;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_CHAOTIC_SHIELD_CONTROL;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_SHIELD_CAPACITY;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIC_SHIELD_CAPACITY;
    public static final DeferredHolder<Module<?>, Module<?>> CHAOTIC_SHIELD_CAPACITY;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_LARGE_SHIELD_CAPACITY;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIC_LARGE_SHIELD_CAPACITY;
    public static final DeferredHolder<Module<?>, Module<?>> CHAOTIC_LARGE_SHIELD_CAPACITY;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_SHIELD_RECOVERY;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIC_SHIELD_RECOVERY;
    public static final DeferredHolder<Module<?>, Module<?>> CHAOTIC_SHIELD_RECOVERY;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_SHIELD_CAPACITY;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIC_SHIELD_CAPACITY;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_CHAOTIC_SHIELD_CAPACITY;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_LARGE_SHIELD_CAPACITY;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIC_LARGE_SHIELD_CAPACITY;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_CHAOTIC_LARGE_SHIELD_CAPACITY;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_SHIELD_RECOVERY;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIC_SHIELD_RECOVERY;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_CHAOTIC_SHIELD_RECOVERY;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_FLIGHT;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIC_FLIGHT;
    public static final DeferredHolder<Module<?>, Module<?>> CHAOTIC_FLIGHT;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_FLIGHT;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIC_FLIGHT;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_CHAOTIC_FLIGHT;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_UNDYING;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIC_UNDYING;
    public static final DeferredHolder<Module<?>, Module<?>> CHAOTIC_UNDYING;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_UNDYING;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIC_UNDYING;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_CHAOTIC_UNDYING;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIUM_AUTO_FEED;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_AUTO_FEED;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIC_AUTO_FEED;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIUM_AUTO_FEED;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_AUTO_FEED;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIC_AUTO_FEED;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_NIGHT_VISION;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_NIGHT_VISION;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_HILL_STEP;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_HILL_STEP;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIUM_JUMP;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_JUMP;
    public static final DeferredHolder<Module<?>, Module<?>> DRACONIC_JUMP;
    public static final DeferredHolder<Module<?>, Module<?>> CHAOTIC_JUMP;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIUM_JUMP;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_JUMP;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_DRACONIC_JUMP;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_CHAOTIC_JUMP;
    public static final DeferredHolder<Module<?>, Module<?>> WYVERN_AQUA_ADEPT;
    public static final DeferredHolder<Item, ModuleItem<?>> ITEM_WYVERN_AQUA_ADAPT;

    public static void init(IEventBus eventBus) {
        eventBus.addListener(DEModules::createRegistries);
        MODULES.register(eventBus);
        ITEMS.register(eventBus);
        eventBus.addListener(DEModules::registerEvent);
    }

    public static void createRegistries(NewRegistryEvent event) {
        REGISTRY = event.create(new RegistryBuilder(MODULE_KEY).sync(true));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, Holder<Module<?>>> holderStreamCodec() {
        return HOLDER_STREAM_CODEC;
    }

    public static StreamCodec<RegistryFriendlyByteBuf, Module<?>> streamCodec() {
        return STREAM_CODEC;
    }

    public static Codec<Module<?>> codec() {
        return REGISTRY.byNameCodec();
    }

    public static Codec<Holder<Module<?>>> holderCodec() {
        return REGISTRY.holderByNameCodec();
    }

    public static void registerEvent(FMLCommonSetupEvent event) {
        REGISTRY.forEach(module -> ((BaseModule)module).reloadData());
    }

    private static Function<Module<EnergyData>, EnergyData> energyData(long defCapacity, long defTransfer) {
        return e -> {
            long capacity = ModuleCfg.getModuleLong(e, "capacity", defCapacity);
            long transfer = ModuleCfg.getModuleLong(e, "transfer", defTransfer);
            return new EnergyData(capacity, transfer);
        };
    }

    private static Function<Module<EnergyLinkData>, EnergyLinkData> energyLinkData(long defActivation, long defOperation, long defTransfer, boolean defDimensional) {
        return e -> {
            long activation = ModuleCfg.getModuleLong(e, "activation", defActivation);
            long operation = ModuleCfg.getModuleLong(e, "operation", defOperation);
            long transfer = ModuleCfg.getModuleLong(e, "transfer", defTransfer);
            boolean dimensional = ModuleCfg.getModuleBoolean(e, "dimensional", defDimensional);
            return new EnergyLinkData(activation, operation, transfer, dimensional);
        };
    }

    private static Function<Module<ShieldData>, ShieldData> shieldData(int defCapacity, double defRechargePerSecond) {
        return e -> {
            int capacity = ModuleCfg.getModuleInt(e, "capacity", defCapacity);
            double recharge = ModuleCfg.getModuleDouble(e, "recharge", defRechargePerSecond / 20.0);
            return new ShieldData(capacity, recharge);
        };
    }

    private static Function<Module<ShieldControlData>, ShieldControlData> shieldControl(double defSeconds) {
        return e -> {
            int ticks = ModuleCfg.getModuleInt(e, "cool_down_ticks", (int)(defSeconds * 20.0));
            return new ShieldControlData(ticks);
        };
    }

    private static Function<Module<SpeedData>, SpeedData> speedData(double defMultiplier) {
        return e -> new SpeedData(ModuleCfg.getModuleDouble(e, "speed_boost", defMultiplier));
    }

    private static Function<Module<DamageData>, DamageData> damageData(double defDamage) {
        return e -> new DamageData(ModuleCfg.getModuleDouble(e, "damage_boost", defDamage));
    }

    private static Function<Module<AOEData>, AOEData> aoeData(int defAOE) {
        return e -> new AOEData(ModuleCfg.getModuleInt(e, "aoe", defAOE));
    }

    private static Function<Module<JumpData>, JumpData> jumpData(double defMultiplier) {
        return e -> new JumpData(ModuleCfg.getModuleDouble(e, "jump_boost", defMultiplier));
    }

    private static Function<Module<FlightData>, FlightData> flightData(boolean elytra, boolean creative, double defSpeed) {
        return e -> {
            double speed = ModuleCfg.getModuleDouble(e, "elytra_boost_speed", defSpeed);
            return new FlightData(elytra, creative, speed);
        };
    }

    private static Function<Module<UndyingData>, UndyingData> undyingData(float defHealthBoost, float defShieldBoost, int shieldBoostTime, int defChargeTime, long defChargeEnergy, double defInvulnSeconds) {
        return e -> {
            float health = (float)ModuleCfg.getModuleDouble(e, "health_boost", defHealthBoost);
            float shield = (float)ModuleCfg.getModuleDouble(e, "shield_boost", defShieldBoost);
            int shieldTime = ModuleCfg.getModuleInt(e, "shield_boost_time", shieldBoostTime);
            int charge = ModuleCfg.getModuleInt(e, "charge_ticks", defChargeTime);
            long energy = ModuleCfg.getModuleLong(e, "charge_energy", defChargeEnergy);
            double invuln = ModuleCfg.getModuleDouble(e, "invulnerable_time", defInvulnSeconds);
            return new UndyingData(health, shield, shieldTime, charge, energy, (int)(invuln * 20.0));
        };
    }

    private static Function<Module<AutoFeedData>, AutoFeedData> autoFeedData(float defFoodStorage) {
        return e -> {
            float foodStorage = (float)ModuleCfg.getModuleDouble(e, "food_storage", defFoodStorage);
            return new AutoFeedData(foodStorage);
        };
    }

    private static Function<Module<DamageModData>, DamageModData> dmgModData(IDamageModifier modifier) {
        return e -> new DamageModData(modifier);
    }

    private static Function<Module<ProjectileData>, ProjectileData> projectileData(float defVelocityModifier, float defAccuracyModifier, float defAntiGravModifier, float defPenetrationModifier, float defDamageModifier) {
        return e -> {
            float velocityModifier = (float)ModuleCfg.getModuleDouble(e, "velocity_modifier", defVelocityModifier);
            float accuracyModifier = (float)ModuleCfg.getModuleDouble(e, "accuracy_modifier", defAccuracyModifier);
            float antiGravModifier = (float)ModuleCfg.getModuleDouble(e, "anti_grav_modifier", defAntiGravModifier);
            float penetrationModifier = (float)ModuleCfg.getModuleDouble(e, "penetration_modifier", defPenetrationModifier);
            float damageModifier = (float)ModuleCfg.getModuleDouble(e, "damage_modifier", defDamageModifier);
            return new ProjectileData(velocityModifier, accuracyModifier, antiGravModifier, penetrationModifier, damageModifier);
        };
    }

    private static Function<Module<ProjectileData>, ProjectileData> projVelocityData(float velocityModifier, float penaltyModifier) {
        float accuracyPenalty = velocityModifier * -0.125f * penaltyModifier;
        float penetrationBoost = velocityModifier * 0.25f * (1.0f - penaltyModifier);
        return DEModules.projectileData(velocityModifier, accuracyPenalty, 0.0f, penetrationBoost, 0.0f);
    }

    private static Function<Module<ProjectileData>, ProjectileData> projAccuracyData(float accuracyModifier, float penaltyModifier) {
        float velocityPenalty = accuracyModifier * -0.25f * penaltyModifier;
        float penetrationPenalty = velocityPenalty * 0.25f;
        return DEModules.projectileData(velocityPenalty, accuracyModifier, 0.0f, penetrationPenalty, 0.0f);
    }

    private static Function<Module<ProjectileData>, ProjectileData> projAntiGravData(float antiGravModifier, float penaltyModifier) {
        float velocityPenalty = antiGravModifier * -0.0625f * penaltyModifier;
        float accuracyPenalty = antiGravModifier * -0.125f * penaltyModifier;
        float damagePenalty = antiGravModifier * -0.15f * penaltyModifier;
        float penetrationPenalty = velocityPenalty * 0.25f;
        return DEModules.projectileData(velocityPenalty, accuracyPenalty, antiGravModifier, penetrationPenalty, damagePenalty);
    }

    private static Function<Module<ProjectileData>, ProjectileData> projPenetrationData(float penetrationModifier, float penaltyModifier) {
        float accuracyPenalty = penetrationModifier * -0.25f * penaltyModifier;
        return DEModules.projectileData(0.0f, accuracyPenalty, 0.0f, penetrationModifier, 0.0f);
    }

    private static Function<Module<ProjectileData>, ProjectileData> projDamageData(float damageModifier, float penaltyModifier) {
        float accuracyPenalty = damageModifier * -0.125f * penaltyModifier;
        return DEModules.projectileData(0.0f, accuracyPenalty, 0.0f, 0.0f, damageModifier);
    }

    private static Function<Module<TreeHarvestData>, TreeHarvestData> treeHarvestData(int defRange, int defSpeed) {
        return e -> new TreeHarvestData(ModuleCfg.getModuleInt(e, "range", defRange), ModuleCfg.getModuleInt(e, "speed", defSpeed));
    }

    private static Function<Module<NoData>, NoData> noData() {
        return e -> new NoData();
    }

    static {
        MODULES = DeferredRegister.create(MODULE_KEY, (String)"draconicevolution");
        ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"draconicevolution");
        MODULE_PROVIDING_MODS = new HashSet<String>();
        HOLDER_STREAM_CODEC = ByteBufCodecs.holderRegistry((ResourceKey)MODULES.getRegistryKey());
        STREAM_CODEC = ByteBufCodecs.registry((ResourceKey)MODULES.getRegistryKey());
        DRACONIUM_ENERGY = MODULES.register("draconium_energy", () -> new ModuleImpl<EnergyData>(ModuleTypes.ENERGY_STORAGE, TechLevel.DRACONIUM, DEModules.energyData(1000000L, 16000L)));
        WYVERN_ENERGY = MODULES.register("wyvern_energy", () -> new ModuleImpl<EnergyData>(ModuleTypes.ENERGY_STORAGE, TechLevel.WYVERN, DEModules.energyData(4000000L, 64000L)));
        DRACONIC_ENERGY = MODULES.register("draconic_energy", () -> new ModuleImpl<EnergyData>(ModuleTypes.ENERGY_STORAGE, TechLevel.DRACONIC, DEModules.energyData(16000000L, 256000L)));
        CHAOTIC_ENERGY = MODULES.register("chaotic_energy", () -> new ModuleImpl<EnergyData>(ModuleTypes.ENERGY_STORAGE, TechLevel.CHAOTIC, DEModules.energyData(64000000L, 1024000L)));
        ITEM_DRACONIUM_ENERGY = ITEMS.register("item_draconium_energy", () -> new EnergyModuleItem((Supplier<Module<?>>)DRACONIUM_ENERGY));
        ITEM_WYVERN_ENERGY = ITEMS.register("item_wyvern_energy", () -> new EnergyModuleItem((Supplier<Module<?>>)WYVERN_ENERGY));
        ITEM_DRACONIC_ENERGY = ITEMS.register("item_draconic_energy", () -> new EnergyModuleItem((Supplier<Module<?>>)DRACONIC_ENERGY));
        ITEM_CHAOTIC_ENERGY = ITEMS.register("item_chaotic_energy", () -> new EnergyModuleItem((Supplier<Module<?>>)CHAOTIC_ENERGY));
        WYVERN_ENERGY_LINK = MODULES.register("wyvern_energy_link", () -> new ModuleImpl<EnergyLinkData>(ModuleTypes.ENERGY_LINK, TechLevel.WYVERN, DEModules.energyLinkData(4000000L, 512L, 2048L, false)));
        DRACONIC_ENERGY_LINK = MODULES.register("draconic_energy_link", () -> new ModuleImpl<EnergyLinkData>(ModuleTypes.ENERGY_LINK, TechLevel.DRACONIC, DEModules.energyLinkData(16000000L, 2048L, 16000L, true)));
        CHAOTIC_ENERGY_LINK = MODULES.register("chaotic_energy_link", () -> new ModuleImpl<EnergyLinkData>(ModuleTypes.ENERGY_LINK, TechLevel.CHAOTIC, DEModules.energyLinkData(64000000L, 8192L, 128000L, true)));
        ITEM_WYVERN_ENERGY_LINK = ITEMS.register("item_wyvern_energy_link", () -> new EnergyLinkModuleItem((Supplier<Module<?>>)WYVERN_ENERGY_LINK));
        ITEM_DRACONIC_ENERGY_LINK = ITEMS.register("item_draconic_energy_link", () -> new EnergyLinkModuleItem((Supplier<Module<?>>)DRACONIC_ENERGY_LINK));
        ITEM_CHAOTIC_ENERGY_LINK = ITEMS.register("item_chaotic_energy_link", () -> new EnergyLinkModuleItem((Supplier<Module<?>>)CHAOTIC_ENERGY_LINK));
        DRACONIUM_SPEED = MODULES.register("draconium_speed", () -> new ModuleImpl<SpeedData>(ModuleTypes.SPEED, TechLevel.DRACONIUM, DEModules.speedData(0.1)));
        WYVERN_SPEED = MODULES.register("wyvern_speed", () -> new ModuleImpl<SpeedData>(ModuleTypes.SPEED, TechLevel.WYVERN, DEModules.speedData(0.25)));
        DRACONIC_SPEED = MODULES.register("draconic_speed", () -> new ModuleImpl<SpeedData>(ModuleTypes.SPEED, TechLevel.DRACONIC, DEModules.speedData(0.5)));
        CHAOTIC_SPEED = MODULES.register("chaotic_speed", () -> new ModuleImpl<SpeedData>(ModuleTypes.SPEED, TechLevel.CHAOTIC, DEModules.speedData(1.5)));
        ITEM_DRACONIUM_SPEED = ITEMS.register("item_draconium_speed", () -> new ModuleItem((Supplier<Module<?>>)DRACONIUM_SPEED));
        ITEM_WYVERN_SPEED = ITEMS.register("item_wyvern_speed", () -> new ModuleItem((Supplier<Module<?>>)WYVERN_SPEED));
        ITEM_DRACONIC_SPEED = ITEMS.register("item_draconic_speed", () -> new ModuleItem((Supplier<Module<?>>)DRACONIC_SPEED));
        ITEM_CHAOTIC_SPEED = ITEMS.register("item_chaotic_speed", () -> new ModuleItem((Supplier<Module<?>>)CHAOTIC_SPEED));
        DRACONIUM_DAMAGE = MODULES.register("draconium_damage", () -> new ModuleImpl<DamageData>(ModuleTypes.DAMAGE, TechLevel.DRACONIUM, DEModules.damageData(2.0)));
        WYVERN_DAMAGE = MODULES.register("wyvern_damage", () -> new ModuleImpl<DamageData>(ModuleTypes.DAMAGE, TechLevel.WYVERN, DEModules.damageData(4.0)));
        DRACONIC_DAMAGE = MODULES.register("draconic_damage", () -> new ModuleImpl<DamageData>(ModuleTypes.DAMAGE, TechLevel.DRACONIC, DEModules.damageData(8.0)));
        CHAOTIC_DAMAGE = MODULES.register("chaotic_damage", () -> new ModuleImpl<DamageData>(ModuleTypes.DAMAGE, TechLevel.CHAOTIC, DEModules.damageData(16.0)));
        ITEM_DRACONIUM_DAMAGE = ITEMS.register("item_draconium_damage", () -> new ModuleItem((Supplier<Module<?>>)DRACONIUM_DAMAGE));
        ITEM_WYVERN_DAMAGE = ITEMS.register("item_wyvern_damage", () -> new ModuleItem((Supplier<Module<?>>)WYVERN_DAMAGE));
        ITEM_DRACONIC_DAMAGE = ITEMS.register("item_draconic_damage", () -> new ModuleItem((Supplier<Module<?>>)DRACONIC_DAMAGE));
        ITEM_CHAOTIC_DAMAGE = ITEMS.register("item_chaotic_damage", () -> new ModuleItem((Supplier<Module<?>>)CHAOTIC_DAMAGE));
        DRACONIUM_AOE = MODULES.register("draconium_aoe", () -> new ModuleImpl<AOEData>(ModuleTypes.AOE, TechLevel.DRACONIUM, DEModules.aoeData(1)));
        WYVERN_AOE = MODULES.register("wyvern_aoe", () -> new ModuleImpl<AOEData>(ModuleTypes.AOE, TechLevel.WYVERN, DEModules.aoeData(2)));
        DRACONIC_AOE = MODULES.register("draconic_aoe", () -> new ModuleImpl<AOEData>(ModuleTypes.AOE, TechLevel.DRACONIC, DEModules.aoeData(3)));
        CHAOTIC_AOE = MODULES.register("chaotic_aoe", () -> new ModuleImpl<AOEData>(ModuleTypes.AOE, TechLevel.CHAOTIC, DEModules.aoeData(5)));
        ITEM_DRACONIUM_AOE = ITEMS.register("item_draconium_aoe", () -> new ModuleItem((Supplier<Module<?>>)DRACONIUM_AOE));
        ITEM_WYVERN_AOE = ITEMS.register("item_wyvern_aoe", () -> new ModuleItem((Supplier<Module<?>>)WYVERN_AOE));
        ITEM_DRACONIC_AOE = ITEMS.register("item_draconic_aoe", () -> new ModuleItem((Supplier<Module<?>>)DRACONIC_AOE));
        ITEM_CHAOTIC_AOE = ITEMS.register("item_chaotic_aoe", () -> new ModuleItem((Supplier<Module<?>>)CHAOTIC_AOE));
        WYVERN_MINING_STABILITY = MODULES.register("wyvern_mining_stability", () -> new ModuleImpl<NoData>(ModuleTypes.MINING_STABILITY, TechLevel.WYVERN, DEModules.noData()));
        ITEM_WYVERN_MINING_STABILITY = ITEMS.register("item_wyvern_mining_stability", () -> new ModuleItem((Supplier<Module<?>>)WYVERN_MINING_STABILITY));
        WYVERN_TREE_HARVEST = MODULES.register("wyvern_tree_harvest", () -> new ModuleImpl<TreeHarvestData>(ModuleTypes.TREE_HARVEST, TechLevel.WYVERN, DEModules.treeHarvestData(16, 5)));
        DRACONIC_TREE_HARVEST = MODULES.register("draconic_tree_harvest", () -> new ModuleImpl<TreeHarvestData>(ModuleTypes.TREE_HARVEST, TechLevel.DRACONIC, DEModules.treeHarvestData(48, 15)));
        CHAOTIC_TREE_HARVEST = MODULES.register("chaotic_tree_harvest", () -> new ModuleImpl<TreeHarvestData>(ModuleTypes.TREE_HARVEST, TechLevel.CHAOTIC, DEModules.treeHarvestData(144, 45)));
        ITEM_WYVERN_TREE_HARVEST = ITEMS.register("item_wyvern_tree_harvest", () -> new ModuleItem((Supplier<Module<?>>)WYVERN_TREE_HARVEST));
        ITEM_DRACONIC_TREE_HARVEST = ITEMS.register("item_draconic_tree_harvest", () -> new ModuleItem((Supplier<Module<?>>)DRACONIC_TREE_HARVEST));
        ITEM_CHAOTIC_TREE_HARVEST = ITEMS.register("item_chaotic_tree_harvest", () -> new ModuleItem((Supplier<Module<?>>)CHAOTIC_TREE_HARVEST));
        WYVERN_JUNK_FILTER = MODULES.register("wyvern_junk_filter", () -> new ModuleImpl<NoData>(ModuleTypes.JUNK_FILTER, TechLevel.WYVERN, DEModules.noData()));
        ITEM_WYVERN_JUNK_FILTER = ITEMS.register("item_wyvern_junk_filter", () -> new ModuleItem((Supplier<Module<?>>)WYVERN_JUNK_FILTER));
        WYVERN_ENDER_COLLECTION = MODULES.register("wyvern_ender_collection", () -> new ModuleImpl<NoData>(ModuleTypes.ENDER_COLLECTION, TechLevel.WYVERN, DEModules.noData()));
        DRACONIC_ENDER_COLLECTION = MODULES.register("draconic_ender_collection", () -> new ModuleImpl<NoData>(ModuleTypes.ENDER_COLLECTION, TechLevel.DRACONIC, DEModules.noData(), 2, 2));
        ITEM_WYVERN_ENDER_COLLECTION = ITEMS.register("item_wyvern_ender_collection", () -> new EnderCollectionModuleItem((Supplier<Module<?>>)WYVERN_ENDER_COLLECTION));
        ITEM_DRACONIC_ENDER_COLLECTION = ITEMS.register("item_draconic_ender_collection", () -> new EnderCollectionModuleItem((Supplier<Module<?>>)DRACONIC_ENDER_COLLECTION));
        WYVERN_PROJ_VELOCITY = MODULES.register("wyvern_proj_velocity", () -> new ProjectileVelocityModule(ModuleTypes.PROJ_MODIFIER, TechLevel.WYVERN, DEModules.projVelocityData(0.15f, 1.0f)).setMaxInstall(8));
        DRACONIC_PROJ_VELOCITY = MODULES.register("draconic_proj_velocity", () -> new ProjectileVelocityModule(ModuleTypes.PROJ_MODIFIER, TechLevel.DRACONIC, DEModules.projVelocityData(0.35f, 0.5f)).setMaxInstall(8));
        CHAOTIC_PROJ_VELOCITY = MODULES.register("chaotic_proj_velocity", () -> new ProjectileVelocityModule(ModuleTypes.PROJ_MODIFIER, TechLevel.CHAOTIC, DEModules.projVelocityData(0.75f, 0.0f)).setMaxInstall(8));
        ITEM_WYVERN_PROJ_VELOCITY = ITEMS.register("item_wyvern_proj_velocity", () -> new ModuleItem((Supplier<Module<?>>)WYVERN_PROJ_VELOCITY));
        ITEM_DRACONIC_PROJ_VELOCITY = ITEMS.register("item_draconic_proj_velocity", () -> new ModuleItem((Supplier<Module<?>>)DRACONIC_PROJ_VELOCITY));
        ITEM_CHAOTIC_PROJ_VELOCITY = ITEMS.register("item_chaotic_proj_velocity", () -> new ModuleItem((Supplier<Module<?>>)CHAOTIC_PROJ_VELOCITY));
        WYVERN_PROJ_ACCURACY = MODULES.register("wyvern_proj_accuracy", () -> new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.WYVERN, DEModules.projAccuracyData(0.125f, 2.0f), 2, 1));
        DRACONIC_PROJ_ACCURACY = MODULES.register("draconic_proj_accuracy", () -> new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.DRACONIC, DEModules.projAccuracyData(0.2f, 1.0f), 2, 1));
        CHAOTIC_PROJ_ACCURACY = MODULES.register("chaotic_proj_accuracy", () -> new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.CHAOTIC, DEModules.projAccuracyData(0.25f, 0.0f), 2, 1));
        ITEM_WYVERN_PROJ_ACCURACY = ITEMS.register("item_wyvern_proj_accuracy", () -> new ModuleItem((Supplier<Module<?>>)WYVERN_PROJ_ACCURACY));
        ITEM_DRACONIC_PROJ_ACCURACY = ITEMS.register("item_draconic_proj_accuracy", () -> new ModuleItem((Supplier<Module<?>>)DRACONIC_PROJ_ACCURACY));
        ITEM_CHAOTIC_PROJ_ACCURACY = ITEMS.register("item_chaotic_proj_accuracy", () -> new ModuleItem((Supplier<Module<?>>)CHAOTIC_PROJ_ACCURACY));
        WYVERN_PROJ_GRAV_COMP = MODULES.register("wyvern_proj_grav_comp", () -> new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.WYVERN, DEModules.projAntiGravData(0.2f, 2.0f), 2, 1));
        DRACONIC_PROJ_GRAV_COMP = MODULES.register("draconic_proj_grav_comp", () -> new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.DRACONIC, DEModules.projAntiGravData(0.25f, 1.0f), 2, 1));
        CHAOTIC_PROJ_GRAV_COMP = MODULES.register("chaotic_proj_grav_comp", () -> new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.CHAOTIC, DEModules.projAntiGravData(0.5f, 0.0f), 2, 1));
        ITEM_WYVERN_PROJ_GRAV_COMP = ITEMS.register("item_wyvern_proj_grav_comp", () -> new ModuleItem((Supplier<Module<?>>)WYVERN_PROJ_GRAV_COMP));
        ITEM_DRACONIC_PROJ_GRAV_COMP = ITEMS.register("item_draconic_proj_grav_comp", () -> new ModuleItem((Supplier<Module<?>>)DRACONIC_PROJ_GRAV_COMP));
        ITEM_CHAOTIC_PROJ_GRAV_COMP = ITEMS.register("item_chaotic_proj_grav_comp", () -> new ModuleItem((Supplier<Module<?>>)CHAOTIC_PROJ_GRAV_COMP));
        WYVERN_PROJ_PENETRATION = MODULES.register("wyvern_proj_penetration", () -> new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.WYVERN, DEModules.projPenetrationData(0.25f, 2.0f), 2, 2));
        DRACONIC_PROJ_PENETRATION = MODULES.register("draconic_proj_penetration", () -> new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.DRACONIC, DEModules.projPenetrationData(0.5f, 1.0f), 2, 2));
        CHAOTIC_PROJ_PENETRATION = MODULES.register("chaotic_proj_penetration", () -> new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.CHAOTIC, DEModules.projPenetrationData(0.75f, 0.0f), 2, 2));
        ITEM_WYVERN_PROJ_PENETRATION = ITEMS.register("item_wyvern_proj_penetration", () -> new ModuleItem((Supplier<Module<?>>)WYVERN_PROJ_PENETRATION));
        ITEM_DRACONIC_PROJ_PENETRATION = ITEMS.register("item_draconic_proj_penetration", () -> new ModuleItem((Supplier<Module<?>>)DRACONIC_PROJ_PENETRATION));
        ITEM_CHAOTIC_PROJ_PENETRATION = ITEMS.register("item_chaotic_proj_penetration", () -> new ModuleItem((Supplier<Module<?>>)CHAOTIC_PROJ_PENETRATION));
        WYVERN_PROJ_DAMAGE = MODULES.register("wyvern_proj_damage", () -> new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.WYVERN, DEModules.projDamageData(0.25f, 2.0f)));
        DRACONIC_PROJ_DAMAGE = MODULES.register("draconic_proj_damage", () -> new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.DRACONIC, DEModules.projDamageData(0.5f, 1.0f)));
        CHAOTIC_PROJ_DAMAGE = MODULES.register("chaotic_proj_damage", () -> new ModuleImpl<ProjectileData>(ModuleTypes.PROJ_MODIFIER, TechLevel.CHAOTIC, DEModules.projDamageData(0.75f, 0.0f)));
        ITEM_WYVERN_PROJ_DAMAGE = ITEMS.register("item_wyvern_proj_damage", () -> new ModuleItem((Supplier<Module<?>>)WYVERN_PROJ_DAMAGE));
        ITEM_DRACONIC_PROJ_DAMAGE = ITEMS.register("item_draconic_proj_damage", () -> new ModuleItem((Supplier<Module<?>>)DRACONIC_PROJ_DAMAGE));
        ITEM_CHAOTIC_PROJ_DAMAGE = ITEMS.register("item_chaotic_proj_damage", () -> new ModuleItem((Supplier<Module<?>>)CHAOTIC_PROJ_DAMAGE));
        WYVERN_AUTO_FIRE = MODULES.register("wyvern_auto_fire", () -> new ModuleImpl<NoData>(ModuleTypes.AUTO_FIRE, TechLevel.WYVERN, DEModules.noData()));
        ITEM_WYVERN_AUTO_FIRE = ITEMS.register("item_wyvern_auto_fire", () -> new ModuleItem((Supplier<Module<?>>)WYVERN_AUTO_FIRE));
        DRACONIC_PROJ_ANTI_IMMUNE = MODULES.register("draconic_proj_anti_immune", () -> new ModuleImpl<NoData>(ModuleTypes.PROJ_ANTI_IMMUNE, TechLevel.DRACONIC, DEModules.noData()));
        ITEM_DRACONIC_PROJ_ANTI_IMMUNE = ITEMS.register("item_draconic_proj_anti_immune", () -> new ModuleItem((Supplier<Module<?>>)DRACONIC_PROJ_ANTI_IMMUNE));
        WYVERN_SHIELD_CONTROL = MODULES.register("wyvern_shield_control", () -> new ModuleImpl<ShieldControlData>(ModuleTypes.SHIELD_CONTROLLER, TechLevel.WYVERN, DEModules.shieldControl(20.0)));
        DRACONIC_SHIELD_CONTROL = MODULES.register("draconic_shield_control", () -> new ModuleImpl<ShieldControlData>(ModuleTypes.SHIELD_CONTROLLER, TechLevel.DRACONIC, DEModules.shieldControl(10.0)));
        CHAOTIC_SHIELD_CONTROL = MODULES.register("chaotic_shield_control", () -> new ModuleImpl<ShieldControlData>(ModuleTypes.SHIELD_CONTROLLER, TechLevel.CHAOTIC, DEModules.shieldControl(5.0)));
        ITEM_WYVERN_SHIELD_CONTROL = ITEMS.register("item_wyvern_shield_control", () -> new ModuleItem((Supplier<Module<?>>)WYVERN_SHIELD_CONTROL));
        ITEM_DRACONIC_SHIELD_CONTROL = ITEMS.register("item_draconic_shield_control", () -> new ModuleItem((Supplier<Module<?>>)DRACONIC_SHIELD_CONTROL));
        ITEM_CHAOTIC_SHIELD_CONTROL = ITEMS.register("item_chaotic_shield_control", () -> new ModuleItem((Supplier<Module<?>>)CHAOTIC_SHIELD_CONTROL));
        WYVERN_SHIELD_CAPACITY = MODULES.register("wyvern_shield_capacity", () -> new ModuleImpl<ShieldData>(ModuleTypes.SHIELD_BOOST, TechLevel.WYVERN, DEModules.shieldData(25, 0.1)));
        DRACONIC_SHIELD_CAPACITY = MODULES.register("draconic_shield_capacity", () -> new ModuleImpl<ShieldData>(ModuleTypes.SHIELD_BOOST, TechLevel.DRACONIC, DEModules.shieldData(50, 0.25)));
        CHAOTIC_SHIELD_CAPACITY = MODULES.register("chaotic_shield_capacity", () -> new ModuleImpl<ShieldData>(ModuleTypes.SHIELD_BOOST, TechLevel.CHAOTIC, DEModules.shieldData(100, 0.5)));
        WYVERN_LARGE_SHIELD_CAPACITY = MODULES.register("wyvern_large_shield_capacity", () -> new ModuleImpl<ShieldData>(ModuleTypes.SHIELD_BOOST, TechLevel.WYVERN, DEModules.shieldData(125, 0.0), 2, 2));
        DRACONIC_LARGE_SHIELD_CAPACITY = MODULES.register("draconic_large_shield_capacity", () -> new ModuleImpl<ShieldData>(ModuleTypes.SHIELD_BOOST, TechLevel.DRACONIC, DEModules.shieldData(250, 0.0), 2, 2));
        CHAOTIC_LARGE_SHIELD_CAPACITY = MODULES.register("chaotic_large_shield_capacity", () -> new ModuleImpl<ShieldData>(ModuleTypes.SHIELD_BOOST, TechLevel.CHAOTIC, DEModules.shieldData(500, 0.0), 2, 2));
        WYVERN_SHIELD_RECOVERY = MODULES.register("wyvern_shield_recovery", () -> new ModuleImpl<ShieldData>(ModuleTypes.SHIELD_BOOST, TechLevel.WYVERN, DEModules.shieldData(5, 1.0)));
        DRACONIC_SHIELD_RECOVERY = MODULES.register("draconic_shield_recovery", () -> new ModuleImpl<ShieldData>(ModuleTypes.SHIELD_BOOST, TechLevel.DRACONIC, DEModules.shieldData(10, 2.5)));
        CHAOTIC_SHIELD_RECOVERY = MODULES.register("chaotic_shield_recovery", () -> new ModuleImpl<ShieldData>(ModuleTypes.SHIELD_BOOST, TechLevel.CHAOTIC, DEModules.shieldData(20, 5.0)));
        ITEM_WYVERN_SHIELD_CAPACITY = ITEMS.register("item_wyvern_shield_capacity", () -> new ModuleItem((Supplier<Module<?>>)WYVERN_SHIELD_CAPACITY));
        ITEM_DRACONIC_SHIELD_CAPACITY = ITEMS.register("item_draconic_shield_capacity", () -> new ModuleItem((Supplier<Module<?>>)DRACONIC_SHIELD_CAPACITY));
        ITEM_CHAOTIC_SHIELD_CAPACITY = ITEMS.register("item_chaotic_shield_capacity", () -> new ModuleItem((Supplier<Module<?>>)CHAOTIC_SHIELD_CAPACITY));
        ITEM_WYVERN_LARGE_SHIELD_CAPACITY = ITEMS.register("item_wyvern_large_shield_capacity", () -> new ModuleItem((Supplier<Module<?>>)WYVERN_LARGE_SHIELD_CAPACITY));
        ITEM_DRACONIC_LARGE_SHIELD_CAPACITY = ITEMS.register("item_draconic_large_shield_capacity", () -> new ModuleItem((Supplier<Module<?>>)DRACONIC_LARGE_SHIELD_CAPACITY));
        ITEM_CHAOTIC_LARGE_SHIELD_CAPACITY = ITEMS.register("item_chaotic_large_shield_capacity", () -> new ModuleItem((Supplier<Module<?>>)CHAOTIC_LARGE_SHIELD_CAPACITY));
        ITEM_WYVERN_SHIELD_RECOVERY = ITEMS.register("item_wyvern_shield_recovery", () -> new ModuleItem((Supplier<Module<?>>)WYVERN_SHIELD_RECOVERY));
        ITEM_DRACONIC_SHIELD_RECOVERY = ITEMS.register("item_draconic_shield_recovery", () -> new ModuleItem((Supplier<Module<?>>)DRACONIC_SHIELD_RECOVERY));
        ITEM_CHAOTIC_SHIELD_RECOVERY = ITEMS.register("item_chaotic_shield_recovery", () -> new ModuleItem((Supplier<Module<?>>)CHAOTIC_SHIELD_RECOVERY));
        WYVERN_FLIGHT = MODULES.register("wyvern_flight", () -> new ModuleImpl<FlightData>(ModuleTypes.FLIGHT, TechLevel.WYVERN, DEModules.flightData(true, false, 1.0), 2, 2));
        DRACONIC_FLIGHT = MODULES.register("draconic_flight", () -> new ModuleImpl<FlightData>(ModuleTypes.FLIGHT, TechLevel.DRACONIC, DEModules.flightData(true, true, 2.0)));
        CHAOTIC_FLIGHT = MODULES.register("chaotic_flight", () -> new ModuleImpl<FlightData>(ModuleTypes.FLIGHT, TechLevel.CHAOTIC, DEModules.flightData(true, true, 3.5)));
        ITEM_WYVERN_FLIGHT = ITEMS.register("item_wyvern_flight", () -> new ModuleItem((Supplier<Module<?>>)WYVERN_FLIGHT));
        ITEM_DRACONIC_FLIGHT = ITEMS.register("item_draconic_flight", () -> new ModuleItem((Supplier<Module<?>>)DRACONIC_FLIGHT));
        ITEM_CHAOTIC_FLIGHT = ITEMS.register("item_chaotic_flight", () -> new ModuleItem((Supplier<Module<?>>)CHAOTIC_FLIGHT));
        WYVERN_UNDYING = MODULES.register("wyvern_undying", () -> new ModuleImpl<UndyingData>(ModuleTypes.UNDYING, TechLevel.WYVERN, DEModules.undyingData(6.0f, 25.0f, 300, 2400, 5000000L, 2.0)));
        DRACONIC_UNDYING = MODULES.register("draconic_undying", () -> new ModuleImpl<UndyingData>(ModuleTypes.UNDYING, TechLevel.DRACONIC, DEModules.undyingData(12.0f, 50.0f, 600, 1200, 10000000L, 3.0)).setMaxInstall(2));
        CHAOTIC_UNDYING = MODULES.register("chaotic_undying", () -> new ModuleImpl<UndyingData>(ModuleTypes.UNDYING, TechLevel.CHAOTIC, DEModules.undyingData(20.0f, 100.0f, 2400, 900, 20000000L, 3.0)).setMaxInstall(3));
        ITEM_WYVERN_UNDYING = ITEMS.register("item_wyvern_undying", () -> new ModuleItem((Supplier<Module<?>>)WYVERN_UNDYING));
        ITEM_DRACONIC_UNDYING = ITEMS.register("item_draconic_undying", () -> new ModuleItem((Supplier<Module<?>>)DRACONIC_UNDYING));
        ITEM_CHAOTIC_UNDYING = ITEMS.register("item_chaotic_undying", () -> new ModuleItem((Supplier<Module<?>>)CHAOTIC_UNDYING));
        DRACONIUM_AUTO_FEED = MODULES.register("draconium_auto_feed", () -> new ModuleImpl<AutoFeedData>(ModuleTypes.AUTO_FEED, TechLevel.DRACONIUM, DEModules.autoFeedData(40.0f)));
        WYVERN_AUTO_FEED = MODULES.register("wyvern_auto_feed", () -> new ModuleImpl<AutoFeedData>(ModuleTypes.AUTO_FEED, TechLevel.WYVERN, DEModules.autoFeedData(150.0f)));
        DRACONIC_AUTO_FEED = MODULES.register("draconic_auto_feed", () -> new ModuleImpl<AutoFeedData>(ModuleTypes.AUTO_FEED, TechLevel.DRACONIC, DEModules.autoFeedData(400.0f)));
        ITEM_DRACONIUM_AUTO_FEED = ITEMS.register("item_draconium_auto_feed", () -> new ModuleItem((Supplier<Module<?>>)DRACONIUM_AUTO_FEED));
        ITEM_WYVERN_AUTO_FEED = ITEMS.register("item_wyvern_auto_feed", () -> new ModuleItem((Supplier<Module<?>>)WYVERN_AUTO_FEED));
        ITEM_DRACONIC_AUTO_FEED = ITEMS.register("item_draconic_auto_feed", () -> new ModuleItem((Supplier<Module<?>>)DRACONIC_AUTO_FEED));
        WYVERN_NIGHT_VISION = MODULES.register("wyvern_night_vision", () -> new ModuleImpl<NoData>(ModuleTypes.NIGHT_VISION, TechLevel.WYVERN, DEModules.noData()));
        ITEM_WYVERN_NIGHT_VISION = ITEMS.register("item_wyvern_night_vision", () -> new ModuleItem((Supplier<Module<?>>)WYVERN_NIGHT_VISION));
        WYVERN_HILL_STEP = MODULES.register("wyvern_hill_step", () -> new ModuleImpl<NoData>(ModuleTypes.HILL_STEP, TechLevel.WYVERN, DEModules.noData()));
        ITEM_WYVERN_HILL_STEP = ITEMS.register("item_wyvern_hill_step", () -> new ModuleItem((Supplier<Module<?>>)WYVERN_HILL_STEP));
        DRACONIUM_JUMP = MODULES.register("draconium_jump", () -> new ModuleImpl<JumpData>(ModuleTypes.JUMP_BOOST, TechLevel.DRACONIUM, DEModules.jumpData(0.25)));
        WYVERN_JUMP = MODULES.register("wyvern_jump", () -> new ModuleImpl<JumpData>(ModuleTypes.JUMP_BOOST, TechLevel.WYVERN, DEModules.jumpData(0.75)));
        DRACONIC_JUMP = MODULES.register("draconic_jump", () -> new ModuleImpl<JumpData>(ModuleTypes.JUMP_BOOST, TechLevel.DRACONIC, DEModules.jumpData(1.25)));
        CHAOTIC_JUMP = MODULES.register("chaotic_jump", () -> new ModuleImpl<JumpData>(ModuleTypes.JUMP_BOOST, TechLevel.CHAOTIC, DEModules.jumpData(4.0)));
        ITEM_DRACONIUM_JUMP = ITEMS.register("item_draconium_jump", () -> new ModuleItem((Supplier<Module<?>>)DRACONIUM_JUMP));
        ITEM_WYVERN_JUMP = ITEMS.register("item_wyvern_jump", () -> new ModuleItem((Supplier<Module<?>>)WYVERN_JUMP));
        ITEM_DRACONIC_JUMP = ITEMS.register("item_draconic_jump", () -> new ModuleItem((Supplier<Module<?>>)DRACONIC_JUMP));
        ITEM_CHAOTIC_JUMP = ITEMS.register("item_chaotic_jump", () -> new ModuleItem((Supplier<Module<?>>)CHAOTIC_JUMP));
        WYVERN_AQUA_ADEPT = MODULES.register("wyvern_aqua_adapt", () -> new ModuleImpl<NoData>(ModuleTypes.AQUA_ADEPT, TechLevel.WYVERN, DEModules.noData()));
        ITEM_WYVERN_AQUA_ADAPT = ITEMS.register("item_wyvern_aqua_adapt", () -> new ModuleItem((Supplier<Module<?>>)WYVERN_AQUA_ADEPT));
    }
}

