/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.inventory;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class CraftingInventoryWrapper
extends TransientCraftingContainer {
    private IItemHandlerModifiable wrapped;
    private AbstractContainerMenu container;

    public CraftingInventoryWrapper(AbstractContainerMenu container, int width, int height, IItemHandlerModifiable wrapped) {
        super(container, width, height);
        this.container = container;
        this.wrapped = wrapped;
    }

    public int getContainerSize() {
        return this.wrapped.getSlots();
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.wrapped.getSlots(); ++i) {
            if (this.wrapped.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int index) {
        return index < 0 || index >= this.getContainerSize() ? ItemStack.EMPTY : this.wrapped.getStackInSlot(index);
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack ret = this.wrapped.getStackInSlot(index);
        this.wrapped.setStackInSlot(index, ItemStack.EMPTY);
        return ret;
    }

    public ItemStack removeItem(int index, int count) {
        if (index < 0 || index >= this.getContainerSize()) {
            return ItemStack.EMPTY;
        }
        ItemStack itemstack = this.wrapped.extractItem(index, count, false);
        if (!itemstack.isEmpty()) {
            this.container.slotsChanged((Container)this);
        }
        return itemstack;
    }

    public void setItem(int index, ItemStack stack) {
        this.wrapped.setStackInSlot(index, stack);
        this.container.slotsChanged((Container)this);
    }

    public void clearContent() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            this.wrapped.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public void fillStackedContents(StackedContents itemHelper) {
        for (int i = 0; i < this.wrapped.getSlots(); ++i) {
            itemHelper.accountSimpleStack(this.wrapped.getStackInSlot(i));
        }
    }

    public List<ItemStack> getItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            items.add(this.getItem(i));
        }
        return items;
    }
}

