/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.equipment;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.client.render.EquippedItemModel;
import com.brandon3055.brandonscore.items.EquippedModelItem;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.api.capability.ModuleHost;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.api.config.DecimalProperty;
import com.brandon3055.draconicevolution.api.modules.ModuleCategory;
import com.brandon3055.draconicevolution.api.modules.ModuleTypes;
import com.brandon3055.draconicevolution.api.modules.data.JumpData;
import com.brandon3055.draconicevolution.api.modules.data.SpeedData;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.api.modules.lib.ModuleHostImpl;
import com.brandon3055.draconicevolution.client.model.ModularChestpieceModel;
import com.brandon3055.draconicevolution.init.EquipCfg;
import com.brandon3055.draconicevolution.init.ModuleCfg;
import com.brandon3055.draconicevolution.init.TechProperties;
import com.brandon3055.draconicevolution.integration.equipment.EquipmentManager;
import com.brandon3055.draconicevolution.integration.equipment.IDEEquipment;
import com.brandon3055.draconicevolution.items.equipment.IModularArmor;
import com.brandon3055.draconicevolution.items.equipment.IModularEnergyItem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.ClientHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularChestpiece
extends ArmorItem
implements IModularArmor,
IDEEquipment,
EquippedModelItem,
IModularEnergyItem {
    private final TechLevel techLevel;
    @OnlyIn(value=Dist.CLIENT)
    private ModularChestpieceModel<?> model;
    @OnlyIn(value=Dist.CLIENT)
    private ModularChestpieceModel<?> model_on_armor;

    public ModularChestpiece(TechProperties props) {
        super(ArmorMaterials.DIAMOND, ArmorItem.Type.CHESTPLATE, (Item.Properties)props);
        this.techLevel = props.getTechLevel();
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, LivingEntity entity) {
        if (entity instanceof LivingEntity && !EquipmentManager.findItem(e -> e.getItem() instanceof ModularChestpiece, entity).isEmpty()) {
            return false;
        }
        return entity.getEquipmentSlotForItem(stack) == armorType;
    }

    @Override
    public boolean canEquip(ItemStack stack, LivingEntity livingEntity, String slotID) {
        if (!slotID.equals("body") || !EquipmentManager.findItem(e -> e.getItem() instanceof ModularChestpiece, livingEntity).isEmpty()) {
            return false;
        }
        return !(livingEntity.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof ModularChestpiece);
    }

    @Override
    public TechLevel getTechLevel() {
        return this.techLevel;
    }

    @Override
    @NotNull
    public ModuleHostImpl instantiateHost(ItemStack stack) {
        ModuleHostImpl host = new ModuleHostImpl(this.techLevel, ModuleCfg.chestpieceWidth(this.techLevel), ModuleCfg.chestpieceHeight(this.techLevel), "chestpiece", ModuleCfg.removeInvalidModules, new ModuleCategory[0]);
        host.addCategories(ModuleCategory.CHESTPIECE);
        host.addPropertyBuilder(props -> {
            JumpData jump;
            SpeedData speed = host.getModuleData(ModuleTypes.SPEED);
            if (speed != null) {
                double maxSpeed;
                SpeedData data = host.getModuleData(ModuleTypes.SPEED);
                double d = maxSpeed = data == null ? 0.0 : data.speedMultiplier();
                if (DEConfig.armorSpeedLimit != -1.0) {
                    maxSpeed = Math.min(maxSpeed, DEConfig.armorSpeedLimit);
                }
                props.add(new DecimalProperty("walk_speed", 0.0).min(0.0).max(maxSpeed).setFormatter(ConfigProperty.DecimalFormatter.PLUS_PERCENT_0));
                props.add(new DecimalProperty("run_speed", maxSpeed).min(0.0).max(maxSpeed).setFormatter(ConfigProperty.DecimalFormatter.PLUS_PERCENT_0));
            }
            if ((jump = host.getModuleData(ModuleTypes.JUMP_BOOST)) != null) {
                JumpData data = host.getModuleData(ModuleTypes.JUMP_BOOST);
                double jumpSetting = data == null ? 0.0 : data.multiplier();
                props.add(new DecimalProperty("jump_boost_run", jumpSetting).min(0.0).max(jumpSetting).setFormatter(ConfigProperty.DecimalFormatter.PLUS_PERCENT_0));
                props.add(new DecimalProperty("jump_boost", jumpSetting).min(0.0).max(jumpSetting).setFormatter(ConfigProperty.DecimalFormatter.PLUS_PERCENT_0));
            }
        });
        return host;
    }

    @Override
    @NotNull
    public ModularOPStorage instantiateOPStorage(ItemStack stack, Supplier<ModuleHost> hostSupplier) {
        return new ModularOPStorage(hostSupplier, EquipCfg.getBaseChestpieceEnergy(this.techLevel), EquipCfg.getBaseChestpieceTransfer(this.techLevel));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        this.addModularItemInformation(stack, context, tooltip, flagIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public EquippedItemModel getExtendedModel(LivingEntity entity, ItemStack stack, @Nullable EquipmentSlot slot, HumanoidModel<?> parentModel, boolean slim) {
        boolean onArmor;
        ItemStack chest = entity.getItemBySlot(EquipmentSlot.CHEST);
        boolean bl = onArmor = slot == null && !chest.isEmpty() && chest.getItem() instanceof ArmorItem;
        if (this.model == null || this.model_on_armor == null) {
            this.model = new ModularChestpieceModel(this.techLevel, false);
            this.model_on_armor = new ModularChestpieceModel(this.techLevel, true);
        }
        ModularChestpieceModel<?> activeModel = onArmor ? this.model_on_armor : this.model;
        ClientHooks.copyModelProperties(parentModel, activeModel);
        return activeModel;
    }

    public boolean canBeHurtBy(ItemStack stack, DamageSource source) {
        return source.is(DamageTypes.FELL_OUT_OF_WORLD);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.getAge() >= 0 && entity.pickupDelay != Short.MAX_VALUE) {
            entity.setExtendedLifetime();
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public boolean isEnchantable(ItemStack p_41456_) {
        return true;
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.damageBarVisible(stack);
    }

    public int getBarWidth(ItemStack stack) {
        return this.damageBarWidth(stack);
    }

    public int getBarColor(ItemStack stack) {
        return this.damageBarColour(stack);
    }
}

