/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.init;

import codechicken.lib.datagen.ItemModelProvider;
import codechicken.lib.datagen.recipe.RecipeProvider;
import codechicken.microblock.client.MicroblockItemRenderer;
import codechicken.microblock.init.CBMicroblockModContent;
import codechicken.microblock.init.CBMicroblockTags;
import codechicken.microblock.recipe.MicroRecipe;
import java.util.concurrent.CompletableFuture;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import org.jetbrains.annotations.Nullable;

public class DataGenerators {
    private static final CrashLock LOCK = new CrashLock("Already Initialized");

    public static void init(IEventBus modBus) {
        LOCK.lock();
        modBus.addListener(DataGenerators::registerDataGens);
    }

    private static void registerDataGens(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        ExistingFileHelper files = event.getExistingFileHelper();
        gen.addProvider(event.includeClient(), (DataProvider)new ItemModels(output, files));
        gen.addProvider(event.includeServer(), (DataProvider)new ItemTagGen(output, event.getLookupProvider(), CompletableFuture.supplyAsync(TagsProvider.TagLookup::empty), files));
        gen.addProvider(event.includeServer(), (DataProvider)new Recipes(event.getLookupProvider(), output));
    }

    private static class ItemModels
    extends ItemModelProvider {
        public ItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
            super(output, "cb_microblock", existingFileHelper);
        }

        protected void registerModels() {
            this.clazz((ItemLike)CBMicroblockModContent.MICRO_BLOCK_ITEM.get(), MicroblockItemRenderer.class);
            this.generated((ItemLike)CBMicroblockModContent.STONE_ROD_ITEM.get());
            this.generated((ItemLike)CBMicroblockModContent.STONE_SAW.get());
            this.generated((ItemLike)CBMicroblockModContent.IRON_SAW.get());
            this.generated((ItemLike)CBMicroblockModContent.DIAMOND_SAW.get());
        }
    }

    private static class ItemTagGen
    extends ItemTagsProvider {
        public ItemTagGen(PackOutput output, CompletableFuture<HolderLookup.Provider> providerLookup, CompletableFuture<TagsProvider.TagLookup<Block>> tagLookup, @Nullable ExistingFileHelper files) {
            super(output, providerLookup, tagLookup, "cb_microblock", files);
        }

        protected void addTags(HolderLookup.Provider pProvider) {
            this.tag(CBMicroblockTags.Items.TOOL_SAW).add((Object)((Item)CBMicroblockModContent.STONE_SAW.get())).add((Object)((Item)CBMicroblockModContent.IRON_SAW.get())).add((Object)((Item)CBMicroblockModContent.DIAMOND_SAW.get()));
            this.tag(CBMicroblockTags.Items.STONE_ROD).add((Object)((Item)CBMicroblockModContent.STONE_ROD_ITEM.get()));
        }
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(CompletableFuture<HolderLookup.Provider> registries, PackOutput output) {
            super(registries, output, "cb_microblock");
        }

        protected void registerRecipes() {
            this.special(ResourceLocation.fromNamespaceAndPath((String)"cb_microblock", (String)"microblock"), MicroRecipe::new);
            this.shapedRecipe((ItemLike)CBMicroblockModContent.STONE_ROD_ITEM.get()).key('S', Tags.Items.COBBLESTONES).patternLine("S").patternLine("S");
            this.shapedRecipe((ItemLike)CBMicroblockModContent.STONE_SAW.get()).key('S', Tags.Items.RODS_WOODEN).key('R', CBMicroblockTags.Items.STONE_ROD).key('M', (ItemLike)Items.FLINT).patternLine("SRR").patternLine("SMR");
            this.shapedRecipe((ItemLike)CBMicroblockModContent.IRON_SAW.get()).key('S', Tags.Items.RODS_WOODEN).key('R', CBMicroblockTags.Items.STONE_ROD).key('M', Tags.Items.INGOTS_IRON).patternLine("SRR").patternLine("SMR");
            this.shapedRecipe((ItemLike)CBMicroblockModContent.DIAMOND_SAW.get()).key('S', Tags.Items.RODS_WOODEN).key('R', CBMicroblockTags.Items.STONE_ROD).key('M', Tags.Items.GEMS_DIAMOND).patternLine("SRR").patternLine("SMR");
        }
    }
}

