/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.api.MicroMaterialClient;
import codechicken.microblock.item.ItemMicroBlock;
import codechicken.microblock.part.MicroblockPartFactory;
import codechicken.microblock.util.MaskedCuboid;
import codechicken.microblock.util.MicroMaterialRegistry;
import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.part.BaseMultipart;
import codechicken.multipart.util.PartRayTraceResult;
import java.util.LinkedList;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class MicroblockPart
extends BaseMultipart {
    public MicroMaterial material;
    public byte shape = 0;

    public MicroblockPart(MicroMaterial material) {
        this.material = material;
    }

    public abstract MicroblockPartFactory getMicroFactory();

    public final int getSize() {
        return this.shape >> 4;
    }

    public final int getShapeSlot() {
        return this.shape & 0xF;
    }

    public MicroMaterial getMaterial() {
        return this.material;
    }

    public void setShape(int size, int slot) {
        this.shape = (byte)(size << 4 | slot & 0xF);
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        packet.writeRegistryIdDirect(MicroMaterialRegistry.microMaterials(), (Object)this.material);
        packet.writeByte((int)this.shape);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        this.shape = packet.readByte();
    }

    public void sendShapeUpdate() {
        this.sendUpdate(p -> p.writeByte((int)this.shape));
    }

    @Override
    public void readUpdate(MCDataInput packet) {
        super.readUpdate(packet);
        this.tile().notifyPartChange(this);
    }

    @Override
    public void save(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putByte("shape", this.shape);
        tag.putString("material", this.material.getRegistryName().toString());
    }

    @Override
    public void load(CompoundTag tag, HolderLookup.Provider registries) {
        this.shape = tag.getByte("shape");
        this.material = MicroMaterialRegistry.getMaterial(tag.getString("material"));
    }

    public abstract Cuboid6 getBounds();

    public abstract int getItemFactoryId();

    @Override
    public Iterable<ItemStack> getDrops() {
        int size = this.getSize();
        LinkedList<ItemStack> items = new LinkedList<ItemStack>();
        for (int s : new int[]{4, 2, 1}) {
            int m = size / s;
            size -= m * s;
            if (m <= 0) continue;
            items.add(ItemMicroBlock.createStack(m, this.getItemFactoryId(), s, this.material));
        }
        return items;
    }

    @Override
    public ItemStack getCloneStack(PartRayTraceResult hit) {
        int size = this.getSize();
        for (int s : new int[]{4, 2, 1}) {
            if (size % s != 0 || size / s < 1) continue;
            return ItemMicroBlock.create(this.getItemFactoryId(), size, this.material);
        }
        return super.getCloneStack(hit);
    }

    public abstract Iterable<MaskedCuboid> getRenderCuboids(boolean var1);

    @Override
    public final MultipartType<?> getType() {
        return this.getMicroFactory();
    }

    @Override
    public float getStrength(Player player, PartRayTraceResult hit) {
        return this.material.getStrength(player);
    }

    public boolean isTransparent() {
        return this.getMaterial().isTransparent();
    }

    @Override
    public int getLightEmission() {
        return this.getMaterial().getLightEmission();
    }

    @Override
    public float getExplosionResistance(Explosion explosion) {
        return this.getMaterial().getExplosionResistance((BlockGetter)this.level(), this.pos(), explosion) * this.getMicroFactory().getResistanceFactor();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addHitEffects(PartRayTraceResult hit, ParticleEngine engine) {
        MicroMaterialClient clientMaterial = MicroMaterialClient.get(this.material);
        if (clientMaterial != null) {
            clientMaterial.addHitEffects(this, hit, engine);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addDestroyEffects(PartRayTraceResult hit, ParticleEngine engine) {
        MicroMaterialClient clientMaterial = MicroMaterialClient.get(this.material);
        if (clientMaterial != null) {
            clientMaterial.addDestroyEffects(this, hit, engine);
        }
    }

    @Override
    public void addLandingEffects(PartRayTraceResult hit, Vector3 entity, int numberOfParticles) {
        MicroMaterialClient clientMaterial = MicroMaterialClient.get(this.material);
        if (clientMaterial != null) {
            clientMaterial.addLandingEffects(this, hit, entity, numberOfParticles);
        }
    }

    @Override
    public void addRunningEffects(PartRayTraceResult hit, Entity entity) {
        MicroMaterialClient clientMaterial = MicroMaterialClient.get(this.material);
        if (clientMaterial != null) {
            clientMaterial.addRunningEffects(this, hit, entity);
        }
    }
}

