/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.api;

import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.util.MultipartPlaceContext;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import org.jetbrains.annotations.Nullable;

public abstract class ItemMultipart
extends Item {
    public ItemMultipart(Item.Properties properties) {
        super(properties);
    }

    @Nullable
    public abstract MultiPart newPart(MultipartPlaceContext var1);

    public InteractionResult useOn(UseOnContext context) {
        MultipartPlaceContext ctx = new MultipartPlaceContext(context);
        if (ctx.getHitDepth() < 1.0 && this.place(ctx)) {
            return InteractionResult.SUCCESS;
        }
        return this.place(ctx.applyOffset()) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    private boolean place(MultipartPlaceContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        MultiPart part = this.newPart(context);
        if (part == null || !TileMultipart.canPlacePart((UseOnContext)context, part)) {
            return false;
        }
        if (!world.isClientSide) {
            TileMultipart.addPart(world, pos, part);
            SoundType sound = part.getPlacementSound((UseOnContext)context);
            if (sound != null) {
                world.playSound(null, pos, sound.getPlaceSound(), SoundSource.BLOCKS, (sound.getVolume() + 1.0f) / 2.0f, sound.getPitch() * 0.8f);
            }
        }
        if (!context.getPlayer().getAbilities().instabuild) {
            context.getItemInHand().shrink(1);
        }
        return true;
    }
}

