/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.api.part.render;

import codechicken.lib.render.CCRenderState;
import codechicken.multipart.api.part.ModelRenderPart;
import codechicken.multipart.api.part.render.PartRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public interface PartBakedModelRenderer<T extends ModelRenderPart>
extends PartRenderer<T> {
    public static <T extends ModelRenderPart> PartBakedModelRenderer<T> simple() {
        return new PartBakedModelRenderer<T>(){};
    }

    @Override
    default public List<BakedQuad> getQuads(T part, @Nullable Direction side, RandomSource rand, ModelData data, @Nullable RenderType renderType) {
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        BlockState state = part.getCurrentState();
        RandomSource randy = RandomSource.create();
        BakedModel model = blockRenderer.getBlockModel(state);
        if (renderType != null && !model.getRenderTypes(state, randy, data).contains(renderType)) {
            return List.of();
        }
        return model.getQuads(state, side, rand, data, renderType);
    }

    @Override
    default public void renderStatic(T part, @Nullable RenderType layer, CCRenderState ccrs) {
        BlockRenderDispatcher blockRenderer = Minecraft.getInstance().getBlockRenderer();
        BlockState state = part.getCurrentState();
        RandomSource randy = RandomSource.create();
        if (layer != null && !blockRenderer.getBlockModel(state).getRenderTypes(state, randy, part.getModelData()).contains(layer)) {
            return;
        }
        blockRenderer.renderBatched(part.getCurrentState(), part.pos(), ccrs.lightMatrix.access, new PoseStack(), ccrs.getConsumer(), true, randy, part.getModelData(), layer);
    }
}

