/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.init;

import codechicken.multipart.block.BlockMultipart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.util.MultipartLoadHandler;
import net.covers1624.quack.util.CrashLock;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class CBMultipartModContent {
    private static final CrashLock LOCK = new CrashLock("Already initialized.");
    private static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)Registries.BLOCK, (String)"cb_multipart");
    private static final DeferredRegister<BlockEntityType<?>> TILES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"cb_multipart");
    public static final DeferredHolder<Block, BlockMultipart> MULTIPART_BLOCK = BLOCKS.register("multipart", BlockMultipart::new);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<?>> MULTIPART_TILE_TYPE = TILES.register("saved_multipart", () -> BlockEntityType.Builder.of(MultipartLoadHandler.TileNBTContainer::new, (Block[])new Block[]{(Block)MULTIPART_BLOCK.get()}).build(null));

    public static void init(IEventBus modBus) {
        LOCK.lock();
        BLOCKS.register(modBus);
        TILES.register(modBus);
        modBus.addListener(EventPriority.LOWEST, CBMultipartModContent::onRegisterCapabilities);
    }

    private static void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        for (BlockCapability cap : BlockCapability.getAll()) {
            event.registerBlockEntity(cap, (BlockEntityType)MULTIPART_TILE_TYPE.get(), (tile, ctx) -> {
                if (tile instanceof TileMultipart) {
                    TileMultipart t = (TileMultipart)((Object)tile);
                    return SneakyUtils.unsafeCast(t.getCapability(cap, SneakyUtils.unsafeCast((Object)ctx)));
                }
                return null;
            });
        }
    }
}

