/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.minecraft;

import codechicken.lib.data.MCDataInput;
import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.redstone.FaceRedstonePart;
import codechicken.multipart.minecraft.McSidedStatePart;
import codechicken.multipart.minecraft.MinecraftMultipartModContent;
import codechicken.multipart.util.PartRayTraceResult;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class LeverPart
extends McSidedStatePart
implements FaceRedstonePart {
    public LeverPart() {
    }

    public LeverPart(BlockState state) {
        super(state);
    }

    @Override
    public MultipartType<?> getType() {
        return (MultipartType)MinecraftMultipartModContent.LEVER_PART.get();
    }

    @Override
    public BlockState defaultBlockState() {
        return Blocks.LEVER.defaultBlockState();
    }

    @Override
    public ItemStack getDropStack() {
        return new ItemStack((ItemLike)Blocks.LEVER);
    }

    public boolean active() {
        return (Boolean)this.state.getValue((Property)LeverBlock.POWERED);
    }

    @Override
    public Direction getSide() {
        return FaceAttachedHorizontalDirectionalBlock.getConnectedDirection((BlockState)this.state).getOpposite();
    }

    @Override
    @Nullable
    public MultiPart setStateOnPlacement(BlockPlaceContext context) {
        BlockState state;
        Direction face = context.getClickedFace();
        switch (face) {
            case DOWN: {
                BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)LeverBlock.FACE, (Comparable)AttachFace.CEILING)).setValue((Property)LeverBlock.FACING, (Comparable)context.getHorizontalDirection());
                break;
            }
            case UP: {
                BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)LeverBlock.FACE, (Comparable)AttachFace.FLOOR)).setValue((Property)LeverBlock.FACING, (Comparable)context.getHorizontalDirection());
                break;
            }
            default: {
                BlockState blockState = state = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)LeverBlock.FACE, (Comparable)AttachFace.WALL)).setValue((Property)LeverBlock.FACING, (Comparable)face);
            }
        }
        if (state.canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) {
            this.state = state;
            return this;
        }
        return null;
    }

    @Override
    public InteractionResult useWithoutItem(Player player, PartRayTraceResult hit) {
        if (this.level().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        this.state = (BlockState)this.state.cycle((Property)LeverBlock.POWERED);
        this.level().playSound(null, this.pos(), SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.3f, this.active() ? 0.6f : 0.5f);
        this.sendUpdate(this::writeDesc);
        this.tile().setChanged();
        this.tile().notifyPartChange(this);
        this.tile().notifyNeighborChange(this.getSide().ordinal());
        return InteractionResult.SUCCESS;
    }

    @Override
    public void onRemoved() {
        if (this.active()) {
            this.tile().notifyNeighborChange(this.getSide().ordinal());
        }
    }

    @Override
    public void onConverted() {
        if (this.active()) {
            this.tile().notifyNeighborChange(this.getSide().ordinal());
        }
    }

    @Override
    public int weakPowerLevel(int side) {
        return this.active() ? 15 : 0;
    }

    @Override
    public int strongPowerLevel(int side) {
        return this.active() && side == this.getSide().ordinal() ? 15 : 0;
    }

    @Override
    public boolean canConnectRedstone(int side) {
        return true;
    }

    @Override
    public int getFace() {
        return this.getSide().ordinal();
    }

    @Override
    public void readUpdate(MCDataInput packet) {
        super.readUpdate(packet);
        if (this.active()) {
            LeverBlock.makeParticle((BlockState)this.state, (LevelAccessor)this.level(), (BlockPos)this.pos(), (float)1.0f);
        }
    }
}

