/*
 * Decompiled with CFR 0.152.
 */
package codechicken.multipart.network;

import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.init.MultiPartRegistries;
import codechicken.multipart.network.MultiPartNetwork;
import codechicken.multipart.util.ControlKeyModifier;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class MultiPartSPH
implements ICustomPacketHandler.IServerPacketHandler {
    public void handlePacket(PacketCustom packet, ServerPlayer sender) {
        switch (packet.getType()) {
            case 1: {
                ControlKeyModifier.setIsControlDown((Player)sender, packet.readBoolean());
            }
        }
    }

    public static void sendDescUpdate(TileMultipart tile) {
        PacketCustom packet = new PacketCustom(MultiPartNetwork.NET_CHANNEL, 1, tile.getLevel().registryAccess());
        packet.writePos(tile.getBlockPos());
        tile.writeDesc((MCDataOutput)packet);
        packet.sendToChunk((BlockEntity)tile);
    }

    public static void sendAddPart(TileMultipart tile, MultiPart part) {
        ServerLevel world = (ServerLevel)tile.getLevel();
        PacketCustom packet = new PacketCustom(MultiPartNetwork.NET_CHANNEL, 2, world.registryAccess());
        packet.writePos(tile.getBlockPos());
        MultiPartRegistries.writePart((MCDataOutput)packet, part);
        packet.sendToChunk((BlockEntity)tile);
    }

    public static void sendRemPart(TileMultipart tile, int partIdx) {
        PacketCustom packet = new PacketCustom(MultiPartNetwork.NET_CHANNEL, 3, tile.getLevel().registryAccess());
        packet.writeByte(partIdx);
        packet.writePos(tile.getBlockPos());
        packet.sendToChunk((BlockEntity)tile);
    }

    public static void dispatchPartUpdate(MultiPart part, Consumer<MCDataOutput> func) {
        ServerLevel world = (ServerLevel)part.level();
        PacketCustom packet = new PacketCustom(MultiPartNetwork.NET_CHANNEL, 4, world.registryAccess());
        packet.writeByte(part.tile().getPartList().indexOf(part));
        packet.writePos(part.pos());
        func.accept((MCDataOutput)packet);
        packet.sendToChunk((BlockEntity)part.tile());
    }
}

