/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.repack.net.covers1624.quack.net.apache;

import io.codechicken.repack.net.covers1624.quack.annotation.Requires;
import io.codechicken.repack.net.covers1624.quack.io.IOUtils;
import io.codechicken.repack.net.covers1624.quack.io.ProgressInputStream;
import io.codechicken.repack.net.covers1624.quack.net.AbstractDownloadAction;
import io.codechicken.repack.net.covers1624.quack.net.DownloadAction;
import io.codechicken.repack.net.covers1624.quack.net.download.DownloadListener;
import io.codechicken.repack.org.apache.http.Header;
import io.codechicken.repack.org.apache.http.HttpEntity;
import io.codechicken.repack.org.apache.http.StatusLine;
import io.codechicken.repack.org.apache.http.client.methods.CloseableHttpResponse;
import io.codechicken.repack.org.apache.http.client.methods.HttpGet;
import io.codechicken.repack.org.apache.http.client.methods.HttpUriRequest;
import io.codechicken.repack.org.apache.http.client.utils.DateUtils;
import io.codechicken.repack.org.apache.http.impl.client.CloseableHttpClient;
import io.codechicken.repack.org.apache.http.impl.client.HttpClientBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires.RequiresList(value={@Requires(value="org.slf4j:slf4j-api"), @Requires(value="io.codechicken.repack.org.apache.httpcomponents:httpclient")})
public class ApacheHttpClientDownloadAction
extends AbstractDownloadAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApacheHttpClientDownloadAction.class);
    private static final CloseableHttpClient CLIENT = HttpClientBuilder.create().build();
    private CloseableHttpClient client = CLIENT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws IOException {
        String url = Objects.requireNonNull(this.url, "URL not set");
        DownloadAction.Dest dest = Objects.requireNonNull(this.dest, "Dest not set");
        HttpGet get = new HttpGet(url);
        this.headerList.forEach((name, value) -> get.addHeader(name, value));
        if (this.userAgent != null && !this.headerList.contains("User-Agent")) {
            get.addHeader("User-Agent", this.userAgent);
        }
        String etag = dest.getEtag();
        if (this.useETag && etag != null) {
            get.addHeader("If-None-Match", etag.trim());
        }
        long lastModifiedDisk = dest.getLastModified();
        if (this.onlyIfModified && lastModifiedDisk != -1L) {
            get.addHeader("If-Modified-Since", DateUtils.formatDate((Date)new Date(lastModifiedDisk)));
        }
        if (this.downloadListener != null) {
            this.downloadListener.connecting();
        }
        if (!this.quiet) {
            LOGGER.info("Connecting to {}.", (Object)url);
        }
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)get);){
            StatusLine line = response.getStatusLine();
            int code = line.getStatusCode();
            this.validateCode(code, line.getReasonPhrase());
            Header lastModifiedHeader = response.getLastHeader("Last-Modified");
            Date lastModifiedHeaderDate = null;
            if (lastModifiedHeader != null) {
                lastModifiedHeaderDate = DateUtils.parseDate((String)lastModifiedHeader.getValue());
            }
            this.upToDate = this.calcUpToDate(code, lastModifiedDisk, lastModifiedHeaderDate);
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                return;
            }
            long contentLen = entity.getContentLength();
            if (this.downloadListener != null) {
                this.downloadListener.start(contentLen);
            }
            InputStream content = entity.getContent();
            if (this.downloadListener != null) {
                content = new ProgressInputStream(content, this.downloadListener);
            }
            if (!this.quiet) {
                LOGGER.info("Downloading '{}'.", (Object)url);
            }
            boolean success = false;
            try (InputStream is = content;
                 OutputStream os = dest.getOutputStream();){
                IOUtils.copy(is, os);
                success = true;
            }
            finally {
                if (!this.quiet) {
                    LOGGER.info("Finished '{}'. Success? {}", (Object)url, (Object)success);
                }
                dest.onFinished(success);
            }
            if (this.onlyIfModified && lastModifiedHeaderDate != null) {
                dest.setLastModified(lastModifiedHeaderDate.getTime());
            }
            Header eTagHeader = response.getFirstHeader("ETag");
            if (this.useETag && eTagHeader != null) {
                dest.setEtag(eTagHeader.getValue());
            }
        }
    }

    public ApacheHttpClientDownloadAction setClient(CloseableHttpClient client) {
        this.client = client;
        return this;
    }

    @Override
    public ApacheHttpClientDownloadAction setUrl(String url) {
        super.setUrl(url);
        return this;
    }

    @Override
    public ApacheHttpClientDownloadAction setDest(DownloadAction.Dest dest) {
        super.setDest(dest);
        return this;
    }

    @Override
    public ApacheHttpClientDownloadAction setDest(StringWriter sw) {
        super.setDest(sw);
        return this;
    }

    @Override
    public ApacheHttpClientDownloadAction setDest(OutputStream os) {
        super.setDest(os);
        return this;
    }

    @Override
    public ApacheHttpClientDownloadAction setDest(File file) {
        super.setDest(file);
        return this;
    }

    @Override
    public ApacheHttpClientDownloadAction setDest(Path path) {
        super.setDest(path);
        return this;
    }

    @Override
    public ApacheHttpClientDownloadAction setOnlyIfModified(boolean onlyIfModified) {
        super.setOnlyIfModified(onlyIfModified);
        return this;
    }

    @Override
    public ApacheHttpClientDownloadAction setUseETag(boolean useETag) {
        super.setUseETag(useETag);
        return this;
    }

    @Override
    public ApacheHttpClientDownloadAction setQuiet(boolean quiet) {
        super.setQuiet(quiet);
        return this;
    }

    @Override
    public ApacheHttpClientDownloadAction addRequestHeader(String key, String value) {
        super.addRequestHeader(key, value);
        return this;
    }

    @Override
    public ApacheHttpClientDownloadAction setUserAgent(String userAgent) {
        super.setUserAgent(userAgent);
        return this;
    }

    @Override
    public ApacheHttpClientDownloadAction setDownloadListener(DownloadListener downloadListener) {
        super.setDownloadListener(downloadListener);
        return this;
    }

    public CloseableHttpClient getClient() {
        return this.client;
    }
}

