/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.repack.net.covers1624.quack.net.java;

import io.codechicken.repack.net.covers1624.quack.annotation.Requires;
import io.codechicken.repack.net.covers1624.quack.io.IOUtils;
import io.codechicken.repack.net.covers1624.quack.io.ProgressInputStream;
import io.codechicken.repack.net.covers1624.quack.net.AbstractDownloadAction;
import io.codechicken.repack.net.covers1624.quack.net.DownloadAction;
import io.codechicken.repack.net.covers1624.quack.net.download.DownloadListener;
import io.codechicken.repack.net.covers1624.quack.util.TimeUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(value="org.slf4j:slf4j-api")
public class JavaDownloadAction
extends AbstractDownloadAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaDownloadAction.class);
    private static final int MAX_REDIRECTS = Integer.getInteger("quack.JavaDownloadAction.max_redirects", 5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws IOException {
        String url = Objects.requireNonNull(this.url, "URL not set");
        DownloadAction.Dest dest = Objects.requireNonNull(this.dest, "Dest not set");
        String etag = dest.getEtag();
        long lastModified = dest.getLastModified();
        for (int i = 0; i < MAX_REDIRECTS; ++i) {
            URL res = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)res.openConnection();
            conn.setConnectTimeout(15000);
            conn.setReadTimeout(15000);
            conn.setInstanceFollowRedirects(false);
            this.headerList.forEach(conn::setRequestProperty);
            if (this.userAgent != null) {
                conn.setRequestProperty("User-Agent", this.userAgent);
            }
            if (this.useETag && etag != null) {
                conn.setRequestProperty("If-None-Match", etag.trim());
            }
            if (this.onlyIfModified && lastModified != -1L) {
                conn.setRequestProperty("If-Modified-Since", TimeUtils.FORMAT_RFC1123.format(new Date(lastModified)));
            }
            if (this.downloadListener != null) {
                this.downloadListener.connecting();
            }
            if (!this.quiet) {
                LOGGER.info("Connecting to {}.", (Object)url);
            }
            int code = conn.getResponseCode();
            String locHeader = conn.getHeaderField("Location");
            if (JavaDownloadAction.shouldFollowRedirect(code) && locHeader != null) {
                URI uri = URI.create(locHeader);
                if (!uri.isAbsolute()) {
                    locHeader = URLDecoder.decode(locHeader, "UTF-8");
                    url = new URL(new URL(url), locHeader).toExternalForm();
                } else {
                    url = uri.toString();
                }
                LOGGER.info("Following redirect to {}.", (Object)url);
                try {
                    conn.getInputStream().close();
                }
                catch (Throwable throwable) {}
                continue;
            }
            this.validateCode(code, conn.getResponseMessage());
            InputStream stream = conn.getInputStream();
            String eTagHeader = conn.getHeaderField("ETag");
            Date lastModifiedHeader = TimeUtils.parseDate(conn.getHeaderField("Last-Modified"));
            long contentLength = conn.getHeaderFieldLong("Content-Length", -1L);
            this.upToDate = this.calcUpToDate(code, lastModified, lastModifiedHeader);
            if (this.upToDate) {
                return;
            }
            if (this.downloadListener != null) {
                this.downloadListener.start(contentLength);
            }
            InputStream content = stream;
            if (this.downloadListener != null) {
                content = new ProgressInputStream(content, this.downloadListener);
            }
            if (!this.quiet) {
                LOGGER.info("Downloading '{}'.", (Object)url);
            }
            boolean success = false;
            try (InputStream is = content;
                 OutputStream os = dest.getOutputStream();){
                IOUtils.copy(is, os);
                success = true;
            }
            finally {
                if (!this.quiet) {
                    LOGGER.info("Finished '{}'. Success? {}", (Object)url, (Object)success);
                }
                dest.onFinished(success);
            }
            if (this.onlyIfModified && lastModifiedHeader != null) {
                dest.setLastModified(lastModifiedHeader.getTime());
            }
            if (this.useETag && eTagHeader != null) {
                dest.setEtag(eTagHeader);
            }
            return;
        }
    }

    private static boolean shouldFollowRedirect(int code) {
        return code >= 300 && code <= 307 && code != 306 && code != 304;
    }

    @Override
    public JavaDownloadAction setUrl(String url) {
        super.setUrl(url);
        return this;
    }

    @Override
    public JavaDownloadAction setDest(DownloadAction.Dest dest) {
        super.setDest(dest);
        return this;
    }

    @Override
    public JavaDownloadAction setDest(StringWriter sw) {
        super.setDest(sw);
        return this;
    }

    @Override
    public JavaDownloadAction setDest(OutputStream os) {
        super.setDest(os);
        return this;
    }

    @Override
    public JavaDownloadAction setDest(File file) {
        super.setDest(file);
        return this;
    }

    @Override
    public JavaDownloadAction setDest(Path path) {
        super.setDest(path);
        return this;
    }

    @Override
    public JavaDownloadAction setOnlyIfModified(boolean onlyIfModified) {
        super.setOnlyIfModified(onlyIfModified);
        return this;
    }

    @Override
    public JavaDownloadAction setUseETag(boolean useETag) {
        super.setUseETag(useETag);
        return this;
    }

    @Override
    public JavaDownloadAction setQuiet(boolean quiet) {
        super.setQuiet(quiet);
        return this;
    }

    @Override
    public JavaDownloadAction setUserAgent(String userAgent) {
        super.setUserAgent(userAgent);
        return this;
    }

    @Override
    public JavaDownloadAction addRequestHeader(String key, String value) {
        super.addRequestHeader(key, value);
        return this;
    }

    @Override
    public JavaDownloadAction setDownloadListener(DownloadListener downloadListener) {
        super.setDownloadListener(downloadListener);
        return this;
    }
}

