/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.repack.org.tukaani.xz;

import io.codechicken.repack.org.tukaani.xz.ArrayCache;
import io.codechicken.repack.org.tukaani.xz.FilterDecoder;
import io.codechicken.repack.org.tukaani.xz.LZMA2Coder;
import io.codechicken.repack.org.tukaani.xz.LZMA2InputStream;
import io.codechicken.repack.org.tukaani.xz.UnsupportedOptionsException;
import java.io.InputStream;

class LZMA2Decoder
extends LZMA2Coder
implements FilterDecoder {
    private int dictSize;

    LZMA2Decoder(byte[] props) throws UnsupportedOptionsException {
        if (props.length != 1 || (props[0] & 0xFF) > 37) {
            throw new UnsupportedOptionsException("Unsupported LZMA2 properties");
        }
        this.dictSize = 2 | props[0] & 1;
        this.dictSize <<= (props[0] >>> 1) + 11;
    }

    @Override
    public int getMemoryUsage() {
        return LZMA2InputStream.getMemoryUsage(this.dictSize);
    }

    @Override
    public InputStream getInputStream(InputStream in, ArrayCache arrayCache) {
        return new LZMA2InputStream(in, this.dictSize, null, arrayCache);
    }
}

