/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.diffpatch.util;

import io.codechicken.diffpatch.util.IOValidationException;
import io.codechicken.diffpatch.util.Utils;
import io.codechicken.diffpatch.util.archiver.ArchiveFormat;
import io.codechicken.diffpatch.util.archiver.ArchiveReader;
import io.codechicken.repack.net.covers1624.quack.collection.FastStream;
import io.codechicken.repack.net.covers1624.quack.io.IOUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public abstract class Input {
    public abstract void validate(String var1) throws IOValidationException;

    public static class FolderMultiInput
    extends MultiInput {
        public final Path folder;
        @Nullable
        private Map<String, Path> index;

        public FolderMultiInput(Path folder) {
            this.folder = folder;
        }

        @Override
        public void validate(String kind) throws IOValidationException {
            if (Files.notExists(this.folder, new LinkOption[0])) {
                throw new IOValidationException("Input '" + kind + "' does not exist.");
            }
            if (!Files.isDirectory(this.folder, new LinkOption[0])) {
                throw new IOValidationException("Expected input '" + kind + "' to be a directory.");
            }
        }

        @Override
        public void open(String prefix) throws IOException {
            if (this.index != null) {
                throw new IllegalStateException("Already opened.");
            }
            Path toIndex = !prefix.isEmpty() ? this.folder.resolve(prefix) : this.folder;
            try (Stream<Path> stream = Files.walk(toIndex, new FileVisitOption[0]);){
                this.index = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toMap(e -> Utils.stripStart('/', toIndex.relativize((Path)e).toString().replace("\\", "/")), Function.identity()));
            }
        }

        @Override
        public Set<String> index() throws IOException {
            if (this.index == null) {
                throw new IllegalStateException("Not opened.");
            }
            return Collections.unmodifiableSet(this.index.keySet());
        }

        @Override
        public byte @Nullable [] tryRead(String key) throws IOException {
            if (this.index == null) {
                throw new IllegalStateException("Not opened.");
            }
            Path path = this.index.get(key);
            if (path == null) {
                return null;
            }
            return Files.readAllBytes(path);
        }

        @Override
        public void close() {
        }
    }

    public static class PipeArchiveMultiInput
    extends ArchiveMultiInput {
        private final InputStream is;

        protected PipeArchiveMultiInput(ArchiveFormat format, InputStream is) {
            super(format);
            this.is = is;
        }

        @Override
        public void validate(String kind) {
        }

        @Override
        protected InputStream openStream() {
            return IOUtils.protectClose(this.is);
        }
    }

    public static class PathArchiveMultiInput
    extends ArchiveMultiInput {
        private final Path path;

        protected PathArchiveMultiInput(ArchiveFormat format, Path path) {
            super(format);
            this.path = path;
        }

        @Override
        public void validate(String kind) throws IOValidationException {
            if (Files.notExists(this.path, new LinkOption[0])) {
                throw new IOValidationException("Input '" + kind + "' does not exist.");
            }
        }

        @Override
        protected InputStream openStream() throws IOException {
            return Files.newInputStream(this.path, new OpenOption[0]);
        }
    }

    public static abstract class ArchiveMultiInput
    extends MultiInput {
        private final ArchiveFormat format;
        @Nullable
        private ArchiveReader ar;

        protected ArchiveMultiInput(ArchiveFormat format) {
            this.format = format;
        }

        protected abstract InputStream openStream() throws IOException;

        @Override
        public void open(String prefix) throws IOException {
            if (this.ar != null) {
                throw new IllegalStateException("Already opened.");
            }
            this.ar = this.format.createReader(this.openStream(), prefix);
        }

        @Override
        public Set<String> index() {
            if (this.ar == null) {
                throw new IllegalStateException("Not opened.");
            }
            return this.ar.getEntries();
        }

        @Override
        public byte @Nullable [] tryRead(String key) {
            if (this.ar == null) {
                throw new IllegalStateException("Not opened.");
            }
            return this.ar.getBytes(key);
        }

        @Override
        public void close() throws IOException {
            if (this.ar == null) {
                throw new IllegalStateException("Not opened.");
            }
            this.ar.close();
        }
    }

    public static abstract class MultiInput
    extends Input
    implements AutoCloseable {
        public static MultiInput archive(ArchiveFormat format, Path path) {
            return new PathArchiveMultiInput(format, path);
        }

        public static MultiInput detectedArchive(Path path) throws IllegalArgumentException {
            ArchiveFormat format = ArchiveFormat.findFormat(path);
            if (format == null) {
                throw new IllegalArgumentException("Unable to detect archive format for " + path.getFileName());
            }
            return MultiInput.archive(format, path);
        }

        public static MultiInput archive(ArchiveFormat format, byte[] bytes) {
            return MultiInput.archive(format, new ByteArrayInputStream(bytes));
        }

        public static MultiInput archive(ArchiveFormat format, InputStream stream) {
            return new PipeArchiveMultiInput(format, stream);
        }

        public static MultiInput folder(Path folder) {
            return new FolderMultiInput(folder);
        }

        public abstract void open(String var1) throws IOException;

        public abstract Set<String> index() throws IOException;

        public List<String> readLines(String key) throws IOException {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this.read(key)), StandardCharsets.UTF_8));){
                ArrayList<Stream<String>> arrayList = FastStream.of(reader.lines()).toList();
                return arrayList;
            }
        }

        public byte[] read(String key) throws IOException {
            byte[] data = this.tryRead(key);
            if (data != null) {
                return data;
            }
            throw new FileNotFoundException("Failed to find " + key + " in MultiInput.");
        }

        public abstract byte @Nullable [] tryRead(String var1) throws IOException;

        @Override
        public abstract void close() throws IOException;
    }

    public static abstract class SingleInput
    extends Input {
        public static SingleInput string(String str) {
            return new FromString(str, "pipe");
        }

        public static SingleInput string(String str, String name) {
            return new FromString(str, name);
        }

        public static SingleInput pipe(InputStream is) {
            return SingleInput.pipe(is, "pipe");
        }

        public static SingleInput pipe(InputStream is, String name) {
            return new FromStream(is, name);
        }

        public static SingleInput path(Path path, OpenOption ... opts) {
            return new FromPath(path, opts);
        }

        public abstract InputStream open() throws IOException;

        public List<String> readLines() throws IOException {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.open(), StandardCharsets.UTF_8));){
                ArrayList<Stream<String>> arrayList = FastStream.of(reader.lines()).toList();
                return arrayList;
            }
        }

        public abstract String name();

        public static class FromPath
        extends SingleInput {
            private final Path path;
            private final OpenOption[] opts;

            public FromPath(Path path, OpenOption ... opts) {
                this.path = path;
                this.opts = opts;
            }

            @Override
            public void validate(String kind) throws IOValidationException {
                if (Files.notExists(this.path, new LinkOption[0])) {
                    throw new IOValidationException("Input '" + kind + "' does not exist.");
                }
                if (!Files.isRegularFile(this.path, new LinkOption[0])) {
                    throw new IOValidationException("Input '" + kind + "' is not a file.");
                }
            }

            @Override
            public InputStream open() throws IOException {
                return Files.newInputStream(this.path, this.opts);
            }

            @Override
            public String name() {
                return this.path.toString();
            }
        }

        public static final class FromStream
        extends SingleInput {
            private final InputStream is;
            private final String name;

            public FromStream(InputStream is, String name) {
                this.is = is;
                this.name = name;
            }

            @Override
            public void validate(String kind) {
            }

            @Override
            public InputStream open() throws IOException {
                return IOUtils.protectClose(this.is);
            }

            @Override
            public String name() {
                return this.name;
            }
        }

        public static final class FromString
        extends SingleInput {
            private final String str;
            private final String name;

            public FromString(String str, String name) {
                this.str = str;
                this.name = name;
            }

            @Override
            public void validate(String kind) {
            }

            @Override
            public InputStream open() throws IOException {
                return new ByteArrayInputStream(this.str.getBytes(StandardCharsets.UTF_8));
            }

            @Override
            public List<String> readLines() throws IOException {
                try (BufferedReader reader = new BufferedReader(new StringReader(this.str));){
                    ArrayList<Stream<String>> arrayList = FastStream.of(reader.lines()).toList();
                    return arrayList;
                }
            }

            @Override
            public String name() {
                return this.name;
            }
        }
    }
}

