/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.repack.net.covers1624.quack.asm.annotation;

import io.codechicken.repack.net.covers1624.quack.annotation.Requires;
import io.codechicken.repack.net.covers1624.quack.util.SneakyUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;

@Requires(value="org.ow2.asm:asm")
public abstract class AnnotationParser
extends AnnotationVisitor {
    protected final ClassLookup abstractions;

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="0.5")
    protected AnnotationParser(ClassLookup abstractions) {
        this(null, abstractions);
    }

    protected AnnotationParser(@Nullable AnnotationVisitor delegate, ClassLookup abstractions) {
        super(589824, delegate);
        this.abstractions = abstractions;
    }

    public static AnnotationParser newVisitor(ClassLookup lookup, String desc, Consumer<Annotation> cons) throws AnnotationParseException {
        return AnnotationParser.newVisitor(null, lookup, desc, cons);
    }

    public static AnnotationParser newVisitor(@Nullable AnnotationVisitor delegate, ClassLookup lookup, String desc, final Consumer<Annotation> cons) throws AnnotationParseException {
        Class<? extends Annotation> clazz;
        try {
            clazz = lookup.getAnnotationClass(Type.getType((String)desc));
        }
        catch (Throwable ex) {
            throw new AnnotationParseException("Failed to load annotation.", ex);
        }
        return new AnnotationParser(delegate, lookup){
            private final Map<String, Object> values;
            {
                super(delegate, abstractions);
                this.values = new HashMap<String, Object>();
            }

            @Override
            public void visitValue(@Nullable String name, Object value) {
                assert (name != null);
                this.values.put(name, value);
            }

            public void visitEnd() {
                super.visitEnd();
                cons.accept((Annotation)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new AnnotationInvocationHandler(clazz, this.values)));
            }
        };
    }

    public abstract void visitValue(@Nullable String var1, Object var2);

    public void visit(@Nullable String name, Object value) {
        super.visit(name, (Object)value);
        if (value instanceof Type) {
            try {
                value = this.abstractions.getClass((Type)value);
            }
            catch (ClassNotFoundException ex) {
                throw new AnnotationParseException("Failed to load Type value.", ex);
            }
        }
        this.visitValue(name, value);
    }

    public void visitEnum(String name, String descriptor, String value) {
        super.visitEnum(name, descriptor, value);
        try {
            this.visitValue(name, Enum.valueOf(this.abstractions.getEnumClass(Type.getType((String)descriptor)), value));
        }
        catch (AnnotationParseException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new AnnotationParseException("Failed to parse enum constant " + value + " for " + descriptor, ex);
        }
    }

    public AnnotationVisitor visitAnnotation(String name, String descriptor) {
        return AnnotationParser.newVisitor(super.visitAnnotation(name, descriptor), this.abstractions, descriptor, v -> this.visitValue(name, v));
    }

    public AnnotationVisitor visitArray(final String name) {
        return new AnnotationParser(super.visitArray(name), this.abstractions){
            private final ArrayList<Object> values;
            {
                super(delegate, abstractions);
                this.values = new ArrayList(1);
            }

            @Override
            public void visitValue(@Nullable String name2, Object value) {
                assert (name2 == null);
                this.values.add(value);
            }

            public void visitEnd() {
                super.visitEnd();
                this.values.trimToSize();
                AnnotationParser.this.visitValue(name, this.values);
            }
        };
    }

    private static class AnnotationInvocationHandler
    implements InvocationHandler {
        private final Class<? extends Annotation> annotationType;
        private final Map<String, Object> members;

        AnnotationInvocationHandler(Class<? extends Annotation> annotationType, Map<String, Object> members) {
            this.annotationType = annotationType;
            this.members = members;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "hashCode": {
                    return this.members.hashCode();
                }
                case "equals": {
                    Object arg = args[0];
                    if (arg == null || !Proxy.isProxyClass(arg.getClass())) {
                        return false;
                    }
                    InvocationHandler o = Proxy.getInvocationHandler(arg);
                    if (!(o instanceof AnnotationInvocationHandler)) {
                        return false;
                    }
                    AnnotationInvocationHandler other = (AnnotationInvocationHandler)o;
                    return this.members.equals(other.members) && this.annotationType.equals(other.annotationType);
                }
                case "toString": {
                    return this.annotationType.getName() + this.members;
                }
                case "annotationType": {
                    return this.annotationType;
                }
            }
            return this.getMember(method);
        }

        private Object getMember(Method method) {
            Object obj = this.members.get(method.getName());
            if (obj == null) {
                return method.getDefaultValue();
            }
            Class<?> desiredType = method.getReturnType();
            if (desiredType.isArray() && obj instanceof List) {
                List objs = (List)obj;
                Object array = desiredType.equals(Object[].class) ? new Object[objs.size()] : Array.newInstance(desiredType.getComponentType(), objs.size());
                for (int i = 0; i < objs.size(); ++i) {
                    Array.set(array, i, objs.get(i));
                }
                obj = array;
                this.members.put(method.getName(), array);
            }
            if (desiredType.isArray() && Array.getLength(obj) != 0) {
                obj = this.cloneArray(obj);
            }
            return obj;
        }

        private Object cloneArray(Object array) {
            Class<?> type = array.getClass();
            if (type == boolean[].class) {
                return ((boolean[])array).clone();
            }
            if (type == byte[].class) {
                return ((byte[])array).clone();
            }
            if (type == char[].class) {
                return ((char[])array).clone();
            }
            if (type == short[].class) {
                return ((short[])array).clone();
            }
            if (type == int[].class) {
                return ((int[])array).clone();
            }
            if (type == float[].class) {
                return ((float[])array).clone();
            }
            if (type == long[].class) {
                return ((long[])array).clone();
            }
            if (type == double[].class) {
                return ((double[])array).clone();
            }
            return ((Object[])array).clone();
        }
    }

    public static class AnnotationParseException
    extends RuntimeException {
        public AnnotationParseException(String message) {
            super(message);
        }

        public AnnotationParseException(Throwable cause) {
            super(cause);
        }

        public AnnotationParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static interface ClassLookup {
        public static final ClassLookup DEFAULT = new ClassLookup(){};

        default public Class<?> getClass(Type type) throws ClassNotFoundException {
            return Class.forName(type.getClassName());
        }

        default public <T extends Enum<T>> Class<T> getEnumClass(Type type) throws ClassNotFoundException {
            Class<?> clazz = this.getClass(type);
            if (!clazz.isEnum()) {
                throw new IllegalArgumentException("Not an enum class. " + type);
            }
            return (Class)SneakyUtils.unsafeCast(clazz);
        }

        default public Class<? extends Annotation> getAnnotationClass(Type type) throws ClassNotFoundException {
            Class<?> clazz = this.getClass(type);
            if (!clazz.isAnnotation()) {
                throw new IllegalArgumentException("Not an annotation class. " + type);
            }
            return (Class)SneakyUtils.unsafeCast(clazz);
        }
    }
}

