/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.repack.net.covers1624.quack.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.codechicken.repack.net.covers1624.quack.annotation.Requires;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.Nullable;

@Requires(value="com.google.code.gson:gson")
public final class PathTypeAdapter
extends TypeAdapter<Path> {
    public void write(JsonWriter out, @Nullable Path value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        if (value.getFileSystem().provider() != FileSystems.getDefault().provider()) {
            throw new IOException("Only default FileSystem can be serialized.");
        }
        out.value(value.toAbsolutePath().toString());
    }

    @Nullable
    public Path read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        return Paths.get(in.nextString(), new String[0]);
    }
}

